/*

 ReaderResultTask.java
 
 Copyright 2004 KUBO Hiroya (hiroya@sfc.keio.ac.jp).
 
 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at
 
 http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 
 Created on 2004/11/01

 */
package net.sf.sqs_xml.reader.logic;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLEncoder;

import javax.jnlp.BasicService;
import javax.jnlp.ServiceManager;
import javax.jnlp.UnavailableServiceException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;

import net.sf.sqs_xml.httpd.MarkReaderHttpd;
import net.sf.sqs_xml.reader.swing.MarkReader;
import net.sf.sqs_xml.translator.logic.TranslatorException;
import net.sf.sqs_xml.util.FileUtil;
import net.sf.sqs_xml.util.JNLPBrowserLauncher;
import net.sf.sqs_xml.xmlns.SQSNamespaces;

/**
 * @author hiroya
 *
 */
class ReaderResultTask extends ReaderCoreTask{
    static final String MS932_FILE_ENCODING = "MS932";
    static final String UTF8_FILE_ENCODING = "UTF-8";

    public ReaderResultTask(BaseTaskSource source, BaseTaskTarget target, ReaderProcessView view){
        super(source, target, view);
    }
    
    public void save() throws TranslatorException, TransformerException, IOException, ParserConfigurationException, ThreadSuspendingException {
        String name = getSource().srcdir.getParent()+File.separator+getSource().srcdir.getName();
        File tgtdir = getSource().tgtdir;
        File allIndexFile = new File(tgtdir.getAbsolutePath()+File.separator+"all.html");
        File textareaIndexFile = new File(tgtdir.getAbsolutePath()+File.separator+"textarea.html");
        File markIndexFile = new File(tgtdir.getAbsolutePath()+File.separator+"mark.html");
        File indexHtml = new File(tgtdir.getAbsolutePath()+File.separator+"index.html");
        File csvfile = new File(tgtdir.getAbsolutePath()+File.separator+getSource().srcdir.getName()+"-csv.txt");
        if(processScanFramesTaskTarget.mapper.getNumErrorPages() == 0){// + engineState.getState().getNumErrorMarkSets()
            saveCSV(csvfile);
        }
        saveTextareaIndexHtml(textareaIndexFile, tgtdir);
        saveMarkIndexHtml(markIndexFile, tgtdir);
        saveAllHtml(allIndexFile, tgtdir);
        saveIndexHtml(tgtdir, indexHtml, allIndexFile, textareaIndexFile, markIndexFile, csvfile);
        //MarkReaderHttpd.getSingleton().getURL(getSource().srcdir);
        //showDocument(tgtdir);
        showDocument(indexHtml);
    }

    private void saveIndexHtml(File resultDir, File indexHtml, File allIndexFile, File textareaIndexFile, File markIndexFile, File csvfile) throws IOException {
        String encoding = UTF8_FILE_ENCODING; 
        PrintWriter out = FileUtil.createPrintWriter(indexHtml, encoding);
        File pdffile = (File)getSource().pdffileList.get(0);
        String pdfPath = FileFunctions.getRelativePath(getSource().tgtdir, pdffile);
        String baseURI = MarkReaderHttpd.getSingleton().getBase();
        baseURI = baseURI.substring(0, baseURI.length()-1);
        out.println("<?xml version=\"1.0\" encoding=\""+encoding+"\"?>");
        //out.println("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/xhtml1-strict.dtd\">");
        out.println("<html xmlns=\""+SQSNamespaces.XHTML_URI+"\" lang=\"ja\" xml:lang=\"ja\">");
        out.println("<head>");
        out.println("<meta http-equiv=\"Content-Type\" content=\"text/html; charset="+encoding+"\" />");
        out.println("<style type=\"text/css\">img{border-width:0} body{background-color: #fff} strong{color: #a30; background-color: #ffa; font-size: 90%;}h2{border-style: solid;border-width: 0em 0em 0em 1em;border-color: #183579;padding: 0.2em 0.7em 0.1em 0.3em;margin-bottom: 0.7em;margin-top: 0em;}");
        out.println("div.console{padding: 0.3em;}fieldset{background-color: #ddd;}legend{border-style: solid;border-color:#888;border-width: 0.05em 0.05em 0.00em 0.05em;padding: 0.2em 0.2em 0.2em 0.2em;color:#1835f9;background-color: #ddd;}");
        out.println("h3{border-style: solid;border-width: 0em 0em 0em 1em;border-color: #183579;padding: 0.2em 0.7em 0.1em 0.3em;margin: 1em 1em 1em 1em;margin-top: 1em;}");
        out.println("</style>");
        out.print("<title>");
        //out.print(getSource().srcdir.getAbsolutePath());
        out.print(indexHtml.getAbsolutePath());
        out.println("</title>");
        out.println("</head>");
        out.println("<body>");
        out.println("<h1><img src=\""+baseURI+"/sqs-logo.png\" alt=\"Shared Questionnaire System\"/></h1>");
        out.println("<p><strong>※現在表示されているWebページは [処理結果フォルダ]内のindex.htmlファイルの内容です．</strong></p>");
        
        out.println("<h2>処理対象フォルダ:<a href=\""+getSource().srcdir.toURI().toURL()+"\">"+getSource().srcdir.getAbsolutePath()+"</a></h2>");
        out.println("<ul>");
        out.println("<li><a href=\"../"+pdfPath+"\">印刷原稿PDFファイル: "+pdffile.getName()+"</a></li>");
        out.println("</ul>");
        out.println("<h2>処理結果フォルダ:<a href=\""+indexHtml.toURI().toURL()+"\">"+indexHtml.getAbsolutePath()+"</a></h2>");
        
        out.println("<h3>結果一覧:</h3>");
        out.println("<p><strong>※次の2x2の一覧ページ↓は，MarkReaderを起動していない時には，[処理結果フォルダ]内のファイルからアクセスしてください．</strong></p>");
        out.println("<ul>");
        out.println("<li>内容一覧:<ul>");
        out.println("<li><a href=\""+csvfile.getName()+"\">CSV形式: "+csvfile.getName()+"</a></li>");
        out.println("<li><a href=\""+markIndexFile.getName()+"\">HTML形式: "+markIndexFile.getName()+"</a></li>");
        out.println("</ul></li>");
        out.println("<li>画像一覧:<ul>");
        out.println("<li><a href=\""+allIndexFile.getName()+"\">マーク欄+自由記述欄画像の一覧: "+allIndexFile.getName()+"</a></li>");
        out.println("<li><a href=\""+textareaIndexFile.getName()+"\">自由記述欄画像の一覧: "+textareaIndexFile.getName()+"</a></li>");
        out.println("</ul></li>");
        out.println("</ul>");
        
        out.println("<h3>自由記述欄画像のテキスト起こし:</h3>");
        out.println("<p><strong>※次の2つのページ↓は，MarkReaderを起動してからアクセスしてください．</strong></p>");
        out.println("<ul>");
        out.println("<li><a href=\""+baseURI+MarkReaderHttpd.VIEW_URI+"?dir="+URLEncoder.encode(getSource().tgtdir.getAbsolutePath(), "UTF-8")+"&amp;src=all.html\">マーク欄+自由記述欄画像</a></li>");
        out.println("<li><a href=\""+baseURI+MarkReaderHttpd.VIEW_URI+"?dir="+URLEncoder.encode(getSource().tgtdir.getAbsolutePath(), "UTF-8")+"\">自由記述欄画像</a></li>");
        out.println("</ul>");  
        out.println("<p>CSV形式ファイル(-csv.txt)と，HTML形式(mark.html)の，該当部分のカラムが更新されます</p>");
        out.println("<hr/>");
        out.println("<div class=\"console\">");
        out.println("<form method=\"get\" action=\"http://sqs.cmr.sfc.keio.ac.jp/sqs-core/app/MarkReader.jnlp\">");
        out.println("<fieldset>");
        out.println("<legend>SQS MarkReaderの起動</legend>");
        out.println("<img src=\""+baseURI+"/reader.gif\" alt=\"SQS MarkReader\"/>");
        out.println("<input value=\"SQS MarkReaderの起動\" type=\"submit\"/>");
        out.println("</fieldset>");
        out.println("</form>");
        out.println("</div>");
        out.println("<address>Generated by <a href=\"http://sqs.cmr.sfc.keio.ac.jp/\">");
        out.println(MarkReader.TITLE);
        out.println("</a></address>");
        out.println("</body>");
        out.println("</html>");
        out.close();
    }

    private void showDocument(File indexHtml) throws IOException {
        URL url = MarkReaderHttpd.getSingleton().getURL(indexHtml);
        try{
            BasicService basicService = (BasicService)ServiceManager.lookup("javax.jnlp.BasicService");
            if(basicService.isWebBrowserSupported()){
                new JNLPBrowserLauncher(basicService).showDocument(url);
            }else{
                new net.sf.sqs_xml.util.AlbertBrowserLauncher().showDocument(url);
            }
        }catch(UnavailableServiceException ignore){
            new net.sf.sqs_xml.util.AlbertBrowserLauncher().showDocument(url);
        }
    }

    private void saveAllHtml(File allIndexFile, File resultDir) throws TransformerException, ThreadSuspendingException {
        while(true){
            try{
                initQuestionnaireStructureTaskTarget.resultBuilder.saveHTML(allIndexFile, UTF8_FILE_ENCODING, getSource().srcdir, resultDir,
                    ReaderResultBuilder.ALL_MODE);
                break;
            }catch(IOException ex){
                FileFunctions.confirmRetryPageSaving(view, ex, allIndexFile);
            }
        }
    }

    private void saveTextareaIndexHtml(File textareaIndexFile, File resultDir) throws TransformerException, ThreadSuspendingException {
        while(true){
            try{
                initQuestionnaireStructureTaskTarget.resultBuilder.saveHTML(textareaIndexFile, UTF8_FILE_ENCODING, getSource().srcdir, resultDir, 
                    ReaderResultBuilder.TEXTAREA_MODE);
                break;
            }catch(IOException ex){
                FileFunctions.confirmRetryPageSaving(view, ex, textareaIndexFile);
            }
        }
    }

    private void saveMarkIndexHtml(File markIndexFile, File resultDir) throws TransformerException, ThreadSuspendingException {
        while(true){
            try{
                initQuestionnaireStructureTaskTarget.resultBuilder.saveHTML(markIndexFile, UTF8_FILE_ENCODING, getSource().srcdir, resultDir, 
                    ReaderResultBuilder.MARK_MODE);
                break;
            }catch(IOException ex){
                FileFunctions.confirmRetryPageSaving(view, ex, markIndexFile);
            }
        }
    }

    private void saveCSV(File tgtfile) throws TransformerException, ThreadSuspendingException {
        while(true){
            try{
                if(tgtfile == null){
                    continue;
                }
                initQuestionnaireStructureTaskTarget.resultBuilder.saveCSV(tgtfile, MS932_FILE_ENCODING);
                break;
            }catch(IOException ex){
                FileFunctions.confirmRetryPageSaving(view, ex, tgtfile);            
            }
        }
    }
}
