/*
 * 
 * SQMMaker.java
 * 
 * Copyright 2004 KUBO Hiroya (hiroya@sfc.keio.ac.jp).
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */
package net.sf.sqs_xml.translator.swing;

import java.io.File;

import net.sf.sqs_xml.editor.sqs.swing.SQSFileChooser;
import net.sf.sqs_xml.swing.SwingUtil;
import net.sf.sqs_xml.translator.logic.PDFtoSQMTranslator;
import net.sf.sqs_xml.translator.logic.Translator;

public class SQMMaker extends SQSFileTranslator {
	//protected SQStoPDFLogic logic = null;
	static final String TITLE = "PDF to SQM Translator";
	public static void main(String args[]) throws Exception {
	    SwingUtil.Factory factory = new SwingUtil.Factory() {
			public Object create() throws Exception {
				return new PDFtoSQMTranslator();
			}
		};
		Translator translator = (PDFtoSQMTranslator) SwingUtil.newInstanceWithWaitPromptFrame(factory, TITLE, "Downloading Resources...");
		File src = null;
		if(0 < args.length){
		  src = new File(args[0]);
		  if(! src.canRead()){
		      src = null;
		  }
		}
		new SQMMaker(translator, src);
	}
	
	public SQMMaker(Translator translator, File src) throws Exception {
		super(null,TITLE,translator,
			SQSFileChooser.createSavePDFFileChooser(src),
			"PDF File: ",
			SQSFileChooser.createSaveSQMFileChooser(src),
			"SQM File: ");
		this.setVisible(true);
	}
	
}
