<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2004 SQS Development Team / Community Management Research Project.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xforms="http://www.w3.org/2002/xforms" xmlns:svg="http://www.w3.org/2000/svg" xmlns:sqs="http://sqs.cmr.sfc.keio.ac.jp/2004/sqs" version="1.0">
	<xsl:param name="mark-type">ellipse</xsl:param>
	<xsl:template name="mark-filled">
		<svg:svg width="4" height="16">
			<svg:g style="stroke:black; fill:black;">
				<xsl:choose>
					<xsl:when test="$mark-type='rect'">
						<svg:rect x="0" y="0" width="4" height="16"/>
					</xsl:when>
					<xsl:when test="$mark-type='ellipse'">
						<svg:ellipse cx="2" cy="8" rx="2" ry="8" stroke-width="0.03"/>
					</xsl:when>
				</xsl:choose>
			</svg:g>
		</svg:svg>
	</xsl:template>
	<xsl:template name="mark">
		<xsl:param name="ref"/>
		<xsl:call-template name="generic-mark">
			<xsl:with-param name="ref">
				<xsl:value-of select="$ref"/>
			</xsl:with-param>
			<xsl:with-param name="width">4</xsl:with-param>
			<xsl:with-param name="height">16</xsl:with-param>
		</xsl:call-template>
	</xsl:template>
	<xsl:template name="generic-mark">
		<xsl:param name="width"/>
		<xsl:param name="height"/>
		<xsl:param name="ref"/>
		<xsl:element name="svg:svg">
			<xsl:if test="0 &lt; string-length($ref)">
				<xsl:attribute name="id"><xsl:value-of select="$internal-destination-prefix-svg"/><xsl:value-of select="$ref"/></xsl:attribute>
			</xsl:if>
			<xsl:attribute name="width"><xsl:value-of select="$width"/></xsl:attribute>
			<xsl:attribute name="height"><xsl:value-of select="$height"/></xsl:attribute>
			<xsl:attribute name="sqs:callback">jp.sourceforge.sqs_xml.translator.SVGAnnotation</xsl:attribute>
			<xsl:if test="$disable-marksheet-mode!='true'">
				<xsl:call-template name="generic-mark-core">
					<xsl:with-param name="width"><xsl:value-of select="$width"/></xsl:with-param>
					<xsl:with-param name="height"><xsl:value-of select="$height"/></xsl:with-param>
				</xsl:call-template>
			</xsl:if>
		</xsl:element>
	</xsl:template>
	
	<xsl:template name="generic-mark-core">
		<xsl:param name="width"/>
		<xsl:param name="height"/>
				<xsl:choose>
				<xsl:when test="$mark-type='rect'">
					<svg:g svg:style="stroke:black; fill:black;">
						<svg:rect x="0" y="0" width="{$width}" height="5"/>
						<svg:rect x="0" y="{$height - 5}" width="{$width}" height="5"/>
					</svg:g>
					<svg:g style="stroke:white; fill:white;">
						<svg:rect x="1.5" y="3" width="{$width - 3}" height="{$height - 6}"/>
					</svg:g>
				</xsl:when>
				<xsl:when test="$mark-type='ellipse'">
					<svg:g style="stroke:black; fill:white;">
						<svg:ellipse style="stroke-width:0.03"
							 cx="{number($width) div 2}"
							 cy="{number($height) div 2}"
							 rx="{number($width) div 2}"
							 ry="{number($height) div 2.5}"/>
					</svg:g>
					<svg:g style="stroke:white; fill:white;">
						<svg:ellipse style="stroke-width:0.03"
							 cx="{number($width) div 2}"
							 cy="{number($height) div 2}"
							 rx="{number($width) div 2.4}"
							 ry="{number($height) div 2.8}"/>
					</svg:g>
				</xsl:when>
				</xsl:choose>
	</xsl:template>	
</xsl:stylesheet>
