/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sqs_xml.reader.model;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.sqs_xml.reader.model.IFormElementsChoice;
import net.sf.sqs_xml.reader.model.IRNSContainer;
import net.sf.sqs_xml.reader.model.IRNode;
import net.sf.sqs_xml.reader.model.RNSContext;
import net.sf.sqs_xml.reader.model.RStack;
import net.sf.sqs_xml.reader.model.UJAXP;
import net.sf.sqs_xml.reader.model.URelaxer;
import net.sf.sqs_xml.reader.model.URelaxer2;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class FormElementsMarkarea
implements Serializable,
Cloneable,
IRNSContainer,
IRNode,
IFormElementsChoice {
    private RNSContext rNSContext_ = new RNSContext(this, "http://sqs.cmr.sfc.keio.ac.jp/2004/reader");
    private String ref_;
    private double markDensity_;
    private Element xmlElement;
    private IRNode parentRNode_;

    public FormElementsMarkarea() {
        this.ref_ = "";
    }

    public FormElementsMarkarea(FormElementsMarkarea source) {
        this.setup(source);
    }

    public FormElementsMarkarea(RStack stack) {
        this.setup(stack);
    }

    public FormElementsMarkarea(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public FormElementsMarkarea(Element element) {
        this.setup(element);
    }

    public FormElementsMarkarea(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public FormElementsMarkarea(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public FormElementsMarkarea(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public FormElementsMarkarea(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public FormElementsMarkarea(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public FormElementsMarkarea(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(FormElementsMarkarea source) {
        this.ref_ = source.ref_;
        this.markDensity_ = source.markDensity_;
    }

    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public void setup(Element element) {
        this.init(element);
    }

    public void setup(RStack stack) {
        this.init(stack.popElement());
    }

    private void init(Element element) {
        this.xmlElement = element;
        RStack stack = new RStack(element);
        this.rNSContext_.declareNamespace(element);
        this.ref_ = URelaxer.getAttributePropertyAsString(element, "ref");
        this.markDensity_ = URelaxer.getElementPropertyAsDouble(stack.popElement());
    }

    public Object clone() {
        return new FormElementsMarkarea(this);
    }

    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElementNS("http://sqs.cmr.sfc.keio.ac.jp/2004/reader", "markarea");
        this.rNSContext_.setupNamespace(element);
        if (this.ref_ != null) {
            URelaxer.setAttributePropertyByString(element, "ref", this.ref_);
        }
        URelaxer2.setElementPropertyByDouble(element, "http://sqs.cmr.sfc.keio.ac.jp/2004/reader", "markDensity", this.markDensity_, this.rNSContext_);
        parent.appendChild(element);
    }

    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 2));
    }

    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 2));
    }

    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 2));
    }

    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 2));
    }

    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 2));
    }

    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public RNSContext rGetRNSContext() {
        return this.rNSContext_;
    }

    public void rSetRNSContext(RNSContext rNSContext) {
        this.rNSContext_ = rNSContext;
    }

    public String getRef() {
        return this.ref_;
    }

    public void setRef(String ref) {
        this.ref_ = ref;
    }

    public double getMarkDensity() {
        return this.markDensity_;
    }

    public void setMarkDensity(double markDensity) {
        this.markDensity_ = markDensity;
    }

    public Element rGetElement() {
        return this.xmlElement;
    }

    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    public void makeTextElement(StringBuffer buffer) {
        String prefix = this.rNSContext_.getPrefixByUri("http://sqs.cmr.sfc.keio.ac.jp/2004/reader");
        buffer.append("<");
        URelaxer.makeQName(prefix, "markarea", buffer);
        this.rNSContext_.makeNSMappings(buffer);
        if (this.ref_ != null) {
            buffer.append(" ");
            buffer.append("ref");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getRef())));
            buffer.append("\"");
        }
        buffer.append(">");
        buffer.append("<");
        URelaxer.makeQName(prefix, "markDensity", buffer);
        buffer.append(">");
        buffer.append(URelaxer.getString(this.getMarkDensity()));
        buffer.append("</");
        URelaxer.makeQName(prefix, "markDensity", buffer);
        buffer.append(">");
        buffer.append("</");
        URelaxer.makeQName(prefix, "markarea", buffer);
        buffer.append(">");
    }

    public void makeTextElement(Writer buffer) throws IOException {
        String prefix = this.rNSContext_.getPrefixByUri("http://sqs.cmr.sfc.keio.ac.jp/2004/reader");
        buffer.write("<");
        URelaxer.makeQName(prefix, "markarea", buffer);
        this.rNSContext_.makeNSMappings(buffer);
        if (this.ref_ != null) {
            buffer.write(" ");
            buffer.write("ref");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getRef())));
            buffer.write("\"");
        }
        buffer.write(">");
        buffer.write("<");
        URelaxer.makeQName(prefix, "markDensity", buffer);
        buffer.write(">");
        buffer.write(URelaxer.getString(this.getMarkDensity()));
        buffer.write("</");
        URelaxer.makeQName(prefix, "markDensity", buffer);
        buffer.write(">");
        buffer.write("</");
        URelaxer.makeQName(prefix, "markarea", buffer);
        buffer.write(">");
    }

    public void makeTextElement(PrintWriter buffer) {
        String prefix = this.rNSContext_.getPrefixByUri("http://sqs.cmr.sfc.keio.ac.jp/2004/reader");
        buffer.print("<");
        URelaxer.makeQName(prefix, "markarea", buffer);
        this.rNSContext_.makeNSMappings(buffer);
        if (this.ref_ != null) {
            buffer.print(" ");
            buffer.print("ref");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getRef())));
            buffer.print("\"");
        }
        buffer.print(">");
        buffer.print("<");
        URelaxer.makeQName(prefix, "markDensity", buffer);
        buffer.print(">");
        buffer.print(URelaxer.getString(this.getMarkDensity()));
        buffer.print("</");
        URelaxer.makeQName(prefix, "markDensity", buffer);
        buffer.print(">");
        buffer.print("</");
        URelaxer.makeQName(prefix, "markarea", buffer);
        buffer.print(">");
    }

    public void makeTextAttribute(StringBuffer buffer) {
    }

    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    public void makeTextAttribute(PrintWriter buffer) {
    }

    public String getRefAsString() {
        return URelaxer.getString(this.getRef());
    }

    public String getMarkDensityAsString() {
        return URelaxer.getString(this.getMarkDensity());
    }

    public void setRefByString(String string) {
        this.setRef(string);
    }

    public void setMarkDensityByString(String string) {
        this.setMarkDensity(Double.parseDouble(string));
    }

    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    public IRNode rGetParentRNode() {
        return this.parentRNode_;
    }

    public void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    public IRNode[] rGetRNodes() {
        ArrayList classNodes = new ArrayList();
        IRNode[] nodes = new IRNode[classNodes.size()];
        return classNodes.toArray(nodes);
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer2.isTargetElement(element, "http://sqs.cmr.sfc.keio.ac.jp/2004/reader", "markarea")) {
            return false;
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        if (!URelaxer.hasAttributeHungry(target, "ref")) {
            return false;
        }
        $match$ = true;
        Element child = target.popElement();
        if (child == null) {
            return false;
        }
        if (!URelaxer2.isTargetElement(child, "http://sqs.cmr.sfc.keio.ac.jp/2004/reader", "markDensity")) {
            return false;
        }
        $match$ = true;
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return FormElementsMarkarea.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (FormElementsMarkarea.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

