/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.Barcode128;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.IntHashtable;
import com.lowagie.text.pdf.PdfContentByte;
import java.awt.Color;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;

public class BarcodeEAN128
extends Barcode128 {
    public static HashMap ids;
    public static IntHashtable codesB;
    private String codeText = "";
    private StringBuffer bCode = new StringBuffer(50);
    private int checksum = 0;
    private int ponderation = 2;

    static {
        codesB = new IntHashtable(100);
        ids = new HashMap(10000);
        ids.put("00", new IdentifierEAN("00", "n2+n18", 20, false));
        ids.put("01", new IdentifierEAN("01", "n2+n14", 16, false));
        ids.put("02", new IdentifierEAN("02", "n2+n14", 16, false));
        ids.put("10", new IdentifierEAN("10", "n2+an...20", -1, true));
        ids.put("11", new IdentifierEAN("11", "n2+n6", 8, false));
        ids.put("13", new IdentifierEAN("13", "n2+n6", 8, false));
        ids.put("15", new IdentifierEAN("15", "n2+n6", 8, false));
        ids.put("17", new IdentifierEAN("17", "n2+n6", 8, false));
        ids.put("20", new IdentifierEAN("20", "n2+n6", 8, false));
        ids.put("21", new IdentifierEAN("21", "n2+an...20", -1, true));
        ids.put("22", new IdentifierEAN("22", "n2+an...29", -1, true));
        ids.put("230", new IdentifierEAN("230", "n3+n...19", -1, true));
        ids.put("231", new IdentifierEAN("231", "n3+n...19", -1, true));
        ids.put("232", new IdentifierEAN("232", "n3+n...19", -1, true));
        ids.put("233", new IdentifierEAN("233", "n3+n...19", -1, true));
        ids.put("234", new IdentifierEAN("234", "n3+n...19", -1, true));
        ids.put("235", new IdentifierEAN("235", "n3+n...19", -1, true));
        ids.put("236", new IdentifierEAN("236", "n3+n...19", -1, true));
        ids.put("237", new IdentifierEAN("237", "n3+n...19", -1, true));
        ids.put("238", new IdentifierEAN("238", "n3+n...19", -1, true));
        ids.put("239", new IdentifierEAN("239", "n3+n...19", -1, true));
        ids.put("240", new IdentifierEAN("240", "n3+an...30", -1, true));
        ids.put("241", new IdentifierEAN("241", "n3+an...30", -1, true));
        ids.put("250", new IdentifierEAN("250", "n3+an...30", -1, true));
        ids.put("30", new IdentifierEAN("30", "n2+n...8", -1, true));
        int i = 3100;
        while (i < 3700) {
            ids.put("" + i, new IdentifierEAN("" + i, "n2+n...8", -1, true));
            ++i;
        }
        ids.put("337", new IdentifierEAN("337", "n4+n6", 10, false));
        ids.put("37", new IdentifierEAN("37", "n2+n...8", -1, true));
        ids.put("400", new IdentifierEAN("400", "n3+an...30", -1, true));
        ids.put("401", new IdentifierEAN("401", "n3+an...30", -1, true));
        ids.put("402", new IdentifierEAN("402", "n3+n17", 20, false));
        ids.put("403", new IdentifierEAN("403", "n3+an...30", -1, true));
        ids.put("410", new IdentifierEAN("410", "n3+n13", 16, false));
        ids.put("411", new IdentifierEAN("411", "n3+n13", 16, false));
        ids.put("412", new IdentifierEAN("412", "n3+n13", 16, false));
        ids.put("413", new IdentifierEAN("413", "n3+n13", 16, false));
        ids.put("414", new IdentifierEAN("414", "n3+n13", 16, false));
        ids.put("420", new IdentifierEAN("420", "n3+an...9", -1, true));
        ids.put("421", new IdentifierEAN("421", "n3+n3+an...9", -1, true));
        ids.put("422", new IdentifierEAN("422", "n3+n3", 6, false));
        ids.put("8001", new IdentifierEAN("8001", "n4+n14", 18, false));
        ids.put("8002", new IdentifierEAN("8002", "n4+an...30", -1, true));
        ids.put("8003", new IdentifierEAN("8003", "n4+n14+an...16", -1, true));
        ids.put("8004", new IdentifierEAN("8004", "n4+an...30", -1, true));
        ids.put("8005", new IdentifierEAN("8005", "n4+n6", 10, false));
        ids.put("8006", new IdentifierEAN("8006", "n4+n14+n2+n2", 22, false));
        ids.put("8018", new IdentifierEAN("8018", "n4+n18", 22, false));
        ids.put("8100", new IdentifierEAN("8100", "n4+n1+n5", 10, false));
        ids.put("8101", new IdentifierEAN("8101", "n4+n1+n5+n4", 14, false));
        ids.put("8102", new IdentifierEAN("8102", "n4+n1+n1", 6, false));
        ids.put("90", new IdentifierEAN("90", "n2+an...30", -1, true));
        int j = 91;
        while (j < 100) {
            ids.put("" + j, new IdentifierEAN("" + j, "n2+an...30", -1, true));
            ++j;
        }
        int k = 0;
        while (k < 95) {
            codesB.put(k + 32, k);
            ++k;
        }
        k = 95;
        while (k < 196) {
            codesB.put(k - 95 + 195, k);
            ++k;
        }
    }

    public BarcodeEAN128() {
        try {
            this.x = 0.8f;
            this.font = BaseFont.createFont("Helvetica", "winansi", false);
            this.baseline = this.size = 8.0f;
            this.barHeight = this.size * 3.0f;
            this.textAlignment = 1;
            this.codeType = 10;
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
    }

    public Rectangle getBarcodeSize(float fullWidth) {
        float fontX = 0.0f;
        float fontY = 0.0f;
        if (this.font != null) {
            fontY = this.baseline > 0.0f ? this.baseline - this.font.getFontDescriptor(3, this.size) : -this.baseline + this.size;
            String fullCode = this.codeText;
            fontX = this.font.getWidthPoint(fullCode, this.size);
        }
        float maxWidth = Math.max(fullWidth, fontX);
        float fullHeight = this.barHeight + fontY;
        return new Rectangle(maxWidth, fullHeight);
    }

    public byte[] getBarsEAN128(String text) {
        LinkedList<byte[]> barres = new LinkedList<byte[]>();
        int tLen = text.length();
        if (tLen == 0) {
            barres.add(Barcode128.BARS[104]);
            this.bCode.append('\u00cc');
            barres.add(Barcode128.BARS[102]);
            this.bCode.append('\u00ca');
            return this.getBarsArray(barres);
        }
        int index = 0;
        barres.add(Barcode128.BARS[105]);
        this.bCode.append('\u00cd');
        barres.add(Barcode128.BARS[102]);
        this.bCode.append('\u00ca');
        this.checksum += 105;
        this.checksum += 102;
        String bloc = "";
        while (bloc != null) {
            bloc = this.getBloc(text, index);
            if (bloc == null) continue;
            index += bloc.length();
            this.bCode.append(bloc);
            barres.add(this.getBarsCode(bloc));
        }
        int chck = this.checksum % 103;
        barres.add(Barcode128.BARS[chck]);
        this.bCode.append((char)chck);
        barres.add(Barcode128.BARS_STOP);
        this.bCode.append('\u0000');
        byte[] array = this.getBarsArray(barres);
        return array;
    }

    public Rectangle placeBarcode(PdfContentByte cb, Color barColor, Color textColor) {
        String fullCode = this.code;
        float fontX = 0.0f;
        byte[] bars = this.getBarsEAN128(this.code);
        if (this.font != null) {
            fontX = this.font.getWidthPoint(this.codeText, this.size);
        }
        float barStartY = 0.0f;
        float textStartY = 0.0f;
        if (this.font != null) {
            if (this.baseline <= 0.0f) {
                textStartY = this.barHeight - this.baseline;
            } else {
                textStartY = -this.font.getFontDescriptor(3, this.size);
                barStartY = textStartY + this.baseline;
            }
        }
        boolean print = true;
        float fullWidth = (float)(bars.length / 6 * 11 + 2) * this.x;
        float barStartX = 0.0f;
        float textStartX = 0.0f;
        switch (this.textAlignment) {
            case 0: {
                break;
            }
            case 2: {
                if (fontX > fullWidth) {
                    barStartX = fontX - fullWidth;
                    break;
                }
                textStartX = fullWidth - fontX;
                break;
            }
            default: {
                if (fontX > fullWidth) {
                    barStartX = (fontX - fullWidth) / 2.0f;
                    break;
                }
                textStartX = (fullWidth - fontX) / 2.0f;
            }
        }
        if (barColor != null) {
            cb.setColorFill(barColor);
        }
        int k = 0;
        while (k < bars.length) {
            float w = (float)bars[k] * this.x;
            if (print) {
                cb.rectangle(barStartX, barStartY, w, this.barHeight);
            }
            print = !print;
            barStartX += w;
            ++k;
        }
        cb.fill();
        if (this.font != null) {
            if (textColor != null) {
                cb.setColorFill(textColor);
            }
            cb.beginText();
            cb.setFontAndSize(this.font, this.size);
            cb.setTextMatrix(textStartX, textStartY);
            cb.showText(this.codeText);
            cb.endText();
        }
        return this.getBarcodeSize(fullWidth);
    }

    protected byte[] getBarsCode(String bloc) {
        try {
            int j;
            int taille = 0;
            String currentData = bloc;
            boolean hasSeparator = bloc.endsWith("\u00ca");
            if (hasSeparator) {
                currentData = bloc.substring(0, bloc.length() - 1);
                ++taille;
            }
            int index = 0;
            if (currentData.length() % 2 != 0) {
                taille = taille + (currentData.length() + 1) / 2 + 2;
                index = currentData.length() - 1;
            } else {
                taille += currentData.length() / 2;
                index = currentData.length();
            }
            byte[] bars = new byte[taille * 6];
            int[] buffer = new int[2];
            int k = 0;
            int i = 0;
            while (i < index && currentData != null && !"".equals(currentData)) {
                buffer[0] = Integer.parseInt("" + currentData.charAt(0));
                buffer[1] = Integer.parseInt("" + currentData.charAt(1));
                currentData = currentData.substring(2);
                int value = buffer[0] * 10 + buffer[1];
                byte[] newBars = Barcode128.BARS[value];
                this.checksum += this.ponderation * value;
                ++this.ponderation;
                j = 0;
                while (j < 6) {
                    bars[k] = Barcode128.BARS[value][j];
                    ++k;
                    ++j;
                }
                i += 2;
            }
            if (currentData != null && currentData.length() > 0) {
                char c = currentData.charAt(0);
                this.checksum += this.ponderation * 100;
                ++this.ponderation;
                int j2 = 0;
                while (j2 < 6) {
                    bars[k] = Barcode128.BARS[100][j2];
                    ++k;
                    ++j2;
                }
                int integer = codesB.get(c);
                j = 0;
                while (j < 6) {
                    bars[k] = Barcode128.BARS[integer][j];
                    ++k;
                    ++j;
                }
                this.checksum += this.ponderation * integer;
                ++this.ponderation;
                this.checksum += this.ponderation * 99;
                ++this.ponderation;
                j = 0;
                while (j < 6) {
                    bars[k] = Barcode128.BARS[99][j];
                    ++k;
                    ++j;
                }
            }
            if (hasSeparator) {
                this.checksum += this.ponderation * 102;
                ++this.ponderation;
                int j3 = 0;
                while (j3 < 6) {
                    bars[k] = Barcode128.BARS[102][j3];
                    ++k;
                    ++j3;
                }
            }
            return bars;
        }
        catch (Exception t) {
            throw new ExceptionConverter(t);
        }
    }

    /*
     * Unable to fully structure code
     */
    protected String getBloc(String texte, int index) {
        key = null;
        bloc = null;
        iter = BarcodeEAN128.ids.keySet().iterator();
        left = texte.substring(index);
        if (left != null && !"".equals(left.trim())) ** GOTO lbl11
        return bloc;
lbl-1000:
        // 1 sources

        {
            code = (String)iter.next();
            if (!left.startsWith(code)) continue;
            key = code;
            this.codeText = String.valueOf(this.codeText) + "(" + key + ")";
lbl11:
            // 3 sources

            ** while (key == null && iter.hasNext())
        }
lbl12:
        // 1 sources

        id = (IdentifierEAN)BarcodeEAN128.ids.get(key);
        if (id != null) {
            if (id.isVariable()) {
                endBloc = left.indexOf(202);
                if (endBloc > 0) {
                    bloc = left.substring(0, endBloc + 1);
                    this.codeText = key != null ? String.valueOf(this.codeText) + bloc.substring(key.length(), endBloc) : String.valueOf(this.codeText) + bloc.substring(0, endBloc);
                } else {
                    bloc = left;
                    this.codeText = key != null ? String.valueOf(this.codeText) + bloc.substring(key.length()) : String.valueOf(this.codeText) + bloc;
                }
            } else {
                bloc = texte.substring(index, index + id.getSize());
                this.codeText = key != null ? String.valueOf(this.codeText) + bloc.substring(key.length()) : String.valueOf(this.codeText) + bloc;
            }
        }
        return bloc;
    }

    private byte[] getBarsArray(LinkedList barres) {
        Iterator iter = barres.iterator();
        int taille = 0;
        while (iter.hasNext()) {
            taille += ((byte[])iter.next()).length;
        }
        byte[] out = new byte[taille];
        iter = barres.iterator();
        int k = 0;
        while (iter.hasNext()) {
            byte[] barre = (byte[])iter.next();
            int i = 0;
            while (i < barre.length) {
                out[k] = barre[i];
                ++k;
                ++i;
            }
        }
        return out;
    }

    public Rectangle getBarcodeSize() {
        int idx;
        String fullCode;
        float fontX = 0.0f;
        float fontY = 0.0f;
        if (this.font != null) {
            fontY = this.baseline > 0.0f ? this.baseline - this.font.getFontDescriptor(3, this.size) : -this.baseline + this.size;
            fullCode = this.code;
            if (this.codeType == 11) {
                idx = this.code.indexOf(65535);
                fullCode = idx < 0 ? "" : this.code.substring(idx + 1);
            }
            fontX = this.font.getWidthPoint(fullCode, this.size);
        }
        fullCode = this.codeType == 11 ? ((idx = this.code.indexOf(65535)) >= 0 ? this.code.substring(0, idx) : this.code) : String.valueOf(307) + this.code;
        int len = fullCode.length();
        float fullWidth = (float)((len + 2) * 11) * this.x + 2.0f * this.x;
        fullWidth = Math.max(fullWidth, fontX);
        float fullHeight = this.barHeight + fontY;
        return new Rectangle(fullWidth, fullHeight);
    }

    public static class IdentifierEAN {
        private boolean variable;
        private String id;
        private String format;
        private int size;

        public IdentifierEAN(String id, String format, int size, boolean variable) {
            this.id = id;
            this.format = format;
            this.variable = variable;
            this.size = size;
        }

        public boolean isVariable() {
            return this.variable;
        }

        public void setVariable(boolean variable) {
            this.variable = variable;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getFormat() {
            return this.format;
        }

        public void setFormat(String format) {
            this.format = format;
        }

        public int getSize() {
            return this.size;
        }

        public void setSize(int size) {
            this.size = size;
        }
    }
}

