/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Chunk;
import com.lowagie.text.DocumentException;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.BidiLine;
import com.lowagie.text.pdf.PdfChunk;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDocument;
import com.lowagie.text.pdf.PdfFont;
import com.lowagie.text.pdf.PdfLine;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;

public class ColumnText {
    public static final int AR_NOVOWEL = 1;
    public static final int AR_COMPOSEDTASHKEEL = 4;
    public static final int AR_LIG = 8;
    public static final int DIGITS_EN2AN = 32;
    public static final int DIGITS_AN2EN = 64;
    public static final int DIGITS_EN2AN_INIT_LR = 96;
    public static final int DIGITS_EN2AN_INIT_AL = 128;
    public static final int DIGIT_TYPE_AN = 0;
    public static final int DIGIT_TYPE_AN_EXTENDED = 256;
    protected int runDirection = 0;
    public static final float GLOBAL_SPACE_CHAR_RATIO = 0.0f;
    public static final int NO_MORE_TEXT = 1;
    public static final int NO_MORE_COLUMN = 2;
    protected static final int LINE_STATUS_OK = 0;
    protected static final int LINE_STATUS_OFFLIMITS = 1;
    protected static final int LINE_STATUS_NOLINE = 2;
    protected float maxY;
    protected float minY;
    protected int alignment = 0;
    protected ArrayList leftWall;
    protected ArrayList rightWall;
    protected BidiLine bidiLine = new BidiLine();
    protected float yLine;
    protected float currentLeading = 16.0f;
    protected float fixedLeading = 16.0f;
    protected float multipliedLeading = 0.0f;
    protected PdfContentByte canvas;
    protected int lineStatus;
    protected float indent = 0.0f;
    protected float followingIndent = 0.0f;
    protected float rightIndent = 0.0f;
    protected float extraParagraphSpace = 0.0f;
    protected float rectangularWidth = -1.0f;
    private float spaceCharRatio = 0.0f;
    private boolean lastWasNewline = true;
    private int linesWritten;
    private int arabicOptions = 0;
    protected float descender;

    public ColumnText(PdfContentByte canvas) {
        this.canvas = canvas;
    }

    public static ColumnText duplicate(ColumnText org) {
        ColumnText ct = new ColumnText(null);
        ct.setSimpleVars(org);
        ct.bidiLine = new BidiLine(org.bidiLine);
        return ct;
    }

    public ColumnText setACopy(ColumnText org) {
        this.setSimpleVars(org);
        this.bidiLine = new BidiLine(org.bidiLine);
        return this;
    }

    protected void setSimpleVars(ColumnText org) {
        this.maxY = org.maxY;
        this.minY = org.minY;
        this.alignment = org.alignment;
        this.leftWall = null;
        if (org.leftWall != null) {
            this.leftWall = new ArrayList(org.leftWall);
        }
        this.rightWall = null;
        if (org.rightWall != null) {
            this.rightWall = new ArrayList(org.rightWall);
        }
        this.yLine = org.yLine;
        this.currentLeading = org.currentLeading;
        this.fixedLeading = org.fixedLeading;
        this.multipliedLeading = org.multipliedLeading;
        this.canvas = org.canvas;
        this.lineStatus = org.lineStatus;
        this.indent = org.indent;
        this.followingIndent = org.followingIndent;
        this.rightIndent = org.rightIndent;
        this.extraParagraphSpace = org.extraParagraphSpace;
        this.rectangularWidth = org.rectangularWidth;
        this.spaceCharRatio = org.spaceCharRatio;
        this.lastWasNewline = org.lastWasNewline;
        this.linesWritten = org.linesWritten;
        this.arabicOptions = org.arabicOptions;
        this.descender = org.descender;
    }

    public void addText(Phrase phrase) {
        Iterator j = ((AbstractList)phrase.getChunks()).iterator();
        while (j.hasNext()) {
            this.bidiLine.addChunk(new PdfChunk((Chunk)j.next(), null));
        }
    }

    public void addText(Chunk chunk) {
        this.bidiLine.addChunk(new PdfChunk(chunk, null));
    }

    protected ArrayList convertColumn(float[] cLine) {
        if (cLine.length < 4) {
            throw new RuntimeException("No valid column line found.");
        }
        ArrayList<float[]> cc = new ArrayList<float[]>();
        int k = 0;
        while (k < cLine.length - 2) {
            float x1 = cLine[k];
            float y1 = cLine[k + 1];
            float x2 = cLine[k + 2];
            float y2 = cLine[k + 3];
            if (y1 != y2) {
                float a = (x1 - x2) / (y1 - y2);
                float b = x1 - a * y1;
                float[] r = new float[]{Math.min(y1, y2), Math.max(y1, y2), a, b};
                cc.add(r);
                this.maxY = Math.max(this.maxY, r[1]);
                this.minY = Math.min(this.minY, r[0]);
            }
            k += 2;
        }
        if (cc.size() == 0) {
            throw new RuntimeException("No valid column line found.");
        }
        return cc;
    }

    protected float findLimitsPoint(ArrayList wall) {
        this.lineStatus = 0;
        if (this.yLine < this.minY || this.yLine > this.maxY) {
            this.lineStatus = 1;
            return 0.0f;
        }
        int k = 0;
        while (k < wall.size()) {
            float[] r = (float[])wall.get(k);
            if (!(this.yLine < r[0]) && !(this.yLine > r[1])) {
                return r[2] * this.yLine + r[3];
            }
            ++k;
        }
        this.lineStatus = 2;
        return 0.0f;
    }

    protected float[] findLimitsOneLine() {
        float x1 = this.findLimitsPoint(this.leftWall);
        if (this.lineStatus == 1 || this.lineStatus == 2) {
            return null;
        }
        float x2 = this.findLimitsPoint(this.rightWall);
        if (this.lineStatus == 2) {
            return null;
        }
        return new float[]{x1, x2};
    }

    protected float[] findLimitsTwoLines() {
        float[] x2;
        float[] x1;
        boolean repeat = false;
        while (true) {
            if (repeat && this.currentLeading == 0.0f) {
                return null;
            }
            repeat = true;
            x1 = this.findLimitsOneLine();
            if (this.lineStatus == 1) {
                return null;
            }
            this.yLine -= this.currentLeading;
            if (this.lineStatus == 2) continue;
            x2 = this.findLimitsOneLine();
            if (this.lineStatus == 1) {
                return null;
            }
            if (this.lineStatus == 2) {
                this.yLine -= this.currentLeading;
                continue;
            }
            if (!(x1[0] >= x2[1]) && !(x2[0] >= x1[1])) break;
        }
        return new float[]{x1[0], x1[1], x2[0], x2[1]};
    }

    public void setColumns(float[] leftLine, float[] rightLine) {
        this.rightWall = this.convertColumn(rightLine);
        this.leftWall = this.convertColumn(leftLine);
        this.rectangularWidth = -1.0f;
    }

    public void setSimpleColumn(Phrase phrase, float llx, float lly, float urx, float ury, float leading, int alignment) {
        this.addText(phrase);
        this.setSimpleColumn(llx, lly, urx, ury, leading, alignment);
    }

    public void setSimpleColumn(float llx, float lly, float urx, float ury, float leading, int alignment) {
        float[] leftLine = new float[4];
        float[] rightLine = new float[4];
        leftLine[0] = Math.min(llx, urx);
        leftLine[1] = Math.max(lly, ury);
        leftLine[2] = leftLine[0];
        leftLine[3] = Math.min(lly, ury);
        rightLine[0] = Math.max(llx, urx);
        rightLine[1] = leftLine[1];
        rightLine[2] = rightLine[0];
        rightLine[3] = leftLine[3];
        this.setColumns(leftLine, rightLine);
        this.setLeading(leading);
        this.alignment = alignment;
        this.yLine = leftLine[1];
        this.rectangularWidth = Math.abs(llx - urx);
    }

    public void setLeading(float leading) {
        this.fixedLeading = leading;
        this.multipliedLeading = 0.0f;
    }

    public void setLeading(float fixedLeading, float multipliedLeading) {
        this.fixedLeading = fixedLeading;
        this.multipliedLeading = multipliedLeading;
    }

    public float getLeading() {
        return this.fixedLeading;
    }

    public float getMultipliedLeading() {
        return this.multipliedLeading;
    }

    public void setYLine(float yLine) {
        this.yLine = yLine;
    }

    public float getYLine() {
        return this.yLine;
    }

    public void setAlignment(int alignment) {
        this.alignment = alignment;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setIndent(float indent) {
        this.indent = indent;
        this.lastWasNewline = true;
    }

    public float getIndent() {
        return this.indent;
    }

    public void setFollowingIndent(float indent) {
        this.followingIndent = indent;
        this.lastWasNewline = true;
    }

    public float getFollowingIndent() {
        return this.followingIndent;
    }

    public void setRightIndent(float indent) {
        this.rightIndent = indent;
        this.lastWasNewline = true;
    }

    public float getRightIndent() {
        return this.rightIndent;
    }

    public int go() throws DocumentException {
        return this.go(false);
    }

    public int go(boolean simulate) throws DocumentException {
        int status;
        PdfContentByte text;
        boolean dirty;
        block25: {
            this.descender = 0.0f;
            this.linesWritten = 0;
            dirty = false;
            float ratio = this.spaceCharRatio;
            Object[] currentValues = new Object[2];
            PdfFont currentFont = null;
            Float lastBaseFactor = new Float(0.0f);
            currentValues[1] = lastBaseFactor;
            PdfDocument pdf = null;
            PdfContentByte graphics = null;
            text = null;
            int localRunDirection = 1;
            if (this.runDirection != 0) {
                localRunDirection = this.runDirection;
            }
            if (this.canvas != null) {
                graphics = this.canvas;
                pdf = this.canvas.getPdfDocument();
                text = this.canvas.getDuplicate();
            } else if (!simulate) {
                throw new NullPointerException("ColumnText.go with simulate==false and text==null.");
            }
            if (!simulate) {
                if (ratio == 0.0f) {
                    ratio = text.getPdfWriter().getSpaceCharRatio();
                } else if (ratio < 0.001f) {
                    ratio = 0.001f;
                }
            }
            float firstIndent = 0.0f;
            status = 0;
            if (this.rectangularWidth > 0.0f) {
                while (true) {
                    float f = firstIndent = this.lastWasNewline ? this.indent : this.followingIndent;
                    if (this.rectangularWidth <= firstIndent + this.rightIndent) {
                        status = 2;
                        if (this.bidiLine.isEmpty()) {
                            status |= 1;
                        }
                        break block25;
                    }
                    if (this.bidiLine.isEmpty()) {
                        status = 1;
                        break block25;
                    }
                    float yTemp = this.yLine;
                    PdfLine line = this.bidiLine.processLine(this.rectangularWidth - firstIndent - this.rightIndent, this.alignment, localRunDirection, this.arabicOptions);
                    if (line == null) {
                        status = 1;
                        break block25;
                    }
                    float maxSize = line.getMaxSizeSimple();
                    this.currentLeading = this.fixedLeading + maxSize * this.multipliedLeading;
                    float[] xx = this.findLimitsTwoLines();
                    if (xx == null) {
                        status = 2;
                        this.yLine = yTemp;
                        this.bidiLine.restore();
                        break block25;
                    }
                    float x1 = Math.max(xx[0], xx[2]);
                    if (!simulate && !dirty) {
                        text.beginText();
                        dirty = true;
                    }
                    if (!simulate) {
                        currentValues[0] = currentFont;
                        text.setTextMatrix(x1 + (line.isRTL() ? this.rightIndent : firstIndent) + line.indentLeft(), this.yLine);
                        pdf.writeLineToContent(line, text, graphics, currentValues, ratio);
                        currentFont = (PdfFont)currentValues[0];
                    }
                    this.lastWasNewline = line.isNewlineSplit();
                    this.yLine -= line.isNewlineSplit() ? this.extraParagraphSpace : 0.0f;
                    ++this.linesWritten;
                    this.descender = line.getDescender();
                }
            }
            this.currentLeading = this.fixedLeading;
            while (true) {
                PdfLine line;
                firstIndent = this.lastWasNewline ? this.indent : this.followingIndent;
                float yTemp = this.yLine;
                float[] xx = this.findLimitsTwoLines();
                if (xx == null) {
                    status = 2;
                    if (this.bidiLine.isEmpty()) {
                        status |= 1;
                    }
                    this.yLine = yTemp;
                    break;
                }
                if (this.bidiLine.isEmpty()) {
                    status = 1;
                    this.yLine = yTemp;
                    break;
                }
                float x1 = Math.max(xx[0], xx[2]);
                float x2 = Math.min(xx[1], xx[3]);
                if (x2 - x1 <= firstIndent + this.rightIndent) continue;
                if (!simulate && !dirty) {
                    text.beginText();
                    dirty = true;
                }
                if ((line = this.bidiLine.processLine(x2 - x1 - firstIndent - this.rightIndent, this.alignment, localRunDirection, this.arabicOptions)) == null) {
                    status = 1;
                    this.yLine = yTemp;
                    break;
                }
                if (!simulate) {
                    currentValues[0] = currentFont;
                    text.setTextMatrix(x1 + (line.isRTL() ? this.rightIndent : firstIndent) + line.indentLeft(), this.yLine);
                    pdf.writeLineToContent(line, text, graphics, currentValues, ratio);
                    currentFont = (PdfFont)currentValues[0];
                }
                this.lastWasNewline = line.isNewlineSplit();
                this.yLine -= line.isNewlineSplit() ? this.extraParagraphSpace : 0.0f;
                ++this.linesWritten;
                this.descender = line.getDescender();
            }
        }
        if (dirty) {
            text.endText();
            this.canvas.add(text);
        }
        return status;
    }

    public float getExtraParagraphSpace() {
        return this.extraParagraphSpace;
    }

    public void setExtraParagraphSpace(float extraParagraphSpace) {
        this.extraParagraphSpace = extraParagraphSpace;
    }

    public void clearChunks() {
        this.bidiLine.clearChunks();
    }

    public float getSpaceCharRatio() {
        return this.spaceCharRatio;
    }

    public void setSpaceCharRatio(float spaceCharRatio) {
        this.spaceCharRatio = spaceCharRatio;
    }

    public void setRunDirection(int runDirection) {
        if (runDirection < 0 || runDirection > 3) {
            throw new RuntimeException("Invalid run direction: " + runDirection);
        }
        this.runDirection = runDirection;
    }

    public int getRunDirection() {
        return this.runDirection;
    }

    public int getLinesWritten() {
        return this.linesWritten;
    }

    public int getArabicOptions() {
        return this.arabicOptions;
    }

    public void setArabicOptions(int arabicOptions) {
        this.arabicOptions = arabicOptions;
    }

    public float getDescender() {
        return this.descender;
    }

    public static float getWidth(Phrase phrase, int runDirection, int arabicOptions) {
        ColumnText ct = new ColumnText(null);
        ct.addText(phrase);
        PdfLine line = ct.bidiLine.processLine(20000.0f, 0, runDirection, arabicOptions);
        if (line == null) {
            return 0.0f;
        }
        return 20000.0f - line.widthLeft();
    }

    public static float getWidth(Phrase phrase) {
        return ColumnText.getWidth(phrase, 1, 0);
    }

    public static void showTextAligned(PdfContentByte canvas, int alignment, Phrase phrase, float x, float y, float rotation, int runDirection, int arabicOptions) {
        if (alignment != 0 && alignment != 1 && alignment != 2) {
            alignment = 0;
        }
        canvas.saveState();
        if (rotation == 0.0f) {
            canvas.concatCTM(1.0f, 0.0f, 0.0f, 1.0f, x, y);
        } else {
            double alpha = (double)rotation * Math.PI / 180.0;
            float cos = (float)Math.cos(alpha);
            float sin = (float)Math.sin(alpha);
            canvas.concatCTM(cos, sin, -sin, cos, x, y);
        }
        ColumnText ct = new ColumnText(canvas);
        if (alignment == 0) {
            ct.setSimpleColumn(phrase, 0.0f, -1.0f, 20000.0f, 2.0f, 2.0f, alignment);
        } else if (alignment == 2) {
            ct.setSimpleColumn(phrase, -20000.0f, -1.0f, 0.0f, 2.0f, 2.0f, alignment);
        } else {
            ct.setSimpleColumn(phrase, -20000.0f, -1.0f, 20000.0f, 2.0f, 2.0f, alignment);
        }
        if (runDirection == 3) {
            if (alignment == 0) {
                alignment = 2;
            } else if (alignment == 2) {
                alignment = 0;
            }
        }
        ct.setAlignment(alignment);
        ct.setArabicOptions(arabicOptions);
        ct.setRunDirection(runDirection);
        try {
            ct.go();
        }
        catch (DocumentException e) {
            throw new ExceptionConverter(e);
        }
        canvas.restoreState();
    }

    public static void showTextAligned(PdfContentByte canvas, int alignment, Phrase phrase, float x, float y, float rotation) {
        ColumnText.showTextAligned(canvas, alignment, phrase, x, y, rotation, 1, 0);
    }
}

