/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.Status;
import org.apache.fop.fo.flow.ListItemBody;
import org.apache.fop.fo.flow.ListItemLabel;
import org.apache.fop.layout.AccessibilityProps;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.AuralProps;
import org.apache.fop.layout.BackgroundProps;
import org.apache.fop.layout.BlockArea;
import org.apache.fop.layout.BorderAndPadding;
import org.apache.fop.layout.MarginProps;
import org.apache.fop.layout.RelativePositionProps;

public class ListItem
extends FObj {
    int align;
    int alignLast;
    int breakBefore;
    int breakAfter;
    int lineHeight;
    int startIndent;
    int endIndent;
    int spaceBefore;
    int spaceAfter;
    String id;
    BlockArea blockArea;

    public static FObj.Maker maker() {
        return new Maker();
    }

    public ListItem(FObj parent, PropertyList propertyList, String systemId, int line, int column) {
        super(parent, propertyList, systemId, line, column);
    }

    public String getName() {
        return "fo:list-item";
    }

    public int layout(Area area) throws FOPException {
        int status;
        if (this.marker == -1000) {
            AccessibilityProps mAccProps = this.propMgr.getAccessibilityProps();
            AuralProps mAurProps = this.propMgr.getAuralProps();
            BorderAndPadding bap = this.propMgr.getBorderAndPadding();
            BackgroundProps bProps = this.propMgr.getBackgroundProps();
            MarginProps mProps = this.propMgr.getMarginProps();
            RelativePositionProps mRelProps = this.propMgr.getRelativePositionProps();
            this.align = this.properties.get("text-align").getEnum();
            this.alignLast = this.properties.get("text-align-last").getEnum();
            this.lineHeight = this.properties.get("line-height").getLength().mvalue();
            this.spaceBefore = this.properties.get("space-before.optimum").getLength().mvalue();
            this.spaceAfter = this.properties.get("space-after.optimum").getLength().mvalue();
            this.id = this.properties.get("id").getString();
            try {
                area.getIDReferences().createID(this.id);
            }
            catch (FOPException e) {
                if (!e.isLocationSet()) {
                    e.setLocation(this.systemId, this.line, this.column);
                }
                throw e;
            }
            this.marker = 0;
        }
        if (area instanceof BlockArea) {
            area.end();
        }
        if (this.spaceBefore != 0) {
            area.addDisplaySpace(this.spaceBefore);
        }
        this.blockArea = new BlockArea(this.propMgr.getFontState(area.getFontInfo()), area.getAllocationWidth(), area.spaceLeft(), 0, 0, 0, this.align, this.alignLast, this.lineHeight);
        this.blockArea.setTableCellXOffset(area.getTableCellXOffset());
        this.blockArea.setGeneratedBy(this);
        ++this.areasGenerated;
        if (this.areasGenerated == 1) {
            this.blockArea.isFirst(true);
        }
        this.blockArea.setParent(area);
        this.blockArea.setPage(area.getPage());
        this.blockArea.start();
        this.blockArea.setAbsoluteHeight(area.getAbsoluteHeight());
        this.blockArea.setIDReferences(area.getIDReferences());
        int numChildren = this.children.size();
        if (numChildren != 2) {
            throw new FOPException("list-item must have exactly two children", this.systemId, this.line, this.column);
        }
        ListItemLabel label = (ListItemLabel)this.children.get(0);
        ListItemBody body = (ListItemBody)this.children.get(1);
        if (this.marker == 0) {
            area.getIDReferences().configureID(this.id, area);
            int status2 = label.layout(this.blockArea);
            if (Status.isIncomplete(status2)) {
                return status2;
            }
        }
        if (Status.isIncomplete(status = body.layout(this.blockArea))) {
            this.blockArea.end();
            area.addChild(this.blockArea);
            area.increaseHeight(this.blockArea.getHeight());
            this.marker = 1;
            return status;
        }
        this.blockArea.end();
        area.addChild(this.blockArea);
        area.increaseHeight(this.blockArea.getHeight());
        if (this.spaceAfter != 0) {
            area.addDisplaySpace(this.spaceAfter);
        }
        if (area instanceof BlockArea) {
            area.start();
        }
        this.blockArea.isLast(true);
        return 1;
    }

    public int getContentWidth() {
        if (this.blockArea != null) {
            return this.blockArea.getContentWidth();
        }
        return 0;
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj parent, PropertyList propertyList, String systemId, int line, int column) throws FOPException {
            return new ListItem(parent, propertyList, systemId, line, column);
        }
    }
}

