/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.mif;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.fop.messaging.MessageHandler;

public class MIFDocument {
    protected static final String mifVersion = "5.5";
    protected BookComponent bookComponent;
    private Flow curFlow;
    private ID curIDCounter = new ID();

    public static final String MIFEncode(String val) {
        int len = val.length();
        StringBuffer buf = new StringBuffer(len * 2);
        int i = 0;
        while (i < len) {
            char c = val.charAt(i);
            switch (c) {
                case '\u00e0': {
                    buf.append("\\x88 ");
                    break;
                }
                case '\u00e8': {
                    buf.append("\\x8f ");
                    break;
                }
                case '\u00ec': {
                    buf.append("\\x93 ");
                    break;
                }
                case '\u00f2': {
                    buf.append("\\x98 ");
                    break;
                }
                case '\u00f9': {
                    buf.append("\\x9d ");
                    break;
                }
                case '\u00c0': {
                    buf.append("\\xcb ");
                    break;
                }
                case '\u00c8': {
                    buf.append("\\xe9 ");
                    break;
                }
                case '\u00cc': {
                    buf.append("\\xed ");
                    break;
                }
                case '\u00d2': {
                    buf.append("\\xf1 ");
                    break;
                }
                case '\u00d9': {
                    buf.append("\\xf4 ");
                    break;
                }
                case '\u00e1': {
                    buf.append("\\x87 ");
                    break;
                }
                case '\u00e9': {
                    buf.append("\\x8e ");
                    break;
                }
                case '\u00ed': {
                    buf.append("\\x92 ");
                    break;
                }
                case '\u00f3': {
                    buf.append("\\x97 ");
                    break;
                }
                case '\u00fa': {
                    buf.append("\\x9c ");
                    break;
                }
                case '\u00c1': {
                    buf.append("\\xe7 ");
                    break;
                }
                case '\u00c9': {
                    buf.append("\\x83 ");
                    break;
                }
                case '\u00cd': {
                    buf.append("\\xea ");
                    break;
                }
                case '\u00d3': {
                    buf.append("\\xee ");
                    break;
                }
                case '\u00da': {
                    buf.append("\\xf2 ");
                    break;
                }
                case '\u00f1': {
                    buf.append("\\x96 ");
                    break;
                }
                case '\u00d1': {
                    buf.append("\\x84 ");
                    break;
                }
                case '\u00e7': {
                    buf.append("\\x8d ");
                    break;
                }
                case '\u00c7': {
                    buf.append("\\x82 ");
                    break;
                }
                case '`': {
                    buf.append("\\xd4 ");
                    break;
                }
                case '\'': {
                    buf.append("\\xd5 ");
                    break;
                }
                case '\u00b4': {
                    buf.append("\\xab ");
                    break;
                }
                case '\u00aa': {
                    buf.append("\\xbb ");
                    break;
                }
                case '\u00ba': {
                    buf.append("\\xbc ");
                    break;
                }
                case '>': {
                    buf.append("\\>");
                    break;
                }
                default: {
                    buf.append(c);
                }
            }
            ++i;
        }
        return buf.toString();
    }

    public MIFDocument() {
        this.bookComponent = new BookComponent();
    }

    public void createPage() {
        this.bookComponent.pages.add(new Page());
    }

    public void addToStream(String s) {
        Para para = this.curFlow.curPara();
        ParaLine paraLine = para.curParaLine();
        paraLine.addContent(s);
    }

    public void output(OutputStream stream) throws IOException {
        this.bookComponent.output(stream);
    }

    public void setDocumentHeightWidth(int height, int width) {
        if (this.bookComponent.document == null) {
            this.bookComponent.document = new Document();
            this.bookComponent.document.height = height;
            this.bookComponent.document.width = width;
        } else if (this.bookComponent.document.height != height || this.bookComponent.document.width != width) {
            MessageHandler.logln("Warning : FrameMaker doesnt support different page-sizes   in a document");
        }
    }

    public void createTextRect(int numCols) {
        this.bookComponent.curPage().addTextRect(numCols);
        this.curFlow = new TextFlow();
        this.bookComponent.textFlows.add(this.curFlow);
    }

    public void setTextRectProp(int left, int top, int width, int height) {
        this.bookComponent.curPage().curTextRect().setTextRectProp(left, top, width, height);
    }

    public void startLine() {
        if (this.curFlow.curPara().curParaLine() != null) {
            this.addToStream("\n");
            this.curFlow.curPara().startParaLine();
        } else {
            this.curFlow.curPara().startParaLine();
        }
    }

    public void setBlockProp(int startIndent, int endIndent) {
        this.curFlow.startPara();
        this.curFlow.curPara().setBlockProp(startIndent, endIndent);
    }

    public void createFrame(int x, int y, int w, int h) {
        this.bookComponent.createFrame(x, y, w, h);
    }

    public void addImage(String url, int x, int y, int w, int h) {
        Frame frame = this.bookComponent.createFrame(x, y, w, h);
        ImportObject imageObject = new ImportObject(url, 0, 0, w, h);
        frame.addContent(imageObject);
        if (this.curFlow.curPara().curParaLine() == null) {
            this.curFlow.curPara().startParaLine();
        }
        this.curFlow.curPara().curParaLine().addContent(frame);
    }

    public void createTable() {
        Tbl table = this.bookComponent.createTable();
        if (this.curFlow.curPara().curParaLine() == null) {
            this.curFlow.curPara().startParaLine();
        }
        this.curFlow.curPara().curParaLine().addContent(table);
        this.curFlow = table;
    }

    public void setColumnProp(int colWidth) {
        Tbl table = this.bookComponent.curTable();
        table.addColumn(colWidth);
    }

    public void setCurrent(String current) {
        Tbl table = this.bookComponent.curTable();
        table.setCurrent(current);
    }

    public void startRow() {
        Tbl table = this.bookComponent.curTable();
        table.startRow();
    }

    public void startCell(int rowSpan, int colSpan) {
        Tbl table = this.bookComponent.curTable();
        table.startCell(rowSpan, colSpan);
    }

    public void endTable() {
        this.curFlow = this.bookComponent.curTextFlow();
    }

    class ID {
        private int idCounter = 1;

        ID() {
        }

        public int getnewID() {
            return this.idCounter++;
        }
    }

    class FontFormat {
    }

    class ParagraphFormat
    extends FontFormat {
        int startIndent;
        int endIndent;
    }

    class Document {
        protected int height;
        protected int width;

        public void output(OutputStream stream) throws IOException {
            String mif = "\n<Document \n<DPageSize " + (float)this.width / 1000.0f + " " + (float)this.height / 1000.0f + " >\n>";
            byte[] buf = mif.getBytes();
            stream.write(buf);
        }
    }

    class PolyLine {
    }

    class ImportObject {
        private String url;
        private int x;
        private int y;
        private int w;
        private int h;

        public ImportObject(String url, int x, int y, int w, int h) {
            this.url = url;
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
        }

        public void output(OutputStream stream) throws IOException {
            int i;
            String path = this.url;
            path = path.substring(5);
            String result = "";
            do {
                if ((i = path.indexOf("/")) == -1) continue;
                result = path.substring(0, i);
                result = String.valueOf(result) + "<c\\>";
                path = result = String.valueOf(result) + path.substring(i + 1);
            } while (i != -1);
            String mif = "\n<ImportObject\n<ImportObFixedSize Yes>";
            mif = String.valueOf(mif) + "\n\t<ImportObFileDI `<c\\>" + path + "'" + " >";
            mif = String.valueOf(mif) + "\n\t<ShapeRect " + (float)this.x / 1000.0f + " " + (float)this.y / 1000.0f + " " + (float)this.w / 1000.0f + " " + (float)this.h / 1000.0f + " >";
            mif = String.valueOf(mif) + "\n> #End ImportObj";
            stream.write(mif.getBytes());
        }
    }

    class Frame {
        private int ID;
        private int x;
        private int y;
        private int w;
        private int h;
        ArrayList content = new ArrayList();

        public Frame(int x, int y, int w, int h) {
            this.ID = MIFDocument.this.curIDCounter.getnewID();
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
        }

        public void addContent(ImportObject obj) {
            this.content.add(obj);
        }

        public void output(OutputStream stream) throws IOException {
            String mif = "\n<Frame\n\t<ID " + this.ID + " >";
            mif = String.valueOf(mif) + "\n\t<Pen 15>\n\t<Fill 7>\n\t<PenWidth  1.0 >\n\t<Separation 0>\n\t<ObColor `Black'>\n\t<DashedPattern \n\t <DashedStyle Solid> \n >";
            mif = String.valueOf(mif) + "\n\t<RunaroundGap  6.0 pt>\n\t<RunaroundType None>\n\t<Angle  360.0>\n\t<Float No>\n\t<NSOffset  0.0>\n\t<BLOffset  0>\n\t<Cropped No>\n\t<FrameType Below>\n\t<AnchorAlign Center>";
            mif = String.valueOf(mif) + "\n\t<ShapeRect " + (float)this.x / 1000.0f + " " + (float)this.y / 1000.0f + " " + (float)this.w / 1000.0f + " " + (float)this.h / 1000.0f + " >";
            stream.write(mif.getBytes());
            int i = 0;
            while (i < this.content.size()) {
                ((ImportObject)this.content.get(i)).output(stream);
                ++i;
            }
            mif = "\n> #End Frame";
            stream.write(mif.getBytes());
        }

        public int getID() {
            return this.ID;
        }
    }

    class TextRect {
        private int rx;
        private int ry;
        private int w;
        private int h;
        private int numCols;
        private int curCol = 0;
        private int colGap = 0;
        private int textRectID;

        public TextRect(int numCols) {
            this.numCols = numCols;
            this.curCol = 0;
            this.textRectID = MIFDocument.this.curIDCounter.getnewID();
        }

        public int getTextRectID() {
            return this.textRectID;
        }

        public void setTextRectProp(int left, int top, int width, int height) {
            if (this.curCol == 0) {
                this.rx = left;
                this.ry = top;
                this.w = width;
                this.h = height;
                ++this.curCol;
            } else if (this.curCol == 1) {
                this.colGap = left - this.rx - width;
                this.w = this.numCols * width + (this.numCols - 1) * this.colGap;
                ++this.curCol;
            }
        }

        public void output(OutputStream stream) throws IOException {
            String mif = "\n<TextRect\n\t<ID " + this.textRectID + ">" + "\n\t<ShapeRect " + (float)this.rx / 1000.0f + " " + (float)this.ry / 1000.0f + " " + (float)this.w / 1000.0f + " " + (float)this.h / 1000.0f + ">";
            if (this.numCols > 1) {
                mif = String.valueOf(mif) + "\n<TRNumColumns " + this.numCols + ">";
                mif = String.valueOf(mif) + "\n<TRColumnGap " + (float)this.colGap / 1000.0f + ">";
            }
            mif = String.valueOf(mif) + "\n> #End TextRect";
            byte[] buf = mif.getBytes();
            stream.write(buf);
        }
    }

    class Page {
        private String pageType;
        private String pageTag;
        private String pageBackground;
        private ArrayList textRects;

        public Page(String pageType, String pageTag, String pageBackground) {
            this.pageType = pageType;
            this.pageTag = pageTag;
            this.pageBackground = pageBackground;
            this.textRects = new ArrayList();
        }

        public Page() {
            this.pageType = "BodyPage";
            this.pageBackground = "Default";
            this.textRects = new ArrayList();
        }

        public void addTextRect(int numCols) {
            TextRect textRect = new TextRect(numCols);
            this.textRects.add(textRect);
        }

        public TextRect curTextRect() {
            if (this.textRects.isEmpty()) {
                TextRect textRect = new TextRect(1);
                this.textRects.add(textRect);
            }
            return (TextRect)this.textRects.get(this.textRects.size() - 1);
        }

        public void output(OutputStream stream) throws IOException {
            String mif = "\n<Page\n\t<PageType " + this.pageType + ">" + "\n\t<PageBackground " + "`" + this.pageBackground + "'" + ">";
            byte[] buf = mif.getBytes();
            stream.write(buf);
            int i = 0;
            while (i < this.textRects.size()) {
                ((TextRect)this.textRects.get(i)).output(stream);
                ++i;
            }
            mif = "\n>  #End Page\n";
            stream.write(mif.getBytes());
        }
    }

    abstract class Flow {
        public abstract Para curPara();

        public abstract void startPara();
    }

    class TextFlow
    extends Flow {
        ArrayList paras;
        private int ID;

        public TextFlow() {
            this.ID = MIFDocument.this.bookComponent.curPage().curTextRect().getTextRectID();
            this.paras = new ArrayList();
        }

        public int getTextRectID() {
            return this.ID;
        }

        public Para curPara() {
            return (Para)this.paras.get(this.paras.size() - 1);
        }

        public void startPara() {
            this.paras.add(new Para(this.ID));
        }

        public void output(OutputStream stream) throws IOException {
            String mif = "\n<TextFlow";
            stream.write(mif.getBytes());
            int i = 0;
            while (i < this.paras.size()) {
                ((Para)this.paras.get(i)).output(stream);
                ++i;
            }
            mif = "\n> #End TextFlow";
            stream.write(mif.getBytes());
        }
    }

    class Para {
        ArrayList paraLines;
        int ID;
        ParagraphFormat pgf = null;

        public Para() {
            this.ID = 0;
            this.paraLines = new ArrayList();
        }

        public Para(int ID2) {
            this.ID = ID2;
            this.paraLines = new ArrayList();
        }

        public ParaLine curParaLine() {
            if (this.paraLines.isEmpty()) {
                return null;
            }
            return (ParaLine)this.paraLines.get(this.paraLines.size() - 1);
        }

        void startParaLine() {
            this.paraLines.add(new ParaLine(this.ID));
        }

        public void setBlockProp(int startIndent, int endIndent) {
            this.pgf = new ParagraphFormat();
            this.pgf.startIndent = startIndent;
            this.pgf.endIndent = endIndent;
        }

        public void output(OutputStream stream) throws IOException {
            String mif = "\n<Para";
            if (this.pgf != null) {
                mif = String.valueOf(mif) + "\n<Pgf";
                mif = String.valueOf(mif) + "\n<PgfTag `Body'>";
                mif = String.valueOf(mif) + "\n<PgfLIndent " + (float)this.pgf.startIndent / 1000.0f + ">";
                mif = String.valueOf(mif) + "\n<PgfRIndent " + (float)this.pgf.endIndent / 1000.0f + ">";
                mif = String.valueOf(mif) + "\n>";
            }
            stream.write(mif.getBytes());
            int i = 0;
            while (i < this.paraLines.size()) {
                ((ParaLine)this.paraLines.get(i)).output(stream);
                ++i;
            }
            mif = "\n> #End ParaLine";
            stream.write(mif.getBytes());
        }
    }

    class ParaLine {
        ArrayList content;
        int textRectID;
        String tableID;
        String aFrameID;

        public ParaLine(int textRectID) {
            this.textRectID = textRectID;
            this.content = new ArrayList();
        }

        public ParaLine() {
            this.textRectID = 0;
            this.content = new ArrayList();
        }

        public void addContent(Object obj) {
            this.content.add(obj);
        }

        public void output(OutputStream stream) throws IOException {
            String mif = "\n<ParaLine";
            if (this.textRectID != 0) {
                mif = String.valueOf(mif) + "\n\t<TextRectID " + this.textRectID + ">";
            }
            stream.write(mif.getBytes());
            int i = 0;
            while (i < this.content.size()) {
                Object elem = this.content.get(i);
                if (elem instanceof String) {
                    mif = elem == "\n" ? "\n<Char HardReturn>" : "\n\t<String `" + MIFDocument.MIFEncode((String)elem) + "'>";
                    stream.write(mif.getBytes());
                } else if (elem instanceof Frame) {
                    mif = "\n\t<AFrame " + ((Frame)elem).getID() + " >";
                    stream.write(mif.getBytes());
                } else if (elem instanceof Tbl) {
                    mif = "\n\t<ATbl " + ((Tbl)elem).getID() + " >";
                    stream.write(mif.getBytes());
                }
                ++i;
            }
            mif = "\n> #End ParaLine";
            stream.write(mif.getBytes());
        }
    }

    class PgfCatalog {
        ArrayList pgfs;

        public void output(OutputStream stream) throws IOException {
            String mif = "\n<PgfCatalog\n<Pgf\n<PgfTag `Body'>\n>\n>";
            stream.write(mif.getBytes());
        }
    }

    class Color {
    }

    class ColorCatalog {
    }

    class Ruling {
        int penWidth = 1;
        int pen = 0;
        int lines = 1;

        public void output(OutputStream stream) throws IOException {
            String mif = "\n<Ruling \n<RulingTag `Default'>";
            mif = String.valueOf(mif) + "\n<RulingPenWidth " + this.penWidth + ">";
            mif = String.valueOf(mif) + "\n<RulingPen " + this.pen + ">";
            mif = String.valueOf(mif) + "\n<RulingLines " + this.lines + ">";
            mif = String.valueOf(mif) + "\n>";
            stream.write(mif.getBytes());
        }
    }

    class RulingCatalog {
        ArrayList ruling = new ArrayList();

        public RulingCatalog() {
            this.ruling.add(new Ruling());
        }

        public void output(OutputStream stream) throws IOException {
            String mif = "\n<RulingCatalog";
            stream.write(mif.getBytes());
            int i = 0;
            while (i < this.ruling.size()) {
                ((Ruling)this.ruling.get(i)).output(stream);
                ++i;
            }
            mif = "\n> #End RulingCatalog";
            stream.write(mif.getBytes());
        }
    }

    class TblFormat {
    }

    class TblCatalog {
    }

    class Tbl
    extends Flow {
        private int ID;
        private ArrayList tblColumns = new ArrayList();
        private ArrayList tblBody;
        private ArrayList tblHead;
        private ArrayList tblFoot;
        private ArrayList current;

        public void addColumn(int colWidth) {
            this.tblColumns.add(new TblColumn(colWidth));
        }

        public void setCurrent(String current) {
            if (current == "fo:table-body") {
                this.current = this.tblBody;
            } else if (current == "tablehead") {
                this.current = this.tblHead;
            } else if (current == "tablefoot") {
                this.current = this.tblFoot;
            }
        }

        public void startRow() {
            this.current.add(new Row());
        }

        public void startCell(int rowSpan, int colSpan) {
            ((Row)this.current.get(this.current.size() - 1)).addCell(rowSpan, colSpan);
        }

        public Tbl() {
            this.ID = MIFDocument.this.curIDCounter.getnewID();
            this.tblBody = new ArrayList();
            this.tblHead = new ArrayList();
            this.tblFoot = new ArrayList();
        }

        public int getID() {
            return this.ID;
        }

        public Para curPara() {
            Row curRow = (Row)this.current.get(this.current.size() - 1);
            ArrayList paras = curRow.curCell().paras;
            return (Para)paras.get(paras.size() - 1);
        }

        public void startPara() {
            Row curRow = (Row)this.current.get(this.current.size() - 1);
            curRow.curCell().startPara();
        }

        public void output(OutputStream stream) throws IOException {
            int i;
            String mif = "\n<Tbl\n\t<TblID " + this.ID + " >";
            mif = String.valueOf(mif) + "\n<TblTag Body>\n<TblFormat";
            mif = String.valueOf(mif) + "\n<TblColumnRuling `Default'>";
            mif = String.valueOf(mif) + "\n<TblBodyRowRuling `Default'>";
            mif = String.valueOf(mif) + "\n<TblLRuling `Default'>";
            mif = String.valueOf(mif) + "\n<TblBRuling `Default'>";
            mif = String.valueOf(mif) + "\n<TblRRuling `Default'>";
            mif = String.valueOf(mif) + "\n<TblTRuling `Default'>";
            mif = String.valueOf(mif) + "\n> #End TblFormat";
            mif = String.valueOf(mif) + "\n\t<TblNumColumns " + this.tblColumns.size() + " >";
            stream.write(mif.getBytes());
            if (!this.tblHead.isEmpty()) {
                i = 0;
                while (i < this.tblHead.size()) {
                    ((Row)this.tblHead.get(i)).output(stream);
                    ++i;
                }
            }
            if (!this.tblFoot.isEmpty()) {
                i = 0;
                while (i < this.tblFoot.size()) {
                    ((Row)this.tblFoot.get(i)).output(stream);
                    ++i;
                }
            }
            if (!this.tblBody.isEmpty()) {
                mif = "\n\t<TblBody";
                stream.write(mif.getBytes());
                i = 0;
                while (i < this.tblBody.size()) {
                    ((Row)this.tblBody.get(i)).output(stream);
                    ++i;
                }
                mif = "\n\t> #End tblBody";
            }
            mif = String.valueOf(mif) + "\n> #End Table";
            stream.write(mif.getBytes());
        }

        class TblColumn {
            private int width;

            public TblColumn(int width) {
                this.width = width;
            }

            public void output(OutputStream stream) throws IOException {
                String mif = "\n\t<TblColumnWidth " + this.width + " >";
                stream.write(mif.getBytes());
            }
        }

        class Row {
            private ArrayList cells = new ArrayList();

            public void addCell(int rowSpan, int colSpan) {
                this.cells.add(new Cell(rowSpan, colSpan));
            }

            public Cell curCell() {
                return (Cell)this.cells.get(this.cells.size() - 1);
            }

            public void output(OutputStream stream) throws IOException {
                String mif = "\n\t<Row";
                stream.write(mif.getBytes());
                int i = 0;
                while (i < this.cells.size()) {
                    ((Cell)this.cells.get(i)).output(stream);
                    ++i;
                }
                mif = "\n\t> #End Row";
                stream.write(mif.getBytes());
            }

            class Cell {
                private int rowSpan;
                private int colSpan;
                private ArrayList paras;

                public Cell(int rowSpan, int colSpan) {
                    this.rowSpan = rowSpan;
                    this.colSpan = colSpan;
                    this.paras = new ArrayList();
                }

                public void startPara() {
                    this.paras.add(new Para());
                }

                public void output(OutputStream stream) throws IOException {
                    String mif = "\n\t\t<Cell\n\t\t<CellContent";
                    stream.write(mif.getBytes());
                    int i = 0;
                    while (i < this.paras.size()) {
                        ((Para)this.paras.get(i)).output(stream);
                        ++i;
                    }
                    mif = "\n\t\t> #End CellContent";
                    mif = String.valueOf(mif) + "\n\t> #End Cell";
                    stream.write(mif.getBytes());
                }
            }
        }
    }

    class XRefFormat {
    }

    class CrossRefInfo {
    }

    class XRef {
    }

    class Marker {
    }

    class BookComponent {
        Document document = null;
        ColorCatalog colorCatalog;
        RulingCatalog rulingCatalog;
        PgfCatalog pgfCatalog;
        TblCatalog tblCatalog;
        ArrayList aFrames = new ArrayList();
        ArrayList tables = new ArrayList();
        ArrayList pages = new ArrayList();
        ArrayList textFlows = new ArrayList();

        public BookComponent() {
            this.pgfCatalog = new PgfCatalog();
            this.rulingCatalog = new RulingCatalog();
        }

        public Frame createFrame(int x, int y, int w, int h) {
            Frame frame = new Frame(x, y, w, h);
            this.aFrames.add(frame);
            return frame;
        }

        public Frame curFrame() {
            return (Frame)this.aFrames.get(this.aFrames.size() - 1);
        }

        public TextFlow curTextFlow() {
            return (TextFlow)this.textFlows.get(this.textFlows.size() - 1);
        }

        public Tbl createTable() {
            Tbl table = new Tbl();
            this.tables.add(table);
            return table;
        }

        public Tbl curTable() {
            return (Tbl)this.tables.get(this.tables.size() - 1);
        }

        public void output(OutputStream stream) throws IOException {
            int i;
            String mif = "<MIFFile 5.00>\n<Units Upt>";
            stream.write(mif.getBytes());
            this.pgfCatalog.output(stream);
            this.rulingCatalog.output(stream);
            this.document.output(stream);
            if (!this.aFrames.isEmpty()) {
                mif = "\n<AFrames";
                stream.write(mif.getBytes());
                i = 0;
                while (i < this.aFrames.size()) {
                    ((Frame)this.aFrames.get(i)).output(stream);
                    ++i;
                }
                mif = "\n>";
                stream.write(mif.getBytes());
            }
            if (!this.tables.isEmpty()) {
                mif = "\n<Tbls";
                stream.write(mif.getBytes());
                i = 0;
                while (i < this.tables.size()) {
                    ((Tbl)this.tables.get(i)).output(stream);
                    ++i;
                }
                mif = "\n>";
                stream.write(mif.getBytes());
            }
            i = 0;
            while (i < this.pages.size()) {
                ((Page)this.pages.get(i)).output(stream);
                ++i;
            }
            i = 0;
            while (i < this.textFlows.size()) {
                ((TextFlow)this.textFlows.get(i)).output(stream);
                ++i;
            }
        }

        private Page curPage() {
            return (Page)this.pages.get(this.pages.size() - 1);
        }
    }

    class ElementSet {
    }
}

