/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.datatype;

import java.text.Collator;
import java.util.Hashtable;
import java.util.Locale;
import org.apache.xerces.validators.datatype.AbstractStringValidator;
import org.apache.xerces.validators.datatype.DatatypeMessageProvider;
import org.apache.xerces.validators.datatype.DatatypeValidator;
import org.apache.xerces.validators.datatype.InvalidDatatypeFacetException;

public class StringDatatypeValidator
extends AbstractStringValidator {
    private short fWhiteSpace;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void assignAdditionalFacets(String string, Hashtable hashtable) throws InvalidDatatypeFacetException {
        this.fWhiteSpace = 0;
        if (!string.equals("whiteSpace")) throw new InvalidDatatypeFacetException(this.getErrorString(DatatypeMessageProvider.ILLEGAL_STRING_FACET, 0, new Object[]{string}));
        this.fFacetsDefined = (short)(this.fFacetsDefined | 0x4000);
        String string2 = (String)hashtable.get(string);
        if (string2.equals("preserve")) {
            this.fWhiteSpace = 0;
            return;
        } else if (string2.equals("replace")) {
            this.fWhiteSpace = 1;
            return;
        } else {
            if (!string2.equals("collapse")) throw new InvalidDatatypeFacetException("whiteSpace value '" + string2 + "' must be one of 'preserve', 'replace', 'collapse'.");
            this.fWhiteSpace = (short)2;
        }
    }

    protected void inheritAdditionalFacets() {
        if ((this.fFacetsDefined & 0x4000) == 0 && (((StringDatatypeValidator)this.fBaseValidator).fFacetsDefined & 0x4000) != 0) {
            this.fFacetsDefined = (short)(this.fFacetsDefined | 0x4000);
            this.fWhiteSpace = ((StringDatatypeValidator)this.fBaseValidator).fWhiteSpace;
        }
    }

    protected void checkBaseFacetConstraints() throws InvalidDatatypeFacetException {
        if ((this.fFacetsDefined & 0x4000) != 0 && (((StringDatatypeValidator)this.fBaseValidator).fFacetsDefined & 0x4000) != 0) {
            if ((((StringDatatypeValidator)this.fBaseValidator).fFlags & 0x4000) != 0 && this.fWhiteSpace != ((StringDatatypeValidator)this.fBaseValidator).fWhiteSpace) {
                throw new InvalidDatatypeFacetException("whiteSpace value = '" + this.whiteSpaceValue(this.fWhiteSpace) + "' must be equal to base.whiteSpace value = '" + this.whiteSpaceValue(((StringDatatypeValidator)this.fBaseValidator).fWhiteSpace) + "' with attribute {fixed} = true");
            }
            if ((this.fWhiteSpace == 0 || this.fWhiteSpace == 1) && ((StringDatatypeValidator)this.fBaseValidator).fWhiteSpace == 2) {
                throw new InvalidDatatypeFacetException("It is an error if whiteSpace = 'preserve' or 'replace' and base.whiteSpace = 'collapse'.");
            }
            if (this.fWhiteSpace == 0 && ((StringDatatypeValidator)this.fBaseValidator).fWhiteSpace == 1) {
                throw new InvalidDatatypeFacetException("It is an error if whiteSpace = 'preserve' and base.whiteSpace = 'replace'.");
            }
        }
    }

    public short getWSFacet() {
        return this.fWhiteSpace;
    }

    public int compare(String string, String string2) {
        Locale locale = Locale.getDefault();
        Collator collator = Collator.getInstance(locale);
        return collator.compare(string, string2);
    }

    private final String whiteSpaceValue(short s) {
        return s != 0 ? (s == 1 ? "replace" : "collapse") : "preserve";
    }

    public Object clone() throws CloneNotSupportedException {
        StringDatatypeValidator stringDatatypeValidator = null;
        try {
            stringDatatypeValidator = new StringDatatypeValidator();
            stringDatatypeValidator.fLocale = this.fLocale;
            stringDatatypeValidator.fBaseValidator = this.fBaseValidator;
            stringDatatypeValidator.fLength = this.fLength;
            stringDatatypeValidator.fMaxLength = this.fMaxLength;
            stringDatatypeValidator.fMinLength = this.fMinLength;
            stringDatatypeValidator.fPattern = this.fPattern;
            stringDatatypeValidator.fWhiteSpace = this.fWhiteSpace;
            stringDatatypeValidator.fEnumeration = this.fEnumeration;
            stringDatatypeValidator.fFacetsDefined = this.fFacetsDefined;
        }
        catch (InvalidDatatypeFacetException invalidDatatypeFacetException) {
            invalidDatatypeFacetException.printStackTrace();
        }
        return stringDatatypeValidator;
    }

    public StringDatatypeValidator() throws InvalidDatatypeFacetException {
        this(null, null, false);
    }

    public StringDatatypeValidator(DatatypeValidator datatypeValidator, Hashtable hashtable, boolean bl) throws InvalidDatatypeFacetException {
        super(datatypeValidator, hashtable, bl);
    }
}

