/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.schema;

import java.util.Vector;
import org.apache.xerces.framework.XMLErrorReporter;
import org.apache.xerces.utils.QName;
import org.apache.xerces.utils.StringPool;
import org.apache.xerces.validators.common.GrammarResolver;
import org.apache.xerces.validators.common.XMLElementDecl;
import org.apache.xerces.validators.datatype.DatatypeValidator;
import org.apache.xerces.validators.schema.SchemaGrammar;
import org.apache.xerces.validators.schema.TraverseSchema;
import org.xml.sax.SAXException;

public class SubstitutionGroupComparator {
    private final int TOP_LEVEL_SCOPE;
    private StringPool fStringPool = null;
    private GrammarResolver fGrammarResolver = null;
    private XMLErrorReporter fErrorReporter = null;

    public StringPool getStringPool() {
        return this.fStringPool;
    }

    public XMLErrorReporter getErrorReporter() {
        return this.fErrorReporter;
    }

    public boolean isEquivalentTo(QName qName, QName qName2) throws Exception {
        int n;
        if (qName.localpart == qName2.localpart && qName.uri == qName2.uri) {
            return true;
        }
        if (this.fGrammarResolver == null || this.fStringPool == null) {
            throw new SAXException("Internal error; tried to check an element against a substitutionGroup, but no GrammarResolver is defined");
        }
        int n2 = qName.uri;
        int n3 = qName.localpart;
        String string = this.fStringPool.toString(qName.uri);
        String string2 = this.fStringPool.toString(qName.localpart);
        if (string == null) {
            return false;
        }
        SchemaGrammar schemaGrammar = null;
        try {
            schemaGrammar = (SchemaGrammar)this.fGrammarResolver.getGrammar(string);
        }
        catch (ClassCastException classCastException) {
            String string3 = "Grammar with URI " + string + " is not a schema grammar!";
            Object[] objectArray = new Object[]{string3};
            this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 169, 146, objectArray, 1);
            return false;
        }
        if (schemaGrammar == null) {
            return false;
        }
        int n4 = n = schemaGrammar.getElementDeclIndex(n2, n3, -1);
        String string4 = schemaGrammar.getElementDeclSubstitutionGroupAffFullName(n);
        boolean bl = false;
        while (string4 != null) {
            int n5 = string4.indexOf(",");
            string = "";
            string2 = string4;
            if (n5 >= 0) {
                if (n5 > 0) {
                    string = string4.substring(0, n5);
                }
                string2 = string4.substring(n5 + 1);
            }
            if (string == null) {
                return false;
            }
            try {
                schemaGrammar = (SchemaGrammar)this.fGrammarResolver.getGrammar(string);
            }
            catch (ClassCastException classCastException) {
                String string5 = "Grammar with URI " + string + " is not a schema grammar!";
                Object[] objectArray = new Object[]{string5};
                this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 169, 146, objectArray, 1);
                return false;
            }
            if (schemaGrammar == null) {
                return false;
            }
            n2 = this.fStringPool.addSymbol(string);
            n = schemaGrammar.getElementDeclIndex(n2, n3 = this.fStringPool.addSymbol(string2), -1);
            if (n == -1) {
                return false;
            }
            if (n2 == qName2.uri && n3 == qName2.localpart) {
                if ((schemaGrammar.getElementDeclBlockSet(n) & 0x20) != 0) {
                    return false;
                }
                bl = true;
                break;
            }
            string4 = schemaGrammar.getElementDeclSubstitutionGroupAffFullName(n);
        }
        if (!bl) {
            return false;
        }
        TraverseSchema.ComplexTypeInfo complexTypeInfo = schemaGrammar.getElementComplexTypeInfo(n4);
        int n6 = schemaGrammar.getElementDeclBlockSet(n);
        if (complexTypeInfo == null) {
            XMLElementDecl xMLElementDecl = new XMLElementDecl();
            schemaGrammar.getElementDecl(n4, xMLElementDecl);
            DatatypeValidator datatypeValidator = xMLElementDecl.datatypeValidator;
            XMLElementDecl xMLElementDecl2 = new XMLElementDecl();
            schemaGrammar.getElementDecl(n, xMLElementDecl2);
            DatatypeValidator datatypeValidator2 = xMLElementDecl2.datatypeValidator;
            return datatypeValidator == null || datatypeValidator == datatypeValidator2 || (n6 & 2) == 0;
        }
        int n7 = complexTypeInfo.derivedBy;
        if ((n7 & n6) != 0) {
            return false;
        }
        TraverseSchema.ComplexTypeInfo complexTypeInfo2 = schemaGrammar.getElementComplexTypeInfo(n);
        TraverseSchema.ComplexTypeInfo complexTypeInfo3 = complexTypeInfo;
        while (complexTypeInfo3 != null && complexTypeInfo3 != complexTypeInfo2) {
            if ((complexTypeInfo3.blockSet & n7) != 0) {
                return false;
            }
            complexTypeInfo3 = complexTypeInfo3.baseComplexTypeInfo;
        }
        return true;
    }

    public boolean isAllowedByWildcard(QName qName, int n, boolean bl) throws Exception {
        if (!bl && qName.uri == n || bl && qName.uri != n) {
            return true;
        }
        if (this.fGrammarResolver == null || this.fStringPool == null) {
            throw new SAXException("Internal error; tried to check an element against a substitutionGroup, but no GrammarResolver is defined");
        }
        String string = this.fStringPool.toString(qName.uri);
        if (string == null) {
            return false;
        }
        SchemaGrammar schemaGrammar = null;
        try {
            schemaGrammar = (SchemaGrammar)this.fGrammarResolver.getGrammar(string);
        }
        catch (ClassCastException classCastException) {
            String string2 = "Grammar with URI " + string + " is not a schema grammar!";
            Object[] objectArray = new Object[]{string2};
            this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/1998/REC-xml-19980210", 169, 146, objectArray, 1);
            return false;
        }
        if (schemaGrammar == null) {
            return false;
        }
        int n2 = schemaGrammar.getElementDeclIndex(qName, -1);
        Vector vector = schemaGrammar.getElementDeclAllSubstitutionGroupQNames(n2, this.fGrammarResolver, this.fStringPool);
        int n3 = vector == null ? 0 : vector.size();
        int n4 = 0;
        while (n4 < n3) {
            QName qName2 = ((SchemaGrammar.OneSubGroup)vector.elementAt((int)n4)).name;
            if (!bl && qName2.uri == n || bl && qName2.uri != n) {
                return true;
            }
            ++n4;
        }
        return false;
    }

    private SubstitutionGroupComparator() {
        this.TOP_LEVEL_SCOPE = -1;
    }

    public SubstitutionGroupComparator(GrammarResolver grammarResolver, StringPool stringPool, XMLErrorReporter xMLErrorReporter) {
        this.TOP_LEVEL_SCOPE = -1;
        this.fGrammarResolver = grammarResolver;
        this.fStringPool = stringPool;
        this.fErrorReporter = xMLErrorReporter;
    }
}

