/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sqs_xml.editor.base.swing;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import net.sf.sqs_xml.editor.base.source.DOMTreeSource;
import net.sf.sqs_xml.editor.base.source.Source;
import net.sf.sqs_xml.editor.base.source.SourceException;
import net.sf.sqs_xml.editor.base.swing.SourceEditorMediator;
import org.xml.sax.SAXParseException;

public abstract class SourceEditorMenuBarMediator {
    FileMenu fileMenu;
    HelpMenu helpMenu;
    JMenuBar menuBar;
    SourceEditorMediator mediator;
    private static final File USER_HOME = new File(System.getProperty("user.dir"));
    private List recentCutNode;

    public SourceEditorMenuBarMediator(SourceEditorMediator mediator) {
        this.mediator = mediator;
        this.menuBar = new JMenuBar();
        this.fileMenu = new FileMenu();
        this.helpMenu = new HelpMenu();
        this.menuBar.add(this.fileMenu);
        this.menuBar.add(this.helpMenu);
    }

    public List getRecentCutNode() {
        return this.recentCutNode;
    }

    public void setRecentCutNode(List list) {
        this.recentCutNode = list;
    }

    public JMenuBar getMenuBar() {
        return this.menuBar;
    }

    public SourceEditorMediator getMediator() {
        return this.mediator;
    }

    public abstract File exportFile(File var1, String var2);

    public abstract JMenu createNewMenuItem();

    public abstract JMenuItem createExportMenuItem();

    public abstract JMenuItem createAboutMenuItem();

    private Source getCurrentSource() {
        int index = this.mediator.getSourceEditorTabbedPane().getSelectedIndex();
        return this.mediator.getSourceManager().get(index);
    }

    private ActionListener createFileCloseActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                SourceEditorMenuBarMediator.this.close();
            }
        };
    }

    protected boolean avoidNodeDelete(int n) {
        return JOptionPane.showConfirmDialog(this.mediator.getFrame(), String.valueOf(n) + "\u500b\u306e\u30ce\u30fc\u30c9\u3092\u524a\u9664\u3057\u3088\u3046\u3068\u3057\u3066\u3044\u307e\u3059\uff0e\u672c\u5f53\u306b\u524a\u9664\u3057\u307e\u3059\u304b?", "Delete Confirmation", 0) != 0;
    }

    private boolean avoidDisposeBuffer(Source source) {
        return source.isDirty() && JOptionPane.showConfirmDialog(this.mediator.getFrame(), "\u3053\u306e\u30d0\u30c3\u30d5\u30a1\u306f\u4fdd\u5b58\u3055\u308c\u3066\u3044\u307e\u305b\u3093\uff0e\u3053\u306e\u30d0\u30c3\u30d5\u30a1\u3092\u7834\u68c4\u3057\u307e\u3059\u304b?", "Dispose Confirmation", 0) != 0;
    }

    private boolean avoidOverwriteBuffer(Source source) {
        return this.avoidOverrideOpenedBuffer(source.getFile());
    }

    protected boolean avoidOverwriteFile(File file) {
        return file.exists() && JOptionPane.showConfirmDialog(this.mediator.getFrame(), file + " \u306f\u3059\u3067\u306b\u5b58\u5728\u3057\u307e\u3059\uff0e\u3053\u306e\u30d5\u30a1\u30a4\u30eb\u3092\u4e0a\u66f8\u304d\u3057\u307e\u3059\u304b?", "Overwrite Confirmation", 0) != 0;
    }

    private boolean avoidOverrideUpdatedFile(Source source) {
        return source.isModified() && JOptionPane.showConfirmDialog(this.mediator.getFrame(), "\u5225\u306e\u30d7\u30ed\u30bb\u30b9\u306b\u3088\u3063\u3066\u30d5\u30a1\u30a4\u30eb\u304c\u66f4\u65b0\u3055\u308c\u3066\u3044\u307e\u3059\uff0e\u3053\u306e\u30d5\u30a1\u30a4\u30eb\u3092\u4e0a\u66f8\u304d\u3057\u307e\u3059\u304b?", "Override Confirmation", 0) != 0;
    }

    private boolean avoidOverrideOpenedBuffer(File file) {
        int index = this.mediator.getSourceManager().getIndexOfFile(file);
        if (index >= 0) {
            if (JOptionPane.showConfirmDialog(this.mediator.getFrame(), "\u3053\u306e\u30d5\u30a1\u30a4\u30eb\u306f\u65e2\u306b\u30d0\u30c3\u30d5\u30a1\u3068\u3057\u3066\u958b\u304b\u308c\u3066\u3044\u307e\u3059\uff0e\u3053\u306e\u30d0\u30c3\u30d5\u30a1\u3092\u4e0a\u66f8\u304d\u3057\u307e\u3059\u304b?", "Override Confirmation", 0) == 0) {
                this.mediator.getSourceManager().close(index);
                this.mediator.tabbedPane.removeTabAt(index);
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean avoidUpdatedFileOpen(Source source) {
        return source.isModified() && JOptionPane.showConfirmDialog(this.mediator.getFrame(), "\u5225\u306e\u30d7\u30ed\u30bb\u30b9\u306b\u3088\u3063\u3066\u30d5\u30a1\u30a4\u30eb\u304c\u66f4\u65b0\u3055\u308c\u3066\u3044\u307e\u3059\uff0e\u7de8\u96c6\u4e2d\u306e\u5185\u5bb9\u3092\u7834\u68c4\u3057\u3066\u30d5\u30a1\u30a4\u30eb\u3092\u8aad\u307f\u76f4\u3057\u307e\u3059\u304b?", "Updated File Open Confirmation", 0) != 0;
    }

    private boolean avoidUnsavedExit(int count) {
        return count > 0 && JOptionPane.showConfirmDialog(this.getMediator().getFrame(), "\u672a\u4fdd\u5b58\u306e\u30d0\u30c3\u30d5\u30a1\u304c " + count + "\u500b\u3042\u308a\u307e\u3059\uff0e\u7d42\u4e86\u3057\u307e\u3059\u304b?", "Exit Confirmation", 0) != 0;
    }

    public void showError(Exception ex, String message) {
        JOptionPane.showMessageDialog(this.mediator.getFrame(), new Object[]{message, ex}, "Error", 0);
    }

    private void showFileOpenErrorMessage(SourceException ex) {
        if (ex.getCause() instanceof SAXParseException) {
            SAXParseException saxParseException = (SAXParseException)ex.getCause();
            JOptionPane.showMessageDialog(this.getMediator().getFrame(), new Object[]{"\u30d5\u30a1\u30a4\u30eb\u5f62\u5f0f\u304c\u6b63\u3057\u304f\u306a\u3044\u305f\u3081\uff0c\u8aad\u307f\u8fbc\u3080\u3053\u3068\u304c\u3067\u304d\u307e\u305b\u3093:", "SystemID: " + saxParseException.getSystemId(), "PublicID: " + saxParseException.getPublicId(), "\u884c: " + saxParseException.getLineNumber() + "  " + "\u5217: " + saxParseException.getColumnNumber(), saxParseException.getLocalizedMessage()}, "File Error", 0);
            ex.printStackTrace();
        } else {
            JOptionPane.showMessageDialog(this.getMediator().getFrame(), new Object[]{"\u30d5\u30a1\u30a4\u30eb\u5f62\u5f0f\u304c\u6b63\u3057\u304f\u306a\u3044\u305f\u3081\uff0c\u8aad\u307f\u8fbc\u3080\u3053\u3068\u304c\u3067\u304d\u307e\u305b\u3093:", ex.getLocalizedMessage()}, "File Error", 0);
            ex.printStackTrace();
        }
    }

    public DOMTreeSource createSource(File file) throws SourceException {
        if (file != null) {
            return (DOMTreeSource)this.mediator.getSourceManager().createSource(file);
        }
        return (DOMTreeSource)this.mediator.getSourceManager().createSource();
    }

    public DOMTreeSource createSource(URL url, boolean readonly, String title) throws SourceException {
        return (DOMTreeSource)this.mediator.getSourceManager().createSource(url, readonly, title);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void open(URL url, boolean readonly, String title) {
        try {
            try {
                this.mediator.getFrame().setCursor(Cursor.getPredefinedCursor(3));
                DOMTreeSource source = this.createSource(url, readonly, title);
                this.mediator.tabbedPane.addComponent(source);
                this.updateMenu();
            }
            catch (SourceException ex) {
                this.showFileOpenErrorMessage(ex);
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.mediator.getFrame().setCursor(Cursor.getPredefinedCursor(0));
            throw throwable;
        }
        {
            Object var5_8 = null;
        }
        this.mediator.getFrame().setCursor(Cursor.getPredefinedCursor(0));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void open(File file) {
        block7: {
            block8: {
                try {
                    try {
                        this.mediator.getFrame().setCursor(Cursor.getPredefinedCursor(3));
                        DOMTreeSource source = null;
                        if (file == null) break block7;
                        int index = -1;
                        index = this.mediator.getSourceManager().getIndexOfFile(file);
                        if (index == -1) {
                            source = this.createSource(file);
                            this.mediator.tabbedPane.addComponent(source);
                            break block7;
                        }
                        source = (DOMTreeSource)this.mediator.getSourceManager().get(index);
                        if (this.avoidUpdatedFileOpen(source)) {
                            Object var4_5 = null;
                            this.updateMenu();
                            break block8;
                        }
                        source.setFile(file);
                        source.initialize(file);
                        this.mediator.tabbedPane.setComponent(index, source);
                    }
                    catch (SourceException ex) {
                        this.showFileOpenErrorMessage(ex);
                    }
                    break block7;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    this.updateMenu();
                    this.mediator.getFrame().setCursor(Cursor.getPredefinedCursor(0));
                    throw throwable;
                }
            }
            this.mediator.getFrame().setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        Object var4_7 = null;
        this.updateMenu();
        this.mediator.getFrame().setCursor(Cursor.getPredefinedCursor(0));
    }

    public void close() {
        Source source = this.getCurrentSource();
        int index = this.mediator.getSourceEditorTabbedPane().getSelectedIndex();
        if (this.avoidDisposeBuffer(source)) {
            return;
        }
        this.mediator.getSourceEditorTabbedPane().removeTabAt(index);
        this.mediator.getSourceManager().close(index);
        this.updateMenu();
        if (this.mediator.getSourceManager().size() == 0) {
            this.fileMenu.closeMenuItem.setEnabled(false);
        }
    }

    public void updateMenu() {
        int selectedIndex = this.getMediator().getSourceEditorTabbedPane().getSelectedIndex();
        if (this.mediator.getSourceEditorTabbedPane().getComponentCount() == 0) {
            this.fileMenu.getSaveMenuItem().setEnabled(false);
            this.fileMenu.getSaveAsMenuItem().setEnabled(false);
            this.fileMenu.getExportMenuItem().setEnabled(false);
            this.fileMenu.getCloseMenuItem().setEnabled(false);
            this.mediator.toolBar.setEnabled(false);
        } else {
            Source source = this.getMediator().getSourceManager().get(selectedIndex);
            if (source.isDirty()) {
                this.fileMenu.getSaveMenuItem().setEnabled(true);
                this.fileMenu.getSaveAsMenuItem().setEnabled(true);
                this.fileMenu.getExportMenuItem().setEnabled(true);
            } else {
                this.fileMenu.getSaveMenuItem().setEnabled(false);
                this.fileMenu.getSaveAsMenuItem().setEnabled(true);
                this.fileMenu.getExportMenuItem().setEnabled(true);
            }
            this.fileMenu.getCloseMenuItem().setEnabled(true);
            this.mediator.toolBar.setEnabled(true);
        }
    }

    public abstract JFileChooser createSaveAsFileChoser(Source var1);

    public abstract JFileChooser createOpenFileChooser(File var1);

    static /* synthetic */ File access$0() {
        return USER_HOME;
    }

    static /* synthetic */ boolean access$3(SourceEditorMenuBarMediator sourceEditorMenuBarMediator, int n) {
        return sourceEditorMenuBarMediator.avoidUnsavedExit(n);
    }

    public class FileMenu
    extends JMenu {
        public JMenuItem openMenuItem;
        public JMenuItem saveMenuItem;
        public JMenuItem saveAsMenuItem;
        public JMenuItem closeMenuItem;
        public JMenuItem quitMenuItem;
        public JMenuItem exportMenuItem;

        public JMenuItem getCloseMenuItem() {
            return this.closeMenuItem;
        }

        public JMenuItem getOpenMenuItem() {
            return this.openMenuItem;
        }

        public JMenuItem getQuitMenuItem() {
            return this.quitMenuItem;
        }

        public JMenuItem getSaveAsMenuItem() {
            return this.saveAsMenuItem;
        }

        public JMenuItem getSaveMenuItem() {
            return this.saveMenuItem;
        }

        public JMenuItem getExportMenuItem() {
            return this.exportMenuItem;
        }

        public FileMenu() {
            this.setText("\u30d5\u30a1\u30a4\u30eb");
            this.openMenuItem = new OpenMenuItem();
            this.saveMenuItem = new SaveMenuItem();
            this.saveAsMenuItem = new SaveAsMenuItem();
            this.closeMenuItem = new CloseMenuItem();
            this.quitMenuItem = new QuitMenuItem();
            this.exportMenuItem = SourceEditorMenuBarMediator.this.createExportMenuItem();
            this.add(SourceEditorMenuBarMediator.this.createNewMenuItem());
            this.add(this.openMenuItem);
            this.add(new JSeparator());
            this.add(this.saveMenuItem);
            this.add(this.saveAsMenuItem);
            this.add(this.exportMenuItem);
            this.add(new JSeparator());
            this.add(this.closeMenuItem);
            this.add(new JSeparator());
            this.add(this.quitMenuItem);
        }

        private void save() {
            Source source = SourceEditorMenuBarMediator.this.getCurrentSource();
            if (source.isDirty()) {
                if (SourceEditorMenuBarMediator.this.avoidOverrideUpdatedFile(source)) {
                    return;
                }
                try {
                    source.save();
                }
                catch (IOException ex) {
                    SourceEditorMenuBarMediator.this.showError(ex, "\u30d5\u30a1\u30a4\u30eb\u306e\u4fdd\u5b58\u304c\u3067\u304d\u307e\u305b\u3093:" + source.getFile());
                }
            }
        }

        private void saveAs() {
            Source currentSource = SourceEditorMenuBarMediator.this.getCurrentSource();
            JFileChooser saveAsFileChooser = SourceEditorMenuBarMediator.this.createSaveAsFileChoser(currentSource);
            int result = saveAsFileChooser.showSaveDialog(SourceEditorMenuBarMediator.this.menuBar);
            if (result == 0) {
                File saveAsFile = saveAsFileChooser.getSelectedFile();
                if (saveAsFile.equals(currentSource.getFile())) {
                    this.save();
                    return;
                }
                if (SourceEditorMenuBarMediator.this.avoidOverrideOpenedBuffer(saveAsFile)) {
                    return;
                }
                if (SourceEditorMenuBarMediator.this.avoidOverwriteFile(saveAsFile)) {
                    return;
                }
                currentSource.setFile(saveAsFile);
                currentSource.setReadOnly(false);
                try {
                    currentSource.save();
                }
                catch (IOException ex) {
                    SourceEditorMenuBarMediator.this.showError(ex, "\u30d5\u30a1\u30a4\u30eb\u306e\u4fdd\u5b58\u304c\u3067\u304d\u307e\u305b\u3093:" + currentSource.getFile());
                }
            }
        }

        static /* synthetic */ void access$0(FileMenu fileMenu) {
            fileMenu.saveAs();
        }

        static /* synthetic */ void access$1(FileMenu fileMenu) {
            fileMenu.save();
        }

        public class OpenMenuItem
        extends JMenuItem {
            public OpenMenuItem() {
                this.setText("\u958b\u304f\u2026");
                this.addActionListener(this.createFileOpenActionListener());
            }

            private ActionListener createFileOpenActionListener() {
                return new ActionListener(this){
                    final /* synthetic */ OpenMenuItem this$2;
                    {
                        this.this$2 = openMenuItem;
                    }

                    public void actionPerformed(ActionEvent ev) {
                        File defaultFolder = SourceEditorMenuBarMediator.access$0();
                        try {
                            defaultFolder = SourceEditorMenuBarMediator.access$1(FileMenu.access$2(OpenMenuItem.access$0(this.this$2))).getFile().getParentFile();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        JFileChooser openFileChooser = FileMenu.access$2(OpenMenuItem.access$0(this.this$2)).createOpenFileChooser(defaultFolder);
                        int result = openFileChooser.showOpenDialog(FileMenu.access$2((FileMenu)OpenMenuItem.access$0((OpenMenuItem)this.this$2)).menuBar);
                        if (result == 0) {
                            FileMenu.access$2(OpenMenuItem.access$0(this.this$2)).open(openFileChooser.getSelectedFile());
                        }
                    }
                };
            }

            static /* synthetic */ FileMenu access$0(OpenMenuItem openMenuItem) {
                return openMenuItem.FileMenu.this;
            }
        }

        public class CloseMenuItem
        extends JMenuItem {
            public CloseMenuItem() {
                this.setText("\u9589\u3058\u308b");
                this.addActionListener(SourceEditorMenuBarMediator.this.createFileCloseActionListener());
            }
        }

        public class SaveMenuItem
        extends JMenuItem {
            public SaveMenuItem() {
                this.setText("\u4fdd\u5b58\u3059\u308b");
                this.addActionListener(this.createFileSaveActionListener());
            }

            private ActionListener createFileSaveActionListener() {
                return new ActionListener(this){
                    final /* synthetic */ SaveMenuItem this$2;
                    {
                        this.this$2 = saveMenuItem;
                    }

                    public void actionPerformed(ActionEvent ev) {
                        if (SourceEditorMenuBarMediator.access$1(FileMenu.access$2(SaveMenuItem.access$0(this.this$2))).getFile() == null) {
                            FileMenu.access$0(SaveMenuItem.access$0(this.this$2));
                        } else {
                            FileMenu.access$1(SaveMenuItem.access$0(this.this$2));
                        }
                        FileMenu.access$2((FileMenu)SaveMenuItem.access$0((SaveMenuItem)this.this$2)).mediator.getSourceEditorTabbedPane().updateCurrentTitle();
                        FileMenu.access$2(SaveMenuItem.access$0(this.this$2)).updateMenu();
                    }
                };
            }

            static /* synthetic */ FileMenu access$0(SaveMenuItem saveMenuItem) {
                return saveMenuItem.FileMenu.this;
            }
        }

        public class SaveAsMenuItem
        extends JMenuItem {
            public SaveAsMenuItem() {
                this.setText("\u540d\u524d\u3092\u5909\u3048\u3066\u4fdd\u5b58\u3059\u308b\u2026");
                this.addActionListener(this.createSaveAsActionListener());
            }

            private ActionListener createSaveAsActionListener() {
                return new ActionListener(this){
                    final /* synthetic */ SaveAsMenuItem this$2;
                    {
                        this.this$2 = saveAsMenuItem;
                    }

                    public void actionPerformed(ActionEvent ev) {
                        FileMenu.access$0(SaveAsMenuItem.access$0(this.this$2));
                        FileMenu.access$2((FileMenu)SaveAsMenuItem.access$0((SaveAsMenuItem)this.this$2)).mediator.getSourceEditorTabbedPane().updateCurrentTitle();
                        FileMenu.access$2(SaveAsMenuItem.access$0(this.this$2)).updateMenu();
                    }
                };
            }

            static /* synthetic */ FileMenu access$0(SaveAsMenuItem saveAsMenuItem) {
                return saveAsMenuItem.FileMenu.this;
            }
        }

        public class QuitMenuItem
        extends JMenuItem {
            public QuitMenuItem() {
                this.setText("\u7d42\u4e86");
                this.addActionListener(this.createQuitActionListener());
            }

            private ActionListener createQuitActionListener() {
                return new ActionListener(this){
                    final /* synthetic */ QuitMenuItem this$2;
                    {
                        this.this$2 = quitMenuItem;
                    }

                    public void actionPerformed(ActionEvent ev) {
                        if (SourceEditorMenuBarMediator.access$3(FileMenu.access$2(QuitMenuItem.access$0(this.this$2)), FileMenu.access$2((FileMenu)QuitMenuItem.access$0((QuitMenuItem)this.this$2)).mediator.getSourceManager().countDirtySources())) {
                            return;
                        }
                        System.exit(0);
                    }
                };
            }

            static /* synthetic */ FileMenu access$0(QuitMenuItem quitMenuItem) {
                return quitMenuItem.FileMenu.this;
            }
        }
    }

    public class HelpMenu
    extends JMenu {
        public HelpMenu() {
            this.setText("\u30d8\u30eb\u30d7");
            this.add(new HelpMenuItem());
            this.add(SourceEditorMenuBarMediator.this.createAboutMenuItem());
            this.setEnabled(false);
        }

        public class HelpMenuItem
        extends JMenuItem {
            public HelpMenuItem() {
                this.setText("\u30d8\u30eb\u30d7\u306e\u76ee\u6b21");
            }
        }
    }
}

