/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sqs_xml.editor.base.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.tree.TreePath;
import net.sf.sqs_xml.editor.base.swing.NodeTreePane;
import net.sf.sqs_xml.editor.base.swing.TreeNodePopupMenu;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class TreeNodePopupAdapter
implements ActionListener {
    private TreeNodePopupMenu menu;

    TreeNodePopupAdapter(TreeNodePopupMenu menu) {
        this.menu = menu;
    }

    public void actionPerformed(ActionEvent ev) {
        String[] commandArgs = ev.getActionCommand().split("\\s");
        String command = commandArgs[0];
        int target = Integer.parseInt(commandArgs[1]);
        if (command.equals("d")) {
            this.delete(target, true);
        } else if (command.equals("c")) {
            this.delete(target, false);
        } else if (command.equals("b")) {
            this.insert(target, true);
        } else if (command.equals("i")) {
            this.insertWithin(target);
        } else if (command.equals("a")) {
            this.insert(target, false);
        } else if (command.equals("S")) {
            this.showAll(target);
        } else if (command.equals("H")) {
            this.hideAll(target);
        }
        this.menu.getTreePane().updateUI();
    }

    private List getRecentCutNode() {
        return this.menu.getTreePane().mediator.menuBarMediator.getRecentCutNode();
    }

    private void setRecentCutNode(List list) {
        this.menu.getTreePane().mediator.menuBarMediator.setRecentCutNode(list);
    }

    private void insert(int target, boolean isInsertBeforeMode) {
        if (this.isReadOnly()) {
            return;
        }
        List recentCutNode = this.getRecentCutNode();
        if (recentCutNode == null || recentCutNode.size() == 0) {
            return;
        }
        NodeTreePane tree = this.menu.getTreePane();
        TreePath path = tree.getPathForRow(target);
        TreePath parentPath = path.getParentPath();
        Node currentNode = (Node)path.getLastPathComponent();
        Node parentNode = (Node)parentPath.getLastPathComponent();
        boolean appendMode = false;
        if (!isInsertBeforeMode) {
            Node nextNode = currentNode.getNextSibling();
            if (nextNode == null) {
                appendMode = true;
            } else {
                currentNode = nextNode;
            }
        }
        this.insertNode(recentCutNode, tree, parentPath, currentNode, parentNode, appendMode);
        tree.mediator.tabbedPane.getCurrentEditingSource().setDirty(true);
        tree.mediator.tabbedPane.updateCurrentTitle();
        this.updateTree(tree);
    }

    private void insertNode(List recentCutNode, NodeTreePane tree, TreePath parentPath, Node currentNode, Node parentNode, boolean appendMode) {
        Document document = tree.mediator.tabbedPane.getCurrentEditingSource().getDocument();
        int i = 0;
        while (i < recentCutNode.size()) {
            Node insertedNode = document.importNode((Node)recentCutNode.get(i), true);
            TreePath insertedPath = parentPath.pathByAddingChild(insertedNode);
            if (appendMode) {
                this.menu.getTreePane().appendChildNode(parentNode, insertedNode);
            } else {
                this.menu.getTreePane().insertBefore(currentNode, parentNode, insertedNode);
            }
            tree.getSelectionModel().addSelectionPath(insertedPath);
            ++i;
        }
    }

    private boolean isReadOnly() {
        return this.menu.isReadOnly();
    }

    private void insertWithin(int target) {
        if (this.isReadOnly()) {
            return;
        }
        List recentCutNode = this.getRecentCutNode();
        if (recentCutNode == null || recentCutNode.size() == 0) {
            return;
        }
        NodeTreePane tree = this.menu.getTreePane();
        TreePath currentPath = tree.getPathForRow(target);
        Node currentNode = (Node)currentPath.getLastPathComponent();
        int i = 0;
        while (i < recentCutNode.size()) {
            Node insertedNode = ((Node)recentCutNode.get(i)).cloneNode(true);
            TreePath insertedPath = currentPath.pathByAddingChild(insertedNode);
            this.menu.getTreePane().appendChildNode(currentNode, insertedNode);
            tree.getSelectionModel().addSelectionPath(insertedPath);
            ++i;
        }
        tree.mediator.tabbedPane.getCurrentEditingSource().setDirty(true);
        tree.mediator.tabbedPane.updateCurrentTitle();
        this.updateTree(tree);
    }

    private void delete(int target, boolean isDeleteMode) {
        int[] rows;
        NodeTreePane tree = this.menu.getTreePane();
        if (this.isNodeDeleteProihibited(isDeleteMode, tree, rows = tree.getSelectionModel().getSelectionRows())) {
            return;
        }
        List recentCutNode = this.resetRecentCutNode();
        this.deleteNode(isDeleteMode, tree, rows, recentCutNode);
        if (!this.isReadOnly() && isDeleteMode) {
            this.updateTree(tree);
            tree.mediator.tabbedPane.getCurrentEditingSource().setDirty(true);
            tree.mediator.tabbedPane.updateCurrentTitle();
        }
    }

    private boolean isNodeDeleteProihibited(boolean isDeleteMode, NodeTreePane tree, int[] rows) {
        return rows.length == 0 || isDeleteMode && rows.length > 0 && tree.mediator.getMenuBarMediator().avoidNodeDelete(rows.length);
    }

    private List resetRecentCutNode() {
        LinkedList recentCutNode = this.getRecentCutNode();
        if (recentCutNode == null) {
            recentCutNode = new LinkedList();
            this.setRecentCutNode(recentCutNode);
        } else {
            recentCutNode.clear();
        }
        return recentCutNode;
    }

    private void deleteNode(boolean isDeleteMode, NodeTreePane tree, int[] rows, List recentCutNode) {
        int i = 0;
        while (i < rows.length) {
            TreePath path = tree.getPathForRow(rows[i]);
            Node leaf = (Node)path.getLastPathComponent();
            Node parent = (Node)path.getParentPath().getLastPathComponent();
            recentCutNode.add(leaf);
            if (!this.isReadOnly() && isDeleteMode) {
                parent.removeChild(leaf);
                tree.getSelectionModel().removeSelectionPath(path);
            }
            ++i;
        }
    }

    private void updateTree(NodeTreePane tree) {
        tree.setupEditorPane();
    }

    private void showAll(int target) {
        NodeTreePane tree = this.menu.getTreePane();
        TreePath[] paths = tree.getSelectionPaths();
        int i = 0;
        while (i < paths.length) {
            tree.expandDecendant(paths[i]);
            ++i;
        }
    }

    private void hideAll(int target) {
        boolean doCollapsed = false;
        NodeTreePane tree = this.menu.getTreePane();
        if (tree.isCollapsed(target)) {
            return;
        }
        TreePath[] paths = tree.getSelectionPaths();
        int i = 0;
        while (i < paths.length) {
            TreePath branchPath = paths[i];
            if (!tree.isCollapsed(branchPath)) {
                NodeList branchObjectList = ((Node)branchPath.getLastPathComponent()).getChildNodes();
                int j = 0;
                while (j < branchObjectList.getLength()) {
                    TreePath subBranchPath = branchPath.pathByAddingChild(branchObjectList.item(j));
                    if (!tree.isCollapsed(subBranchPath)) {
                        tree.collapsePath(subBranchPath);
                        doCollapsed = true;
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (!doCollapsed) {
            tree.collapseRow(target);
        }
    }
}

