/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sqs_xml.editor.sqs.modules.panel;

import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import net.sf.sqs_xml.editor.base.modules.AbstractNodeEditor;
import net.sf.sqs_xml.editor.base.modules.EditorUtil;
import net.sf.sqs_xml.editor.base.modules.panel.AbstractNodeEditorPanel;
import net.sf.sqs_xml.util.DOMUtil;
import org.w3c.dom.Element;

public class TextareaFormSizePanel
extends AbstractNodeEditorPanel {
    static int DEFAULT_WIDTH = 400;
    static int DEFAULT_HEIGHT = 30;
    int width;
    int height;
    SpinnerModel widthSpinnerModel;
    SpinnerModel heightSpinnerModel;

    public TextareaFormSizePanel(AbstractNodeEditor editor) {
        super(editor);
        Element elem = (Element)editor.getNode();
        JComponent widthForm = this.createWidthForm(elem);
        JComponent heightForm = this.createHeightForm(elem);
        Box sizePanel = Box.createHorizontalBox();
        sizePanel.setBorder(new TitledBorder(EditorUtil.LOWERED_BORDER, "\u30b5\u30a4\u30ba"));
        sizePanel.add(Box.createHorizontalGlue());
        sizePanel.add(Box.createHorizontalStrut(24));
        sizePanel.add(widthForm);
        sizePanel.add(Box.createHorizontalGlue());
        sizePanel.add(heightForm);
        sizePanel.add(Box.createHorizontalStrut(24));
        this.add(sizePanel);
        this.initSize();
    }

    private JComponent createHeightForm(Element elem) {
        this.height = DOMUtil.intValueOf(this.getEditor().getSource().getDocument(), elem, "@sqs:height");
        JSpinner heightSpinner = this.createHeightSpinner(this.height);
        heightSpinner.addChangeListener(this.getEditor().getUpdateListener());
        heightSpinner.addFocusListener(this.getEditor().getUpdateListener());
        Box heightForm = EditorUtil.createSpinnerForm("\u9ad8\u3055(0\u301c841):", heightSpinner);
        if (this.getEditor().getSource().isReadOnly()) {
            heightSpinner.setEnabled(false);
        }
        return heightForm;
    }

    private JComponent createWidthForm(Element elem) {
        this.width = DOMUtil.intValueOf(this.getEditor().getSource().getDocument(), elem, "@sqs:width");
        JSpinner widthSpinner = this.createWidthSpinner(this.width);
        widthSpinner.addFocusListener(this.getEditor().getUpdateListener());
        widthSpinner.addChangeListener(this.getEditor().getUpdateListener());
        Box widthForm = EditorUtil.createSpinnerForm("\u5e45(0\u301c595):", widthSpinner);
        if (this.getEditor().getSource().isReadOnly()) {
            widthSpinner.setEnabled(false);
        }
        return widthForm;
    }

    private JSpinner createWidthSpinner(int width) {
        JSpinner widthSpinner = new JSpinner(this.createWidthModel(width));
        widthSpinner.setValue(new Integer(width));
        this.widthSpinnerModel = widthSpinner.getModel();
        return widthSpinner;
    }

    private JSpinner createHeightSpinner(int height) {
        JSpinner heightSpinner = new JSpinner(this.createHeightModel(height));
        heightSpinner.setValue(new Integer(height));
        this.heightSpinnerModel = heightSpinner.getModel();
        return heightSpinner;
    }

    private SpinnerNumberModel createWidthModel(int value) {
        return new SpinnerNumberModel(value, 0, 595, 1);
    }

    private SpinnerNumberModel createHeightModel(int value) {
        return new SpinnerNumberModel(value, 0, 841, 1);
    }

    public int getPreferredHeight() {
        return 30;
    }

    public boolean updateNodeValue() {
        if (this.width != (Integer)this.widthSpinnerModel.getValue() || this.height != (Integer)this.heightSpinnerModel.getValue()) {
            this.getEditor().updateAttributeValue(".", "http://sqs.cmr.sfc.keio.ac.jp/2004/sqs", "sqs", "width", this.widthSpinnerModel.getValue());
            this.getEditor().updateAttributeValue(".", "http://sqs.cmr.sfc.keio.ac.jp/2004/sqs", "sqs", "height", this.heightSpinnerModel.getValue());
            return true;
        }
        return false;
    }
}

