/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sqs_xml.reader.logic;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.image.Raster;
import java.util.HashSet;
import java.util.LinkedList;
import net.sf.sqs_xml.image.RasterSource;
import net.sf.sqs_xml.reader.logic.ReaderSourceException;

public class ReaderSource
extends RasterSource {
    static final float WIDTH = 595.0f;
    static final float HEIGHT = 841.0f;
    static final float TOP_GUIDEBLOCK_WIDTH = 0.033613447f;
    static final float BOTTOM_GUIDEBLOCK_WIDTH = 0.011890606f;
    static final int SCAN_UNIT_WIDTH_DIV = 2;
    final int blockSearchLengthMax = this.getGuideBlockWidth(true) * 3;
    final int sideMargin = this.getGuideBlockWidth(true) * 2;
    Point2D[] scanFrameCorner = null;

    public ReaderSource(Raster raster) {
        super(raster);
    }

    int getGuideBlockWidth(boolean isPageTop) {
        if (isPageTop) {
            return (int)((float)this.getWidth() * 0.033613447f);
        }
        return (int)((float)this.getWidth() * 0.011890606f);
    }

    LinkedList scanBlocksHorizontal(int y, boolean isTop) {
        LinkedList<Rectangle> candidate = new LinkedList<Rectangle>();
        int blockWidth = this.getGuideBlockWidth(isTop);
        boolean[] buf = new boolean[blockWidth / 2];
        int offset = 0;
        int numberOfWhitePixels = 0;
        int numberOfFlips = 0;
        Rectangle currentRectangle = null;
        int x = this.sideMargin;
        while (x < this.getWidth() - this.sideMargin) {
            boolean currentIsWhite;
            boolean previousIsWhite = buf[offset];
            buf[offset] = currentIsWhite = !this.isBlack(x, y);
            if (++offset == blockWidth / 2) {
                offset = 0;
            }
            if (previousIsWhite) {
                --numberOfWhitePixels;
            }
            if (currentIsWhite) {
                ++numberOfWhitePixels;
            }
            double whiteRatio = 2.0 * (double)numberOfWhitePixels / (double)blockWidth;
            if (numberOfFlips % 2 == 0) {
                if (0.9 < whiteRatio) {
                    ++numberOfFlips;
                    if (currentRectangle != null) {
                        try {
                            int w = (x - currentRectangle.x - buf.length) / 2;
                            Point center = new Point(currentRectangle.x + w, currentRectangle.y);
                            int upperBlackLength = this.scanBlackLineTop(center.x, center.y, true, this.blockSearchLengthMax);
                            int lowerBlackLength = this.scanBlackLineBottom(center.x, center.y, true, this.blockSearchLengthMax);
                            currentRectangle.y = y - upperBlackLength;
                            currentRectangle.height = upperBlackLength + lowerBlackLength;
                            currentRectangle.width = this.scanBlackLineLeft(center.x, center.y, true, this.blockSearchLengthMax) + this.scanBlackLineRight(center.x, center.y, true, this.blockSearchLengthMax);
                        }
                        catch (ReaderSourceException ex) {
                            candidate.removeLast();
                            currentRectangle = null;
                        }
                    }
                }
            } else if (whiteRatio < 0.1) {
                ++numberOfFlips;
                currentRectangle = new Rectangle(x, y, 0, 0);
                candidate.add(currentRectangle);
            }
            ++x;
        }
        LinkedList ret = this.createValidBlockList(isTop, candidate);
        candidate.clear();
        return ret;
    }

    private LinkedList createValidBlockList(boolean isTop, LinkedList candidate) {
        LinkedList<Rectangle> ret = new LinkedList<Rectangle>();
        int i = 0;
        while (i < candidate.size()) {
            Rectangle rect = (Rectangle)candidate.get(i);
            if (this.isValidBlock(rect, isTop)) {
                ret.add(rect);
            }
            ++i;
        }
        return ret;
    }

    private boolean isValidBlock(Rectangle rect, boolean isTop) {
        int modifiedWidth = isTop ? rect.width : 2 * rect.width;
        if (rect.height == 0) {
            return false;
        }
        double widthHeightRatio = 1.0 * (double)modifiedWidth / (double)rect.height;
        int topWidth = this.getGuideBlockWidth(true);
        return (double)topWidth * 0.6 < (double)Math.min(modifiedWidth, rect.height) && (double)Math.max(modifiedWidth, rect.height) < (double)topWidth * 1.3 && 0.8 < widthHeightRatio && widthHeightRatio < 1.3;
    }

    private int[] scanGuideBorder(int topHint, int bottomHint, boolean isTop) throws ReaderSourceException {
        int startYValue = 0;
        int endYValue = 0;
        LinkedList maxRectangleList = new LinkedList();
        int y = topHint;
        while (y < bottomHint) {
            LinkedList rectangleList = this.scanBlocksHorizontal(y, isTop);
            if (maxRectangleList.size() < rectangleList.size()) {
                startYValue = y;
                endYValue = y;
                maxRectangleList = rectangleList;
            } else if (maxRectangleList.size() == rectangleList.size()) {
                endYValue = y;
            }
            ++y;
        }
        if (11 <= maxRectangleList.size()) {
            Rectangle r1 = (Rectangle)maxRectangleList.getFirst();
            Rectangle r2 = (Rectangle)maxRectangleList.getLast();
            maxRectangleList.clear();
            return new int[]{startYValue, endYValue, r1.x, r2.x};
        }
        int i = 0;
        while (i < maxRectangleList.size()) {
            System.err.println("*** " + maxRectangleList.get(i));
            ++i;
        }
        throw new ReaderSourceException("(found " + maxRectangleList.size() + " in " + startYValue + "-" + endYValue + ")");
    }

    Point2D getGuideBlockCenter(Rectangle r) throws ReaderSourceException {
        return this.getGuideBlockCenter(r.x + r.width / 2, r.y + r.height / 2);
    }

    Point2D getGuideBlockCenter(int ox, int oy) throws ReaderSourceException {
        int max = this.getWidth() / 20;
        HashSet<Point2D.Double> center = new HashSet<Point2D.Double>();
        int ty2;
        int ty1;
        int tx2;
        int tx1;
        Point2D.Double current;
        while (!center.contains(current = new Point2D.Double(ox -= ((tx1 = this.scanBlackLineLeft(ox, oy, true, max)) - (tx2 = this.scanBlackLineRight(ox, oy, true, max))) / 2, oy -= ((ty1 = this.scanBlackLineTop(ox, oy, true, max)) - (ty2 = this.scanBlackLineBottom(ox, oy, true, max))) / 2))) {
            center.add(current);
        }
        return current;
    }

    int scanBlackLineTop(int x, int y, boolean isBlack, int length) throws ReaderSourceException {
        Point p = new Point();
        int i = 0;
        while (i < length) {
            if (isBlack != this.isBlack(this.getRGBColor(x, y - i))) {
                return i;
            }
            ++i;
        }
        throw new ReaderSourceException("cannot reach edge");
    }

    int scanBlackLineBottom(int x, int y, boolean isBlack, int length) throws ReaderSourceException {
        int i = 0;
        while (i < length) {
            if (isBlack != this.isBlack(this.getRGBColor(x, y + i))) {
                return i;
            }
            ++i;
        }
        throw new ReaderSourceException("cannot reach edge");
    }

    int scanBlackLineLeft(int x, int y, boolean isBlack, int length) throws ReaderSourceException {
        int i = 0;
        while (i < length) {
            if (isBlack != this.isBlack(this.getRGBColor(x - i, y))) {
                return i;
            }
            ++i;
        }
        throw new ReaderSourceException("cannot reach edge");
    }

    int scanBlackLineRight(int x, int y, boolean isBlack, int length) throws ReaderSourceException {
        int i = 0;
        while (i < length) {
            if (isBlack != this.isBlack(this.getRGBColor(x + i, y))) {
                return i;
            }
            ++i;
        }
        throw new ReaderSourceException("cannot reach edge");
    }

    Point2D[] createScanFrameCorner() throws ReaderSourceException {
        int[] bottom;
        int[] top;
        try {
            top = this.scanGuideBorder(0, this.getHeight() / 8, true);
        }
        catch (ReaderSourceException ex) {
            throw new ReaderSourceException("\u4e0a\u5074\u306e\u300c\u25a0\u300d\u306e\u5217\u3092\u6b63\u5e38\u306b\u8a8d\u8b58\u3067\u304d\u307e\u305b\u3093");
        }
        try {
            bottom = this.scanGuideBorder(this.getHeight() - this.getHeight() / 8, this.getHeight() - 1, false);
        }
        catch (ReaderSourceException ex) {
            throw new ReaderSourceException("\u4e0b\u5074\u306e\u300c\u25a0\u300d\u306e\u5217\u3092\u6b63\u5e38\u306b\u8a8d\u8b58\u3067\u304d\u307e\u305b\u3093");
        }
        Point2D[] p = new Point2D[]{this.getGuideBlockCenter(top[2], (top[0] + top[1]) / 2), this.getGuideBlockCenter(top[3], (top[0] + top[1]) / 2), this.getGuideBlockCenter(bottom[2], (bottom[0] + bottom[1]) / 2), this.getGuideBlockCenter(bottom[3], (bottom[0] + bottom[1]) / 2)};
        this.scanFrameCorner = p;
        return p;
    }

    boolean checkGuideSquareShape(Point2D[] guide) {
        double sl2;
        double gx1 = guide[0].getX() - guide[1].getX();
        double gx2 = guide[0].getX() - guide[2].getX();
        double gy1 = guide[0].getY() - guide[1].getY();
        double gy2 = guide[0].getY() - guide[2].getY();
        double gl1 = Math.sqrt(gx1 * gx1 + gy1 * gy1);
        double gl2 = Math.sqrt(gx2 * gx2 + gy2 * gy2);
        double sx1 = this.scanFrameCorner[0].getX() - this.scanFrameCorner[1].getX();
        double sx2 = this.scanFrameCorner[0].getX() - this.scanFrameCorner[2].getX();
        double sy1 = this.scanFrameCorner[0].getY() - this.scanFrameCorner[1].getY();
        double sy2 = this.scanFrameCorner[0].getY() - this.scanFrameCorner[2].getY();
        double sl1 = Math.sqrt(sx1 * sx1 + sy1 * sy1);
        return Math.abs(sl1 / gl1 - (sl2 = Math.sqrt(sx2 * sx2 + sy2 * sy2)) / gl2) < 0.02 * (sy2 / gy2) && Math.abs(sl1 / sl2 - gl1 / gl2) < 0.02 * (sy2 / gy2);
    }
}

