/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sqs_xml.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import net.sf.sqs_xml.swing.ButtonControllableProgressLogger;
import net.sf.sqs_xml.swing.LoggerTextArea;
import org.apache.avalon.framework.logger.Logger;

public class LoggerConsoleFrame
extends ButtonControllableProgressLogger {
    JScrollPane scrollPane;

    public LoggerConsoleFrame(String title, String cancelButtonLabel, String finishButtonLabel) {
        super(title, cancelButtonLabel, finishButtonLabel);
        this.setTitle(title);
        this.logger = this.createLogger(title);
        this.scrollPane = this.createScrollPane();
        this.addWindowFocusListener(new WindowAdapter(){

            public void windowGainedFocus(WindowEvent e) {
                if (LoggerConsoleFrame.this.logger instanceof LoggerTextArea) {
                    ((LoggerTextArea)LoggerConsoleFrame.this.logger).setAutoScrollToTail(false);
                }
            }

            public void windowLostFocus(WindowEvent e) {
                if (LoggerConsoleFrame.this.logger instanceof LoggerTextArea) {
                    ((LoggerTextArea)LoggerConsoleFrame.this.logger).setAutoScrollToTail(true);
                }
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent ev) {
                LoggerConsoleFrame.this.doLayout();
                LoggerConsoleFrame.this.repaint();
            }
        });
        this.initialize();
    }

    public Logger createLogger(String title) {
        return new LoggerTextArea(title, 1, 32);
    }

    public JComponent getBase() {
        return this.base;
    }

    public JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public void initialize() {
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.base, "North");
        this.getContentPane().add((Component)this.scrollPane, "Center");
        this.setSize(480, 300);
    }

    private JScrollPane createScrollPane() {
        if (this.logger instanceof LoggerTextArea) {
            JScrollPane scrollPane = new JScrollPane((LoggerTextArea)this.logger);
            scrollPane.setVerticalScrollBarPolicy(22);
            return scrollPane;
        }
        return new JScrollPane();
    }
}

