/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sqs_xml.swing;

import java.awt.Color;
import java.awt.Dimension;
import javax.swing.JProgressBar;
import net.sf.sqs_xml.swing.AbstractLogger;
import net.sf.sqs_xml.swing.LoggerTextArea;
import net.sf.sqs_xml.swing.SwingUtil;

class ProgressLogger
extends AbstractLogger {
    JProgressBar progressBar = this.createProgressBar();

    ProgressLogger() {
    }

    private JProgressBar createProgressBar() {
        this.progressBar = new JProgressBar();
        this.progressBar.setMinimumSize(new Dimension(480, 24));
        return this.progressBar;
    }

    public JProgressBar getProgressBar() {
        return this.progressBar;
    }

    public void error(String arg0, Throwable arg1) {
        super.error(arg0, arg1);
        this.progressBar.setForeground(Color.red);
    }

    public void error(String arg0) {
        super.error(arg0);
        this.progressBar.setForeground(Color.red);
    }

    public void fatalError(String arg0, Throwable arg1) {
        super.fatalError(arg0, arg1);
        this.progressBar.setForeground(Color.red);
    }

    public void fatalError(String arg0) {
        super.fatalError(arg0);
        this.progressBar.setForeground(Color.red);
    }

    public void warn(String arg0, Throwable arg1) {
        super.warn(arg0, arg1);
        this.progressBar.setForeground(Color.magenta);
    }

    public void warn(String arg0) {
        super.warn(arg0);
        this.progressBar.setForeground(Color.magenta);
    }

    public void setFinished(boolean isFinished) {
        if (isFinished) {
            if (this.isSucceed) {
                if (this.hasWarn) {
                    this.progressBar.setForeground(Color.magenta);
                } else {
                    this.progressBar.setForeground(Color.green);
                }
            } else if (this.hasError) {
                this.progressBar.setForeground(Color.red);
            }
            this.progressBar.setMaximum(100);
            this.progressBar.setValue(100);
            this.progressBar.setIndeterminate(false);
        } else {
            if (this.logger instanceof LoggerTextArea) {
                ((LoggerTextArea)this.logger).clear();
            }
            this.hasError = false;
            this.isSucceed = false;
            this.progressBar.setForeground(SwingUtil.FORGROUND_COLOR);
            this.progressBar.setIndeterminate(true);
        }
    }
}

