/*

 SQSEditorFrame.java
 
 Copyright 2004 KUBO Hiroya (hiroya@sfc.keio.ac.jp).
 
 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at
 
 http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 
 Created on Jun 30, 2004

 */
package net.sf.sqs_xml.editor.sqs.swing;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;

import net.sf.sqs_xml.editor.base.source.Source;
import net.sf.sqs_xml.editor.base.swing.SourceEditorMenuBarMediator;
import net.sf.sqs_xml.translator.logic.TranslatorException;
import net.sf.sqs_xml.util.FileUtil;


/**
 * @author hiroya
 *
 */
public class SQSSourceEditorMenuBarMediator extends SourceEditorMenuBarMediator {
    static final String[] TEMPLATE_LABELS = { "点検型テンプレート", "課題発見型テンプレート",
            "課題改善型テンプレート", "通常テンプレート" };

    static final String[][] TEMPLATE_ITEMS = {
            { "[点検活動] 実現度", "[点検活動] 適合度", "[点検活動] 重要度", "[点検活動] 満足度" },
            { "[課題発見活動] 重要度-満足度", "[課題発見活動] 重要度-実現度" }, { "[課題改善活動]めざそう値-分担値" } };

    static final String[][] TEMPLATE_FILES = {
            { "check-actualization.sqs", "check-agreement.sqs",
                    "check-importance.sqs", "check-satisfaction.sqs" },
            { "discover-importance-satisfaction.sqs",
                    "discover-importance-actualization.sqs" },
            { "simple.sqs"/* "improve-outcome.sqs" */}, { "simple.sqs" } };

    /*
    static final boolean[][] TEMPLATE_READONLY = {
            { true, true, true, true },
            { true, true },
            { true}, { false } };
*/
    static final boolean[][] TEMPLATE_READONLY = {
            { false, false, false, false },
            { false, false },
            { false}, { false } };

    static final boolean[][] TEMPLATE_ENABLED = {
            { true, true, true, true },
            { true, true },
            { false}, { true } };

    ExportFileLogic exportFileLogic;
    JFileChooser exportFileChooser;
	public SQSSourceEditorMenuBarMediator(SQSSourceEditorMediator mediator) {
	    super(mediator);
	    exportFileLogic = new ExportFileLogic(getMediator());
        exportFileChooser = SQSFileChooser.createExportFileChooser();
	}
	
	public ExportFileLogic getExportFileLogic(){
	    return exportFileLogic;
	}
	
    public JMenu createNewMenuItem() {
	    JMenu newMenu = new JMenu();
        newMenu.setText("新規作成");
        newMenu.add(createNewMenu(0));
        newMenu.add(createNewMenu(1));
        newMenu.add(createNewMenu(2));
        newMenu.add(new JSeparator());
        newMenu.add(createNewMenuItem(3, -1));
        return newMenu;
	}
    
    public JMenuItem createExportMenuItem() {
        JMenuItem exportMenuItem = new JMenuItem();
	    exportMenuItem.setText("書き出し…");
        exportMenuItem.addActionListener(new ActionListener(){
	        public void actionPerformed(ActionEvent ev){
	            try{
	                getMediator().getFrame().setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
	                exportFileLogic.export(null, ExportFileLogic.USER_SELECTION_MODE);
	            }catch(TranslatorException ex){
	                showError(ex, "書き出しに失敗しました．");
	            }catch(IOException ex){
	                showError(ex, "書き出しに失敗しました．");
	            }finally{
	                getMediator().getFrame().setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));
	            }
			}
	    });
        return exportMenuItem;
    }
    
    public File exportFile(File sourceFile, String suffix){
        File tgtFile;
        if(sourceFile != null){
            if(exportFileChooser.getSelectedFile() == null || ! exportFileChooser.getSelectedFile().getName().endsWith(suffix)){
                tgtFile = new File(FileUtil.getBasename(sourceFile)+suffix);
                exportFileChooser.setSelectedFile(tgtFile);
            }
        }else{
            exportFileChooser.setSelectedFile(new File(exportFileChooser.getCurrentDirectory()+File.separator+SQSFileChooser.DEFAULT_FILENAME+suffix));
        }
        
        while(true){
            int state = exportFileChooser.showSaveDialog(getMediator().getFrame());
            if(state != JFileChooser.APPROVE_OPTION){
                return null;
            }
            tgtFile = exportFileChooser.getSelectedFile();
            if(tgtFile != null){
                String selectedName = tgtFile.getName().toLowerCase();
                if(selectedName.endsWith(".pdf") || selectedName.endsWith(".html")) {
                    break;
                }
            }
            JOptionPane.showMessageDialog(getMediator().getFrame(), new String[]{"ファイルの拡張子は「.pdf」または「.html」でなければいけません．",
                    "現在のファイル名: "+tgtFile}, "ファイル名のエラー", JOptionPane.ERROR_MESSAGE);
        }
        if(avoidOverwriteFile(tgtFile)){
            return null;
        }
        return tgtFile;
    }
    
	public JMenu createNewMenu(int index) {
	    JMenu newMenu = new JMenu();
	    newMenu.setText(TEMPLATE_LABELS[index]);
	    for(int i=0; i < TEMPLATE_ITEMS[index].length; i++){
	        newMenu.add(createNewMenuItem(index, i));
	    }
		return newMenu;
	}
	
	public JMenuItem createNewMenuItem(int index, int i) {
	    JMenuItem newMenuItem = new JMenuItem();
        String label = null;
        String filename = null;
        boolean readonly = false;
        boolean enabled = true;
        if(0 <= i){
            label = TEMPLATE_ITEMS[index][i];
            filename = TEMPLATE_FILES[index][i];
            readonly = TEMPLATE_READONLY[index][i];
            enabled = TEMPLATE_ENABLED[index][i];
        }else{
            label =  TEMPLATE_LABELS[index];
            filename = TEMPLATE_FILES[index][0];
            readonly = TEMPLATE_READONLY[index][0];
            enabled = TEMPLATE_ENABLED[index][0];
        }
        newMenuItem.setText(label);
        newMenuItem.setEnabled(enabled);
	    addActionListener(newMenuItem, filename, readonly, label);
		return newMenuItem;
	}

    private void addActionListener(JMenuItem newMenuItem, final String filename, final boolean readonly, final String title) {
        newMenuItem.addActionListener(new ActionListener(){
	        public void actionPerformed(ActionEvent ev){
	            try{
	                getMediator().getFrame().setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
	                getMediator().getMenuBarMediator().open(new URL(SQSSourceEditorMediator.BASEURI+filename), readonly, title);
	                updateMenu();
	            }catch(MalformedURLException ignore){
	                ignore.printStackTrace();
	            }finally{
	                getMediator().getFrame().setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));
	            }
			}
	    });
    }

	public JMenuItem createAboutMenuItem() {
	    JMenuItem aboutMenuItem;
			aboutMenuItem = new JMenuItem();
			aboutMenuItem.setText("MarkReaderについて");
		return aboutMenuItem;
	}

	public JFileChooser createSaveAsFileChoser(Source currentSource) {
        JFileChooser saveAsFileChooser = SQSFileChooser.createSaveSQSFileChooser(currentSource.getFile());
        return saveAsFileChooser;
    }

	public JFileChooser createOpenFileChooser(File defaultFolder) {
        JFileChooser openFileChooser = SQSFileChooser.createOpenSQSSourceChooser(defaultFolder);
        return openFileChooser;
    }
}
