/*

 ContentServlet.java
 
 Copyright 2004 KUBO Hiroya (hiroya@sfc.keio.ac.jp).
 
 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at
 
 http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 
 Created on 2004/10/17

 */
package net.sf.sqs_xml.httpd;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.util.List;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.ParserConfigurationException;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

import net.sf.sqs_xml.util.DOMUtil;
import net.sf.sqs_xml.util.FileUtil;
import net.sf.sqs_xml.util.StringUtil;
import net.sf.sqs_xml.util.XMLUtil;
import net.sf.sqs_xml.xmlns.SQSNamespaces;

/**
 * @author hiroya
 *
 */

public class UpdateMatrixServlet extends ViewMatrixServlet {
    public void service(HttpServletRequest request, HttpServletResponse response)throws ServletException, IOException{
        try{
            request.setCharacterEncoding("UTF-8");
            String resultDir = getResultDir(request);
            String srcfile = request.getParameter("src");
            MicroHttpd httpd = SQSHttpdFactory.getInitialHttpd();
            List matrix = readCSV(new File(resultDir), "MS932");
            update(request, matrix);
            updateHTML(new File(resultDir), request, matrix, "UTF-8");
            writeCSV(new File(resultDir), matrix, "MS932");
            response.sendRedirect(httpd.getBase()+"servlet/ViewMatrix?dir="+URLEncoder.encode(resultDir, "UTF-8")+"&src="+srcfile);
        }catch(SAXException ex){
            throw new ServletException(ex);
        }catch(ParserConfigurationException ex){
            throw new ServletException(ex);
        }
    }
    
    private void update(HttpServletRequest request, List matrix) throws IOException {
        for(int rowIndex=1; rowIndex < matrix.size(); rowIndex++){
            List column = (List)matrix.get(rowIndex);
            for(int colIndex=2; colIndex < column.size(); colIndex++){
                String value = request.getParameter(colIndex+"-"+rowIndex);
                if(value != null){
                    column.set(colIndex, value);
                }
            }
        }
    }

    void writeCSV(File resultDir, List matrix, String encoding)throws IOException{
        File csvFile = getCSVFile(resultDir);
        PrintWriter writer = FileUtil.createPrintWriter(csvFile, encoding);
        for(int rowIndex=0; rowIndex < matrix.size(); rowIndex++){
            List column = (List)matrix.get(rowIndex);
            for(int colIndex=0; colIndex < column.size(); colIndex++){
                if(colIndex != 0){
                    writer.print("\t");
                }
                String arg = (String)column.get(colIndex);
                writer.print(StringUtil.escape(arg));
            }
            writer.println();
        }
        writer.close();
    }

    File getMarkFile(File resultDir){
        return findFile(resultDir, "mark.html");        
    }

    void updateHTML(File resultDir, HttpServletRequest request, List matrix, String encoding)throws IOException, SAXException, ParserConfigurationException{
        File markFile = getMarkFile(resultDir);
        Document document = XMLUtil.createParser().parse(markFile);
        document.normalize();        
        Element tbodyElem = DOMUtil.getElement(document.getDocumentElement(), new String[][]{{SQSNamespaces.XHTML_URI, "body"}, {SQSNamespaces.XHTML_URI, "table"}, {SQSNamespaces.XHTML_URI, "tbody"}});
        NodeList trList = tbodyElem.getElementsByTagNameNS(SQSNamespaces.XHTML_URI, "tr");
        
        for(int rowIndex=1; rowIndex < matrix.size(); rowIndex++){
            List column = (List)matrix.get(rowIndex);
            NodeList tdList = ((Element)trList.item(rowIndex-1)).getElementsByTagNameNS(SQSNamespaces.XHTML_URI, "td");
            for(int colIndex=2; colIndex < column.size(); colIndex++){
                String value = request.getParameter(colIndex+"-"+rowIndex);
                if(value != null && ! "?".equals(value)){
                    Element tdElem = (Element)tdList.item(colIndex-2);
                    NodeList children = tdElem.getChildNodes();
                    for(int i = 0; i < children.getLength(); i++){
                        tdElem.removeChild(children.item(i));
                    }
                    //System.err.println(colIndex+"-"+rowIndex+":"+value);
                    Element preElem = document.createElementNS(SQSNamespaces.XHTML_URI, "pre");
                    preElem.appendChild(document.createTextNode(value));
                    tdElem.appendChild(preElem);
                }
            }
        }
        
        FileOutputStream output = new FileOutputStream(markFile);
        XMLUtil.marshal(document, output);
        output.close();
    }
}
