/*

 FilteredReaderBaseTask.java
 
 Copyright 2004 KUBO Hiroya (hiroya@sfc.keio.ac.jp).
 
 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at
 
 http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 
 Created on 2004/11/01

 */
package net.sf.sqs_xml.reader.logic;

import java.io.File;
import java.sql.Timestamp;
import java.util.List;

import net.sf.sqs_xml.reader.model.ImageFiles;
import net.sf.sqs_xml.reader.model.ImageFilesImagefile;
import net.sf.sqs_xml.reader.swing.ProgressLoggerConsoleFrame;
import net.sf.sqs_xml.translator.logic.TranslatorException;

/**
 * @author hiroya
 *
 */

public abstract class FilteredReaderBaseTask extends ReaderBaseTask{
    CheckImageFilesTaskTarget checkImageFilesTaskTarget = new CheckImageFilesTaskTarget();
    
    public FilteredReaderBaseTask(BaseTaskSource source, BaseTaskTarget target, ReaderProcessView view){
        super(source, target, view);
    }
  
    class CheckImageFilesTask extends ReaderTask{
        CheckImageFilesTask(CheckImageFilesTaskSource source, CheckImageFilesTaskTarget target, ReaderProcessView view){
            super(source, target, view);
        }
        
        CheckImageFilesTaskSource getSource() {
            return (CheckImageFilesTaskSource)source;
        }
        CheckImageFilesTaskTarget getTarget() {
            return (CheckImageFilesTaskTarget)target;
        }
        
        void run()throws ThreadSuspendingException,TranslatorException{
            getTarget().setImageFiles(new ImageFiles());
            view.setProgressState(3, ProgressLoggerConsoleFrame.PROCESSING);
            int size = getSource().fileList.size();
            for(int i = 0; i < size; i++){
                checkTaskStopRequest();
                view.setNumTargetFiles(i);
                view.setProgressState(3, i+1, size);
                checkImageFile(i);
            }
            view.setNumTargetFiles(size);
            view.setProgressState(3, ProgressLoggerConsoleFrame.SUCCEED);
        }

        private void checkImageFile(int i) {
            File imageFile = (File)getSource().fileList.get(i);
            Timestamp targetMTime = new Timestamp(imageFile.lastModified());
            ImageFilesImagefile target = new ImageFilesImagefile();
            target.setFilename(imageFile.getAbsolutePath());
            target.setMtime(targetMTime);
            getTarget().getImageFiles().addImageFilesImagefile(target);
        }

    }
    
    class CheckImageFilesTaskSource extends ReaderTaskSource{
        List fileList;
        CheckImageFilesTaskSource(List fileList){
            this.fileList = fileList;
        }
    }
    
    class CheckImageFilesTaskTarget extends ReaderTaskTarget{
        ImageFiles imageFiles; 
        ImageFiles getImageFiles(){
            return imageFiles;
        }
        void setImageFiles(ImageFiles imageFiles){
            this.imageFiles = imageFiles;
        }
    }
    
    public void checkImageFiles() throws ThreadSuspendingException, TranslatorException {
        new CheckImageFilesTask(new CheckImageFilesTaskSource(findImageFilesTaskTarget.fileList), checkImageFilesTaskTarget, view).run();
    }
}
