/*

 ReaderLogMessage.java
 
 Copyright 2004 KUBO Hiroya (hiroya@sfc.keio.ac.jp).
 
 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at
 
 http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 
 Created on Jul 29, 2004

 */
package net.sf.sqs_xml.reader.logic;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.io.File;
import java.text.DecimalFormat;
import org.apache.avalon.framework.logger.Logger;
/**
 * @author hiroya
 *
 */
public class ReaderLogMessage {
    static DecimalFormat format = new DecimalFormat("0.##");
    
    static void logImageDir(Logger logger, File imagedir){
        logger.info("Retrieving image files from: "+imagedir.getAbsolutePath());
    }
    
    static void logPDFFile(Logger logger, File pdffile){
        logger.info("Analysing PDF file: "+pdffile.getAbsolutePath());
    }
    
    static void logScanFrame(Logger logger, int id, String filename){
        logger.info("file: "+id+" \""+filename+"\"");
    }

    static void logPageError(Logger logger, Exception ex, String filename){
        logger.error("INVALID PAGE: "+ex.getMessage()+": "+filename);
    	logger.error("##########################################");
    }
    
    static void logGuide(Logger logger, Point2D[] scanFrameCorner){
        logger.debug("upper-guide-blocks: ("+scanFrameCorner[0].getX()+","+scanFrameCorner[0].getY()+")-("+
                scanFrameCorner[1].getX()+","+scanFrameCorner[1].getY()+")");
        logger.debug("lower-guide-blocks: ("+scanFrameCorner[2].getX()+","+scanFrameCorner[2].getY()+")-("+
                scanFrameCorner[3].getX()+","+scanFrameCorner[3].getY()+")");
    }

    static void logGuideError(Logger logger, String filename){
        logger.error("INVALID GUIDE_BLOCK RECOGNITION: "+filename);
        logger.error("##########################################");
    }
    
    static void logFile(Logger logger, int pageNumber, int sampleID, String filename){
        logger.debug("");
        if(pageNumber == 1){
            logger.debug("");
            logger.debug("//");            
            logger.info("// sampleID "+sampleID);
        }
        logger.info("= page "+pageNumber+" \""+filename+"\"");
    }
    
    static void logMark(Logger logger, boolean marked, double density){
        if(marked){
            logger.debug("*  Filled Mark: "+format.format(density));
        }else{
            logger.debug("- not filled mark: "+format.format(density));
        }
    }

    static void logRectInfo(Logger logger, String id, Rectangle rect, ReaderTranslatedSource source) {
        Point2D o1 = source.getPoint(rect.x, rect.y, 1.0, new Point2D.Double());
        Point2D o2 = source.getPoint(rect.x+rect.width, rect.y+rect.height, 1.0, new Point2D.Double());
        logger.debug(id+" : ("+format.format(o1.getX())+","+format.format(o1.getY())+
                ")-("+format.format(o2.getX())+","+format.format(o2.getY())+")");
    }
    
    static void logCropImage(Logger logger, String imageFile){
        logger.debug("+ crop image: "+imageFile);
    }
    
    static void logInvalidMark(Logger logger, int rowID, String filename, String qid, int size){
        logger.warn("INVALID MARK in sampleID: "+rowID+" \""+filename+"\""+
                " qid:"+qid+" "+size);
        logger.warn("##########################################");
    }


    /*
        static void logResult(Logger logger, String status, int error, 
                int numFiles, int numValidFiles, int numPages, int numSamples, int numColumns) {
            logger.info("numFiles:" + numFiles);
            logger.info("numValidFiles:" + numValidFiles);
            logger.info("numPagesParSample:" + numPages);
            logger.info("numSamples:" + numSamples);
            logger.info("numColumns:" + numColumns);
    	
        	if(logger instanceof Component){
        	    JOptionPane.showMessageDialog((Component)logger, new Object[]{
        	            "読み取り処理を終了しました: "+ status+"    ",
        	            " ",

        	            " ● 総ファイル数:            "+numFiles,
        	            " ",    	            
        	            " ● 処理されたファイル数:    "+numValidFiles,
        	            " ",
        	            " ● 一人分のページ数:        "+numPages,
        	            " ● 出力CSVファイル内",
        	            "    ・回答者数(サンプル数):  "+numSamples,
        	            "    ・設問カラム数:          "+numColumns,
        	            " ",
        	            " "},
        	            
        	            "処理結果", (0 == error)?JOptionPane.INFORMATION_MESSAGE:JOptionPane.ERROR_MESSAGE);
            }
        }
    */    
}
