/*
 * 
   FileChooserPanel.java

   Copyright 2004 KUBO Hiroya (hiroya@sfc.keio.ac.jp).

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
 */
package net.sf.sqs_xml.swing;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import java.awt.dnd.DnDConstants;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;

import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JFrame;

import net.sf.sqs_xml.editor.base.swing.SuffixBasedFileChooser;

import java.io.File;


public abstract class FileChooserPanel extends JPanel{
	protected FileDropAcceptableTextField fileDropAcceptableTextField;
	protected JButton fileOpenButton;
	SuffixBasedFileChooser openFileChooser;
	
    public FileChooserPanel(JFrame frame, String borderTitle, String inputFileLabel, SuffixBasedFileChooser openFileChooser){
        this.fileDropAcceptableTextField = createFileDropAcceptableTextField();
        this.fileOpenButton = createFileOpenButton(frame);		
		setBorder(BorderFactory.createTitledBorder(borderTitle));		
		setLayout(new BoxLayout(this, BoxLayout.X_AXIS));
		add(new JLabel(inputFileLabel));
		add(fileDropAcceptableTextField);
		add(new JLabel(" / "));
		add(fileOpenButton);
		this.openFileChooser = openFileChooser;
		File defaultFile = openFileChooser.getSelectedFile();
		if(defaultFile != null){
		    fileDropAcceptableTextField.setText(defaultFile.getAbsolutePath());
		}
	}
	
	/**
     * @param frame
     */
    private JButton createFileOpenButton(final JFrame frame) {
        //fileOpenButton = new JButton(isFile? "Open File" : "Open Directory");
        JButton fileOpenButton = new JButton("選択…");
		fileOpenButton.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ev){
				int result = openFileChooser.showOpenDialog(frame);
				if(result == JFileChooser.APPROVE_OPTION){
					File file = openFileChooser.getSelectedFile();
					setSelectedFile(file);
					fireFileSelection(file);
				}
			}
		});
		return fileOpenButton;
    }

    /**
     * 
     */
    private FileDropAcceptableTextField createFileDropAcceptableTextField() {
        FileDropAcceptableTextField fileDropAcceptableTextField = new FileDropAcceptableTextField(){
			public void drop(File file){
				fireFileSelection(file);
			}
			/*
			public void satateChanged(){
				fireFileSelection(new File(getText()));
			}*/
		};
		fileDropAcceptableTextField.setColumns(20);
		new DropTarget(fileDropAcceptableTextField, 
				DnDConstants.ACTION_COPY_OR_MOVE, 
				fileDropAcceptableTextField, true);
		return fileDropAcceptableTextField;
    }
	
	public JButton getFileOpenButton(){
		return fileOpenButton;
	}
	
	public FileDropAcceptableTextField getFileDropAcceptableTextField(){
		return fileDropAcceptableTextField;
	}
		
	public String getAbsolutePath(){
		return fileDropAcceptableTextField.getText();
	}
	
	public void setSelectedFile(File file){
	    openFileChooser.setSelectedFile(file);
		fileDropAcceptableTextField.setText(file.getAbsolutePath());
	}
	
	public void setEnabled(boolean isEnabled){
		fileDropAcceptableTextField.setEnabled(isEnabled);
		fileOpenButton.setEnabled(isEnabled);
	}
	
	public abstract void fireFileSelection(File file);

}
