/*

 SQStoPreviewTranslator.java
 
 Copyright 2004 KUBO Hiroya (hiroya@sfc.keio.ac.jp).
 
 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at
 
 http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 
 Created on 2004/08/14

 */
package net.sf.sqs_xml.translator.logic;

import net.sf.sqs_xml.httpd.SourceEditorHttpd;

/**
 * @author hiroya
 *
 */
public class SQStoPreviewTranslator extends SQStoHTMLTranslator {
    public static final String SQS2PREVIEW = prop.getString("sqs2preview_xsl_file");
    
	public static void main(String args[]) throws Exception {
		main(args, "net.sf.sqs_xml.translator.logic.SQStoPREVIEWTranslator <in.sqs> <out.pdf>", 
		        SQS2PREVIEW.split(" "), new SQStoPreviewTranslator(),
				SourceEditorHttpd.getSingleton().getBase());
	}
	
    public String[] getXsltFilenames(){
        return SQS2PREVIEW.split(" ");
    }

	public SQStoPreviewTranslator()throws TranslatorException{
		super();
	}
}
