<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2004 SQS Development Team / Community Management Research Project.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns="http://www.w3.org/1999/XSL/Format" xmlns:xforms="http://www.w3.org/2002/xforms" xmlns:svg="http://www.w3.org/2000/svg" xmlns:xhtml2="http://www.w3.org/2002/06/xhtml2" xmlns:sqs="http://sqs.cmr.sfc.keio.ac.jp/2004/sqs" version="1.0">
	<xsl:template match="xforms:textarea">
		<fo:block id="{$internal-destination-prefix-xform}{@xforms:ref}"/>
		<fo:instream-foreign-object>
			<svg:svg width="{@sqs:width}" height="{@sqs:height}" id="{$internal-destination-prefix-svg}{@xforms:ref}">
				<xsl:if test="ancestor::xhtml2:table[@xhtml2:class != 'matrix-forms']">
					<svg:g style="stroke:black; stroke-width: 3pt; fill:white;" sqs:callback="jp.sourceforge.sqs_xml.translator.SVGAnnotation">
						<svg:rect x="0" y="0" width="{@sqs:width}" height="{@sqs:height}"/>
					</svg:g>
				</xsl:if>
			</svg:svg>
		</fo:instream-foreign-object>
	</xsl:template>
	<xsl:template match="xforms:select|xforms:select1">
</xsl:template>
	<xsl:template match="xforms:select[@sqs:pxform-type='select1' or @sqs:pxform-type='select']">
		<fo:block id="{$internal-destination-prefix-xform}{@xforms:ref}"/>
		<fo:instream-foreign-object>
			<xsl:call-template name="mark">
				<xsl:with-param name="ref">
					<xsl:value-of select="@xforms:ref"/>
				</xsl:with-param>
			</xsl:call-template>
		</fo:instream-foreign-object>
	</xsl:template>
</xsl:stylesheet>
