using System;
using System.Collections.Generic;
using System.Text;
using NUnit.Framework;
using StarEngine;
using StarEngine.Ruby;

namespace StarEngine.Tests.Ruby
{
    [TestFixture]
    public class Math4096Test
    {
        [Test]
        public void TestSin()
        {
            for (int i = 0; i < 32; i++)
                Assert.Less(Math.Abs(Math.Sin(i * Math.PI / 8.0) - Math4096.Sin(256 * i)), 1.0 / 65535.0, "i: " + i);
        }

        [Test]
        public void TestCos()
        {
            for (int i = 0; i < 32; i++)
                Assert.Less(Math.Abs(Math.Cos(i * Math.PI / 8.0) - Math4096.Cos(256 * i)), 1.0 / 65535.0, "i: " + i);
        }
    }
}
