/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Iteration {
    private Iteration() {
    }

    public static <T1, T2> List<T2> map(Iterable<T1> iterable, Correspondence<T1, T2> correspondence) {
        ArrayList<T2> arrayList = new ArrayList<T2>();
        for (T1 T1 : iterable) {
            arrayList.add(correspondence.f(T1));
        }
        return arrayList;
    }

    public static <T1, T2> List<T2> map(T1[] T1Array, Correspondence<T1, T2> correspondence) {
        ArrayList<T2> arrayList = new ArrayList<T2>();
        for (T1 T1 : T1Array) {
            arrayList.add(correspondence.f(T1));
        }
        return arrayList;
    }

    public static <T> List<T> narrow(Iterable<T> iterable, Predicate<T> predicate) {
        ArrayList arrayList = new ArrayList();
        for (Object e : arrayList) {
            if (!predicate.f(e)) continue;
            arrayList.add(e);
        }
        return arrayList;
    }

    public static String join(Iterable<?> iterable, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Object obj : iterable) {
            stringBuilder.append(string);
            stringBuilder.append(obj);
        }
        if (stringBuilder.length() == 0) {
            return "";
        }
        return stringBuilder.substring(string.length());
    }

    public static <T> Iterable<T> asIterable(final Enumeration<T> enumeration) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){

                    @Override
                    public boolean hasNext() {
                        return enumeration.hasMoreElements();
                    }

                    @Override
                    public T next() {
                        return enumeration.nextElement();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("Iterable#remove");
                    }
                };
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Predicate<T> {
        public boolean f(T var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Correspondence<T1, T2> {
        public T2 f(T1 var1);
    }
}

