/*
 *  Copyright 2010 argius
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */
package net.argius.stew.io;

import java.io.*;

/**
 * Exporter̃t@NgB
 */
final class ExporterFactory {

    private ExporterFactory() {
        // empty
    }

    /**
     * Exporter̐B
     * @param path pX
     * @return Exporter
     * @throws IOException
     */
    static Exporter createExporter(Path path) throws IOException {
        final String ext = path.getExtension();
        if (ext.equalsIgnoreCase("xml")) {
            return new XmlExporter(openFile(path));
        } else if (ext.equalsIgnoreCase("htm") || ext.equalsIgnoreCase("html")) {
            return new HtmlExporter(openFile(path), "");
        } else if (ext.equalsIgnoreCase("csv")) {
            return new SimpleExporter(openFile(path), ",");
        } else {
            return new SimpleExporter(openFile(path), "\t");
        }
    }

    /**
     * t@CJB
     * @param file t@C
     * @return o̓Xg[
     * @throws IOException
     */
    private static OutputStream openFile(File file) throws IOException {
        return new FileOutputStream(file);
    }

}
