/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import net.argius.stew.Alias;
import net.argius.stew.Bootstrap;
import net.argius.stew.CommandException;
import net.argius.stew.Connector;
import net.argius.stew.ConnectorConfiguration;
import net.argius.stew.ConnectorMap;
import net.argius.stew.Logger;
import net.argius.stew.ResourceManager;
import net.argius.stew.ui.OutputProcessor;

public final class Environment {
    static final String CONNECTOR_PROPERTIES_NAME = "connector.properties";
    static final String ALIAS_PROPERTIES_NAME = "alias.properties";
    private static final Logger log = Logger.getLogger(Environment.class);
    static ResourceManager res = ResourceManager.getInstance(Environment.class);
    private OutputProcessor outputProcessor;
    private ConnectorMap connectorMap;
    private Connector connector;
    private Connection conn;
    private int timeoutSeconds;
    private File systemDirectory;
    private File currentDirectory;
    private long connectorTimestamp;
    private Alias alias;

    public Environment() {
        this.initializeQueryTimeout();
        this.connectorMap = new ConnectorMap();
        this.loadConnectorMap();
        this.systemDirectory = Bootstrap.getDirectory();
        this.currentDirectory = Environment.getInitialCurrentDirectory();
        File file = new File(this.systemDirectory, ALIAS_PROPERTIES_NAME);
        this.alias = new Alias(file);
        if (file.exists()) {
            try {
                this.alias.load();
            }
            catch (IOException iOException) {
                log.warn(iOException);
            }
        }
    }

    public Environment(Environment environment) {
        this.connectorMap = new ConnectorMap(environment.connectorMap);
        this.timeoutSeconds = environment.timeoutSeconds;
        this.systemDirectory = environment.systemDirectory;
        this.currentDirectory = environment.currentDirectory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        try {
            this.releaseConnection();
            log.debug("released connection");
        }
        catch (SQLException sQLException) {
            log.error(sQLException, "release error");
        }
        finally {
            this.outputProcessor = null;
            this.connectorMap = null;
            this.connector = null;
            this.conn = null;
            this.systemDirectory = null;
            this.currentDirectory = null;
        }
        log.debug("released internal state of Environment");
    }

    void establishConnection(Connector connector) throws SQLException {
        boolean bl;
        Connection connection = connector.getConnection();
        try {
            if (connector.isReadOnly()) {
                connection.setReadOnly(true);
            }
        }
        catch (RuntimeException runtimeException) {
            log.warn(runtimeException);
        }
        try {
            connection.setAutoCommit(false);
            bl = connection.getAutoCommit();
        }
        catch (RuntimeException runtimeException) {
            log.warn(runtimeException);
            bl = false;
        }
        if (bl) {
            this.outputMessage("w.auto-commit-not-available", new Object[0]);
        }
        this.setCurrentConnection(connection);
        this.setCurrentConnector(connector);
        this.outputMessage("i.connected", new Object[0]);
        log.debug("connected %s (conn=%08x, env=%08x)", connector.getId(), connection.hashCode(), this.hashCode());
        if (Bootstrap.getPropertyAsBoolean("net.argius.stew.print-connected-time")) {
            this.outputMessage("i.now", System.currentTimeMillis());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseConnection() throws SQLException {
        if (this.conn == null) {
            log.debug("not connected");
            return;
        }
        try {
            if (this.connector != null && this.connector.usesAutoRollback()) {
                try {
                    this.conn.rollback();
                    this.outputMessage("i.rollbacked", new Object[0]);
                    log.debug("rollbacked %s (%s)", (Object)this.connector.getId(), (Object)this.conn);
                }
                catch (SQLException sQLException) {
                    log.warn(sQLException);
                }
            }
            try {
                this.conn.close();
                log.debug("disconnected %s (conn=%08x, env=%08x)", this.connector.getId(), this.conn.hashCode(), this.hashCode());
                if (Bootstrap.getPropertyAsBoolean("net.argius.stew.print-disconnected-time")) {
                    this.outputMessage("i.now", System.currentTimeMillis());
                }
            }
            catch (SQLException sQLException) {
                log.warn(sQLException);
                throw sQLException;
            }
        }
        finally {
            this.conn = null;
            this.connector = null;
        }
    }

    private void outputMessage(String string, Object ... objectArray) throws CommandException {
        if (this.outputProcessor != null) {
            this.outputProcessor.output(res.get(string, objectArray));
        }
    }

    private static File getInitialCurrentDirectory() {
        File file;
        if (Bootstrap.hasProperty("net.argius.stew.directory") && (file = new File(Bootstrap.getProperty("net.argius.stew.directory", ""))).isDirectory()) {
            return file;
        }
        return new File(".");
    }

    private void initializeQueryTimeout() {
        this.timeoutSeconds = Bootstrap.getPropertyAsInt("net.argius.stew.query.timeout", -1);
        if (log.isDebugEnabled()) {
            log.debug("timeout: " + this.timeoutSeconds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadConnectorMap() {
        ConnectorMap connectorMap;
        Object object;
        File file = new File(Bootstrap.getDirectory(), CONNECTOR_PROPERTIES_NAME);
        try {
            object = new FileInputStream(file);
            try {
                connectorMap = ConnectorConfiguration.load((InputStream)object);
            }
            finally {
                ((InputStream)object).close();
            }
        }
        catch (IOException iOException) {
            connectorMap = new ConnectorMap();
        }
        object = this.connectorMap;
        synchronized (object) {
            if (this.connectorMap.size() > 0) {
                this.connectorMap.clear();
            }
            this.connectorMap.putAll(connectorMap);
            this.connectorTimestamp = file.lastModified();
        }
    }

    public boolean updateConnectorMap() {
        File file = new File(Bootstrap.getDirectory(), CONNECTOR_PROPERTIES_NAME);
        if (file.lastModified() > this.connectorTimestamp) {
            this.loadConnectorMap();
            return true;
        }
        return false;
    }

    public OutputProcessor getOutputProcessor() {
        return this.outputProcessor;
    }

    public void setOutputProcessor(OutputProcessor outputProcessor) {
        this.outputProcessor = outputProcessor;
    }

    public ConnectorMap getConnectorMap() {
        return this.connectorMap;
    }

    public Connector getCurrentConnector() {
        return this.connector;
    }

    void setCurrentConnector(Connector connector) {
        this.connector = connector;
    }

    public Connection getCurrentConnection() {
        return this.conn;
    }

    void setCurrentConnection(Connection connection) {
        this.conn = connection;
    }

    public int getTimeoutSeconds() {
        return this.timeoutSeconds;
    }

    public File getCurrentDirectory() {
        return this.currentDirectory;
    }

    public void setCurrentDirectory(File file) {
        this.currentDirectory = file;
    }

    public File getSystemDirectory() {
        return this.systemDirectory;
    }

    public Alias getAlias() {
        return this.alias;
    }
}

