/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import net.argius.stew.io.Exporter;

public final class HtmlExporter
extends Exporter {
    private PrintWriter out;

    public HtmlExporter(OutputStream outputStream, String string) {
        super(outputStream);
        this.out = new PrintWriter(outputStream);
        this.out.println("<html>");
        this.out.println("<head>");
        this.out.printf("<title>%s</title>%n", string);
        this.out.println("</head>");
        this.out.println("<body>");
        this.out.printf("<h1>%s</h1>%n", string);
        this.out.println("<table>");
        this.out.flush();
    }

    @Override
    protected void writeHeader(Object[] objectArray) throws IOException {
        this.ensureOpen();
        this.out.println("<tr>");
        for (Object object : objectArray) {
            this.out.printf("<th>%s</th>%n", object);
        }
        this.out.println("</tr>");
        this.out.flush();
    }

    @Override
    public void addRow(Object[] objectArray) throws IOException {
        this.ensureOpen();
        this.out.println("<tr>");
        for (Object object : objectArray) {
            this.out.printf("<td>%s</td>%n", object);
        }
        this.out.println("</tr>");
        this.out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        this.ensureOpen();
        try {
            if (this.out != null) {
                this.out.println("</table>");
                this.out.println("</body>");
                this.out.println("</html>");
                this.out.flush();
                this.out.close();
            }
        }
        finally {
            this.out = null;
            super.close();
        }
    }
}

