/*
 * Decompiled with CFR 0.152.
 */
package net.murakamin.csv;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import net.murakamin.csv.CSVDataHandler;
import net.murakamin.csv.CSVReader;
import net.murakamin.csv.exception.CSVParseException;

public class CSVParser {
    private final CSVDataHandler handler;

    public CSVParser(CSVDataHandler importTarget) {
        this.handler = importTarget;
    }

    public void doParse(File source) throws CSVParseException {
        int lineNo = 0;
        String[] currentDatas = null;
        try {
            CSVReader reader = new CSVReader();
            reader.setEncoding(this.handler.getFileCharset());
            reader.setFieldSeparator(this.handler.getSeparator());
            reader.setQuoteChar(this.handler.getQuot());
            reader.setSupportHeader(this.handler.isHeader());
            reader.open(source);
            lineNo = 1;
            while (reader.nextLine()) {
                currentDatas = reader.currentLine();
                this.handler.addCSVData(currentDatas);
                ++lineNo;
            }
        }
        catch (Exception e) {
            throw new CSVParseException(lineNo, (Throwable)e);
        }
    }

    public void doParse(ResultSet source) throws CSVParseException {
        int lineNo = 0;
        String[] currentDatas = null;
        try {
            lineNo = 1;
            while (source.next()) {
                currentDatas = this.parseStrings(source);
                this.handler.addCSVData(currentDatas);
                ++lineNo;
            }
        }
        catch (Exception e) {
            throw new CSVParseException(lineNo, (Throwable)e);
        }
    }

    private String[] parseStrings(ResultSet rs) throws UnsupportedEncodingException, SQLException {
        ResultSetMetaData metaData = rs.getMetaData();
        int columnCount = metaData.getColumnCount();
        String[] csvData = null;
        csvData = new String[columnCount];
        int i = 1;
        while (i < columnCount + 1) {
            Object o = rs.getObject(i);
            csvData[i - 1] = null;
            if (o != null) {
                csvData[i - 1] = o.toString();
            }
            ++i;
        }
        return csvData;
    }
}

