/*
 * Decompiled with CFR 0.152.
 */
package net.murakamin.csv;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.murakamin.csv.CSVHeader;
import net.murakamin.csv.CSVHeaderMetaData;
import net.murakamin.csv.exception.CSVParseException;
import org.apache.commons.lang.SystemUtils;

public class CSVReader {
    private static char DEFAULT_FIELD_SEPARATOR = (char)44;
    private static String DEFAULT_FILE_ENCODING = SystemUtils.FILE_ENCODING;
    public static char QUOTE_NONE = (char)32;
    private Pattern csvPattern = null;
    private String currentBuffer = null;
    private boolean currentIsHeaderLine = false;
    private int currentLineNo = 1;
    private String encoding = DEFAULT_FILE_ENCODING;
    private char fieldSeparator = DEFAULT_FIELD_SEPARATOR;
    private final CSVHeader header = new CSVHeader();
    private char quoteChar = QUOTE_NONE;
    private BufferedReader reader = null;
    private boolean supportHeader = false;
    private boolean throwParseError = true;

    private Pattern createPattern() {
        String patternString = "(\"(?:[^\"]|\"\")*\"|[^,]+|(^[^,]{0})|(,.{0},))";
        if (!this.currentIsHeaderLine && this.quoteChar != QUOTE_NONE) {
            patternString = "(\"{1}?.*?\"{1}?|[^,]*)";
            patternString = patternString.replace('\"', this.quoteChar);
        }
        patternString = patternString.replace(',', this.fieldSeparator);
        return Pattern.compile(patternString);
    }

    public String[] currentLine() throws CSVParseException {
        String[] result;
        block2: {
            String buffer = this.currentBuffer;
            this.currentBuffer = null;
            result = null;
            try {
                result = this.parseLine(buffer);
            }
            catch (Exception e) {
                if (!this.throwParseError) break block2;
                throw new CSVParseException(this.currentLineNo, (Throwable)e);
            }
        }
        return result;
    }

    public CSVHeader getHeader() {
        return this.header;
    }

    public boolean isThrowParseError() {
        return this.throwParseError;
    }

    public boolean nextLine() throws IOException {
        String line = this.currentBuffer;
        if (!this.currentIsHeaderLine) {
            line = this.reader.readLine();
        } else {
            this.currentIsHeaderLine = false;
        }
        if (line == null) {
            this.reader.close();
            return false;
        }
        this.currentBuffer = line;
        return true;
    }

    public void open(File csv) throws FileNotFoundException, IOException {
        this.reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(csv), this.encoding));
        this.parseHeader();
    }

    public void open(File csv, String targetFileEncoding) throws FileNotFoundException, IOException {
        this.encoding = targetFileEncoding;
        this.reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(csv), this.encoding));
        this.parseHeader();
    }

    public void open(String csv) throws FileNotFoundException, IOException {
        this.open(new File(csv));
    }

    public void open(StringReader stringReader) throws IOException {
        this.reader = new BufferedReader(stringReader);
        this.parseHeader();
    }

    private void parseHeader() throws IOException {
        this.currentIsHeaderLine = true;
        this.currentBuffer = this.reader.readLine();
        String[] headers = this.parseLine(this.currentBuffer);
        if (this.supportHeader) {
            int c = 0;
            while (c < headers.length) {
                this.header.add(new CSVHeaderMetaData(headers[c], String.class));
                ++c;
            }
            this.currentIsHeaderLine = false;
        } else {
            StringBuffer headerName = new StringBuffer();
            int c = 0;
            while (c < headers.length) {
                headerName.append("FIELD");
                headerName.append(c + 1);
                this.header.add(new CSVHeaderMetaData(headerName.toString(), String.class));
                headerName.delete(0, headerName.length());
                ++c;
            }
        }
    }

    private String[] parseLine(String source) throws UnsupportedEncodingException {
        if (this.csvPattern == null) {
            this.csvPattern = this.createPattern();
        }
        Matcher matcher = this.csvPattern.matcher(source);
        Vector<String> resultList = new Vector<String>();
        while (matcher.find()) {
            String target = matcher.group();
            if (target.length() > 0) {
                if (target.charAt(0) == '\"' && target.charAt(target.length() - 1) == '\"') {
                    target = target.substring(target.indexOf(34) + 1, target.lastIndexOf(34));
                } else if (target.charAt(0) == ',' && target.charAt(target.length() - 1) == ',') {
                    target = target.substring(target.indexOf(44) + 1, target.lastIndexOf(44));
                }
            }
            target = target.replaceAll("\"\"", "\"");
            resultList.add(target);
        }
        if (!this.currentIsHeaderLine && this.header.size() != resultList.size()) {
            throw new CSVParseException(this.currentLineNo, "The number of fields is illegal. The number of fields of headers is " + this.header.size() + ".However, the number of fields of these lines is " + resultList.size() + ".");
        }
        ++this.currentLineNo;
        return resultList.toArray(new String[resultList.size()]);
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setFieldSeparator(char fieldSeparator) {
        this.fieldSeparator = fieldSeparator;
    }

    public void setQuoteChar(char quoteChar) {
        this.quoteChar = quoteChar;
    }

    public void setSupportHeader(boolean supportHeader) {
        this.supportHeader = supportHeader;
    }

    public void setThrowParseError(boolean throwParseError) {
        this.throwParseError = throwParseError;
    }
}

