/*
 * Decompiled with CFR 0.152.
 */
package net.trialpc.sticktools;

public class Smooth {
    public static final Smooth NONE = new Smooth(){

        @Override
        public boolean checkParameter(float param) {
            return true;
        }

        @Override
        public float getParameter(float param, long num, long kind) {
            return 1.0f;
        }
    };
    public static final Smooth LINEAR = new Smooth(){

        @Override
        public boolean checkParameter(float param) {
            return !Float.isNaN(param) && param >= 0.0f && param <= 1.0f;
        }

        @Override
        public float getParameter(float param, long num, long kind) {
            if (param < 0.0f) {
                throw new IllegalArgumentException("param < 0:" + param);
            }
            if (param > 1.0f) {
                throw new IllegalArgumentException("param > 1:" + param);
            }
            return param;
        }
    };
    public static final Smooth DIRICHLET = new Smooth(){

        @Override
        public boolean checkParameter(float param) {
            return !Float.isNaN(param) && param >= 0.0f;
        }

        @Override
        public float getParameter(float param, long num, long kind) {
            if (num < 0L) {
                throw new IllegalArgumentException("num < 0:" + num);
            }
            if (param < 0.0f) {
                throw new IllegalArgumentException("param < 0:" + param);
            }
            if ((float)num + param == 0.0f) {
                return 1.0f;
            }
            if (Float.isInfinite((float)num + param)) {
                return 0.0f;
            }
            return (float)num / ((float)num + param);
        }
    };
    public static final Smooth WITTEN_BELL = new Smooth(){

        @Override
        public boolean checkParameter(float param) {
            return true;
        }

        @Override
        public float getParameter(float param, long num, long kind) {
            if (num < 0L) {
                throw new IllegalArgumentException("num < 0:" + num);
            }
            if (kind < 0L) {
                throw new IllegalArgumentException("kind < 0:" + kind);
            }
            if (num + kind == 0L) {
                return 1.0f;
            }
            if (Float.isInfinite(num + kind)) {
                return 0.0f;
            }
            return num / (num + kind);
        }
    };

    public float getParameter(float param, long num, long kind) {
        throw new UnsupportedOperationException();
    }

    public boolean checkParameter(float param) {
        return true;
    }
}

