/*
 * Decompiled with CFR 0.152.
 */
package net.trialpc.sticktools.model;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.trialpc.sticktools.Query;
import net.trialpc.sticktools.model.AbstractLangModel;
import net.trialpc.sticktools.model.DocCollection;
import net.trialpc.sticktools.model.DocumentModel;
import net.trialpc.sticktools.model.LangModel;
import net.trialpc.sticktools.model.StateChangeListener;
import net.trialpc.sticktools.stemmer.AbstractStemmer;
import net.trialpc.sticktools.stemmer.Stemmer;

public final class LangModels {
    public static final LangModel EMPTY_MODEL = new EmptyLangModel();
    public static final DocCollection<DocumentModel> EMPTY_COLLECTION = new DocCollection<DocumentModel>(){
        private static final long serialVersionUID = -4011728699067516243L;

        @Override
        public boolean addDocument(DocumentModel d) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addDocumentAll(Collection<DocumentModel> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addListener(StateChangeListener listener) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isModifiable() {
            return false;
        }

        @Override
        protected boolean addChildModel(DocumentModel model) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void addChildModelAll(Collection<DocumentModel> c) {
            throw new UnsupportedOperationException();
        }
    };
    public static final Stemmer NOTHING_STEMMER = new AbstractStemmer(){

        @Override
        public String interpret(String term) {
            return term;
        }
    };

    private LangModels() {
    }

    public static Collection<String> asCollectionOfString(Collection<Query> q) {
        return new AbstractCollection<String>(){
            private Collection<Query> c;

            @Override
            public Iterator<String> iterator() {
                return new StringIterator(this.c);
            }

            @Override
            public int size() {
                return this.c.size();
            }

            public Collection<String> setCollection(Collection<Query> q) {
                if (q == null) {
                    throw new NullPointerException();
                }
                this.c = q;
                return this;
            }
        }.setCollection(q);
    }

    public static <T extends DocumentModel> DocCollection<T> emptyCollection() {
        return EMPTY_COLLECTION;
    }

    public static LangModel unmodifiableModel(LangModel m) {
        return new UnmodifiableModel(m);
    }

    private static class EmptyLangModel
    extends AbstractLangModel
    implements Serializable {
        private static final long serialVersionUID = 9058964441361817661L;

        private EmptyLangModel() {
        }

        @Override
        public Set<String> getVocabulary() {
            return new HashSet<String>();
        }

        @Override
        public int numOfTerms() {
            return 0;
        }

        @Override
        public int termCount(String term) {
            return 0;
        }

        @Override
        public boolean isModifiable() {
            return false;
        }
    }

    private static class StringIterator
    implements Iterator<String> {
        private Iterator<Query> iterator;

        public StringIterator(Collection<Query> c) {
            this.iterator = c.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public String next() {
            return this.iterator.next().getQuery();
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }

    private static class UnmodifiableModel
    extends AbstractLangModel
    implements Serializable {
        private static final long serialVersionUID = -5085369363789279135L;
        private Map<String, Integer> terms = new HashMap<String, Integer>();

        public UnmodifiableModel(LangModel m) {
            for (String v : m.getVocabulary()) {
                this.addTerm(v, m.termCount(v));
            }
        }

        private void addTerm(String t, int count) {
            this.terms.put(t, count);
        }

        @Override
        public Set<String> getVocabulary() {
            return new HashSet<String>(this.terms.keySet());
        }

        @Override
        public boolean isModifiable() {
            return false;
        }

        @Override
        public int numOfTerms() {
            int num = 0;
            for (Integer i : this.terms.values()) {
                num += i.intValue();
            }
            return num;
        }

        @Override
        public int termCount(String term) {
            Integer i = this.terms.get(term);
            return i == null ? 0 : i;
        }
    }
}

