/*
 * Decompiled with CFR 0.152.
 */
package net.trialpc.sticktools.model;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.trialpc.sticktools.model.SentenceModel;
import net.trialpc.sticktools.model.SentenceWrappedDocument;
import net.trialpc.sticktools.model.WrapModel;

public class LocalContextDocument<T extends SentenceModel>
extends SentenceWrappedDocument<T> {
    private static final long serialVersionUID = -2478890559712086652L;
    private int before = 0;
    private int after = 0;
    private List<T> sent = null;

    public LocalContextDocument(String id) {
        super(id);
    }

    public void setDefinitionOfLocalContext(int before, int after) {
        if (before < 0) {
            throw new IllegalArgumentException("before < 0:" + before);
        }
        if (after < 0) {
            throw new IllegalArgumentException("after < 0:" + after);
        }
        this.before = before;
        this.after = after;
    }

    public WrapModel<T> getLocalContextModel(String sid) {
        Object sub = this.getSentence(sid);
        if (sub == null) {
            return new LocalContextModel();
        }
        if (this.sent == null) {
            this.sent = new ArrayList(this.getChildrenModels());
        }
        int index = this.sent.indexOf(sub);
        int begin = index - this.before;
        int end = index + this.after;
        if (begin < 0) {
            begin = 0;
        }
        if (end >= this.sent.size()) {
            end = this.sent.size() - 1;
        }
        try {
            LocalContextModel<SentenceModel> model = new LocalContextModel<SentenceModel>();
            int i = begin;
            while (i <= end) {
                model.addSentence((SentenceModel)this.sent.get(i));
                ++i;
            }
            return model;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(e.getMessage()) + ", begin: " + begin + ", end:" + end);
        }
    }

    private static class LocalContextModel<T extends SentenceModel>
    extends WrapModel<T>
    implements Serializable {
        private static final long serialVersionUID = -426316550379762211L;
        private Set<T> sentences = new LinkedHashSet<T>();

        public boolean addSentence(T sentence) {
            return this.sentences.add(sentence);
        }

        @Override
        protected Set<T> getChildrenModels() {
            return this.sentences;
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.defaultWriteObject();
            out.writeObject(this.listeners);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            this.listeners = LocalContextModel.castCollection(in.readObject());
        }
    }
}

