/*
 * Decompiled with CFR 0.152.
 */
package net.trialpc.sticktools.model;

import java.util.HashSet;
import java.util.Set;
import net.trialpc.sticktools.Smooth;
import net.trialpc.sticktools.model.AbstractLangModel;
import net.trialpc.sticktools.model.LangModel;

public class SmoothedModel
extends AbstractLangModel {
    private LangModel base;
    private LangModel bg;
    private Smooth method;
    private float parameter;

    public SmoothedModel(LangModel base, LangModel bg, Smooth s) {
        this(base, bg, s, 0.0f);
    }

    public SmoothedModel(LangModel base, LangModel bg, Smooth s, float param) {
        this.base = base;
        this.bg = bg;
        this.method = s;
        this.parameter = param;
    }

    public LangModel getBaseModel() {
        return this.base;
    }

    public LangModel getBackgroundModel() {
        return this.bg;
    }

    @Override
    public boolean isModifiable() {
        return this.base.isModifiable() || this.bg.isModifiable();
    }

    @Override
    public int numOfTerms() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int termCount(String term) {
        throw new UnsupportedOperationException();
    }

    @Override
    public float termFrequency(String term) {
        float p = this.method.getParameter(this.parameter, this.base.numOfTerms(), this.base.numOfVocabulary());
        return p * this.base.termFrequency(term) + (1.0f - p) * this.bg.termFrequency(term);
    }

    @Override
    public Set<String> getVocabulary() {
        return new HashSet<String>(this.bg.getVocabulary());
    }

    @Override
    public int numOfVocabulary() {
        return this.bg.numOfVocabulary();
    }

    public int hashCode() {
        return this.base.hashCode() & this.bg.hashCode() & this.method.hashCode() & Float.floatToIntBits(this.parameter);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SmoothedModel)) {
            return false;
        }
        SmoothedModel s = (SmoothedModel)o;
        return this.base.equals(s.base) && this.bg.equals(s.bg) && this.method.equals(s.method) && this.parameter == s.parameter;
    }

    @Override
    public String toString() {
        Set<String> v = this.getVocabulary();
        StringBuilder s = new StringBuilder();
        String ret = "";
        String sysRet = System.getProperty("line.separator");
        for (String term : v) {
            s.append(ret);
            s.append("term:");
            s.append(term);
            s.append("\t\t");
            s.append("term freq:");
            s.append(this.termFrequency(term));
            ret = sysRet;
        }
        return s.toString();
    }
}

