/*
 * Decompiled with CFR 0.152.
 */
package net.trialpc.sticktools.model;

import java.util.EventObject;

public class StateEvent
extends EventObject {
    private static final long serialVersionUID = -8647840331527062106L;
    public static final int ADD_TERM = 1;
    public static final int REMOVE_TERM = 2;
    public static final int CLEAR = 4;
    public static final int CLEAR_PARTIALLY = 8;
    public static final int ADD_MODEL = 16;
    private static long nextEventId = 0L;
    private final long eventId = nextEventId;
    private final int event;
    private String term = null;

    public StateEvent(Object src, int event) {
        this(src, event, null);
    }

    public StateEvent(Object src, int event, String term) {
        super(src);
        this.event = event;
        this.term = term;
        nextEventId = nextEventId++ % Long.MAX_VALUE;
    }

    public int getStateEvent() {
        return this.event;
    }

    public String getTerm() {
        return this.term;
    }

    public long eventId() {
        return this.eventId;
    }

    @Override
    public String toString() {
        String s = "StateEvent:";
        switch (this.event) {
            case 1: {
                s = String.valueOf(s) + "[event]ADD_TERM ";
                break;
            }
            case 2: {
                s = String.valueOf(s) + "[event]REMOVE_TERM ";
                break;
            }
            case 4: {
                s = String.valueOf(s) + "[event]CLEAR ";
                break;
            }
            case 8: {
                s = String.valueOf(s) + "[event]CLEAR_PARTIALLY ";
                break;
            }
            default: {
                s = String.valueOf(s) + "[event]UNKNOWN ";
            }
        }
        s = String.valueOf(s) + "[term]" + this.term;
        return s;
    }
}

