/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jp.naist.se.stigmata.BirthmarkContext;
import jp.naist.se.stigmata.BirthmarkSet;
import jp.naist.se.stigmata.ComparisonPair;
import jp.naist.se.stigmata.ComparisonResultSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CertainPairComparisonResultSet
implements ComparisonResultSet {
    private BirthmarkContext context;
    private List<ComparisonPair> pairList = new ArrayList<ComparisonPair>();

    public CertainPairComparisonResultSet(ComparisonPair[] pairs, BirthmarkContext context) {
        this.context = context;
        for (int i = 0; i < pairs.length; ++i) {
            this.pairList.add(pairs[i]);
        }
    }

    public CertainPairComparisonResultSet(BirthmarkSet[] targetX, BirthmarkSet[] targetY, BirthmarkContext context) {
        this.context = context;
        for (int i = 0; i < targetX.length; ++i) {
            BirthmarkSet target2 = this.findTarget(targetX[i].getClassName(), targetY);
            if (target2 == null) continue;
            this.pairList.add(new ComparisonPair(targetX[i], target2, context));
        }
    }

    public CertainPairComparisonResultSet(BirthmarkSet[] targetX, BirthmarkSet[] targetY, Map<String, String> mapping, BirthmarkContext context) {
        this.context = context;
        for (String name : mapping.keySet()) {
            BirthmarkSet target1 = this.findTarget(name, targetX);
            BirthmarkSet target2 = this.findTarget(mapping.get(name), targetY);
            if (target1 == null && target2 == null) {
                target1 = this.findTarget(name, targetY);
                target2 = this.findTarget(mapping.get(name), targetX);
                if (target1 != null && target2 != null) {
                    BirthmarkSet[] tmp = targetX;
                    targetX = targetY;
                    targetY = tmp;
                }
            }
            if (target1 == null || target2 == null) continue;
            this.pairList.add(new ComparisonPair(target1, target2, context));
        }
    }

    @Override
    public BirthmarkContext getContext() {
        return this.context;
    }

    @Override
    public int getComparisonCount() {
        return this.pairList.size();
    }

    @Override
    public Iterator<ComparisonPair> iterator() {
        return this.pairList.iterator();
    }

    private BirthmarkSet findTarget(String className, BirthmarkSet[] target) {
        for (int i = 0; i < target.length; ++i) {
            if (!className.equals(target[i].getClassName())) continue;
            return target[i];
        }
        return null;
    }
}

