/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.birthmarks;

import java.io.IOException;
import java.io.InputStream;
import jp.naist.se.stigmata.AbstractBirthmarkExtractor;
import jp.naist.se.stigmata.Birthmark;
import jp.naist.se.stigmata.BirthmarkContext;
import jp.naist.se.stigmata.BirthmarkExtractionException;
import jp.naist.se.stigmata.birthmarks.BirthmarkExtractVisitor;
import jp.naist.se.stigmata.birthmarks.PlainBirthmark;
import jp.naist.se.stigmata.spi.BirthmarkSpi;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public abstract class ASMBirthmarkExtractor
extends AbstractBirthmarkExtractor {
    public ASMBirthmarkExtractor(BirthmarkSpi spi) {
        super(spi);
    }

    public ASMBirthmarkExtractor() {
    }

    public abstract BirthmarkExtractVisitor createExtractVisitor(ClassWriter var1, Birthmark var2, BirthmarkContext var3);

    public Birthmark extract(InputStream in, BirthmarkContext context) throws BirthmarkExtractionException {
        BirthmarkExtractionException bee = new BirthmarkExtractionException();
        try {
            PlainBirthmark birthmark = new PlainBirthmark(this.getProvider().getType());
            ClassReader reader = new ClassReader(in);
            ClassWriter writer = new ClassWriter(false);
            BirthmarkExtractVisitor visitor = this.createExtractVisitor(writer, birthmark, context);
            reader.accept((ClassVisitor)visitor, false);
            if (!visitor.isSuccess()) {
                bee.addCauses(visitor.getCauses());
            }
            return birthmark;
        }
        catch (IOException e) {
            bee.addCause(e);
            throw bee;
        }
    }
}

