/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.ui.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import jp.naist.se.stigmata.BirthmarkContext;
import jp.naist.se.stigmata.ui.swing.Messages;
import jp.naist.se.stigmata.ui.swing.StigmataFrame;
import jp.naist.se.stigmata.ui.swing.Utility;

public class PropertyEditPane
extends JPanel {
    private static final long serialVersionUID = 12397342543653L;
    private StigmataFrame stigmata;
    private JTable table;
    private DefaultTableModel model;

    public PropertyEditPane(StigmataFrame stigmata) {
        this.stigmata = stigmata;
        this.initLayouts();
        this.initData();
    }

    public void updateContext(BirthmarkContext context) {
        context.clearProperties();
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            context.addProperty((String)this.model.getValueAt(i, 0), (String)this.model.getValueAt(i, 1));
        }
    }

    private void initData() {
        BirthmarkContext context = this.stigmata.getContext();
        Iterator<String> i = context.propertyKeys();
        while (i.hasNext()) {
            String key = i.next();
            this.model.addRow(new Object[]{key, context.getProperty(key)});
        }
    }

    private void addNewProperty() {
        GridBagLayout layout = new GridBagLayout();
        JPanel panel = new JPanel(layout);
        JLabel nameLabel = new JLabel(Messages.getString("propertyname.label"));
        JLabel valueLabel = new JLabel(Messages.getString("propertyvalue.label"));
        JTextField name = new JTextField(15);
        JTextField value = new JTextField(15);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridwidth = 1;
        gbc.gridy = 0;
        gbc.gridheight = 1;
        gbc.insets = new Insets(5, 5, 5, 0);
        layout.setConstraints(nameLabel, gbc);
        panel.add(nameLabel);
        gbc.gridx = 1;
        gbc.gridwidth = 2;
        gbc.gridy = 0;
        gbc.gridheight = 1;
        gbc.fill = 2;
        layout.setConstraints(name, gbc);
        panel.add(name);
        gbc.gridx = 0;
        gbc.gridwidth = 1;
        gbc.gridy = 1;
        gbc.gridheight = 1;
        layout.setConstraints(valueLabel, gbc);
        panel.add(valueLabel);
        gbc.gridx = 1;
        gbc.gridwidth = 2;
        gbc.gridy = 1;
        gbc.gridheight = 1;
        gbc.fill = 2;
        layout.setConstraints(value, gbc);
        panel.add(value);
        int val = JOptionPane.showConfirmDialog(this.stigmata, panel, Messages.getString("propertyadd.dialog.title"), 0, 3);
        if (val == 0) {
            this.model.addRow(new Object[]{name.getText().trim(), value.getText()});
        }
    }

    private void removeSelectedProperty() {
        int[] indexes = this.table.getSelectedRows();
        for (int i = indexes.length - 1; i >= 0; --i) {
            this.model.removeRow(indexes[i]);
        }
    }

    private void initLayouts() {
        this.model = new DefaultTableModel();
        this.model.addColumn(Messages.getString("propertyname.label"));
        this.model.addColumn(Messages.getString("propertyvalue.label"));
        this.table = new JTable(this.model);
        this.table.setSelectionMode(2);
        this.table.setColumnSelectionAllowed(false);
        JButton add = Utility.createButton("propertyadd");
        final JButton remove = Utility.createButton("propertyremove");
        this.setLayout(new BorderLayout());
        JScrollPane scroll = new JScrollPane(this.table);
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        box.add(add);
        box.add(Box.createHorizontalGlue());
        box.add(remove);
        box.add(Box.createHorizontalGlue());
        this.add((Component)scroll, "Center");
        this.add((Component)box, "South");
        add.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PropertyEditPane.this.addNewProperty();
            }
        });
        remove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PropertyEditPane.this.removeSelectedProperty();
            }
        });
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent arg0) {
                remove.setEnabled(PropertyEditPane.this.table.getSelectedRowCount() != 0);
            }
        });
        remove.setEnabled(false);
    }
}

