/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import jp.cafebabe.commons.xmlcli.CommandLinePlus;
import jp.cafebabe.commons.xmlcli.HelpFormatterPlus;
import jp.cafebabe.commons.xmlcli.OptionsBuilder;
import jp.cafebabe.commons.xmlcli.builder.OptionsBuilderFactory;
import jp.naist.se.stigmata.BirthmarkContext;
import jp.naist.se.stigmata.BirthmarkSet;
import jp.naist.se.stigmata.ComparisonPairFilter;
import jp.naist.se.stigmata.ComparisonPairFilterSet;
import jp.naist.se.stigmata.ComparisonResultSet;
import jp.naist.se.stigmata.Stigmata;
import jp.naist.se.stigmata.format.BirthmarkComparisonResultFormat;
import jp.naist.se.stigmata.format.BirthmarkExtractionResultFormat;
import jp.naist.se.stigmata.format.BirthmarkServiceListFormat;
import jp.naist.se.stigmata.format.FormatManager;
import jp.naist.se.stigmata.reader.ClasspathContext;
import jp.naist.se.stigmata.spi.BirthmarkSpi;
import jp.naist.se.stigmata.spi.ResultFormatSpi;
import jp.naist.se.stigmata.ui.swing.StigmataFrame;
import jp.naist.se.stigmata.utils.ConfigFileExporter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.w3c.dom.DOMException;
import org.xml.sax.SAXException;

public final class Main {
    private FormatManager manager = FormatManager.getInstance();
    private BirthmarkContext context;

    public Main(String[] args) throws ParseException {
        boolean exitFlag;
        Options options = this.buildOptions();
        PosixParser parser = new PosixParser();
        CommandLinePlus commandLine = new CommandLinePlus(parser.parse(options, args, false));
        Stigmata stigmata = Stigmata.getInstance();
        stigmata.configuration(commandLine.getOptionValue("config-file"));
        this.context = stigmata.createContext();
        this.addClasspath(this.context.getBytecodeContext(), commandLine);
        String[] birthmarks = this.getTargetBirthmarks(commandLine);
        String[] arguments = commandLine.getArgs();
        String mode = commandLine.getOptionValue("mode");
        String format = commandLine.getOptionValue("format");
        if (format == null) {
            format = "xml";
        }
        if (mode == null) {
            mode = "gui";
        }
        if (!(exitFlag = this.executeOption(commandLine, options))) {
            if (!("gui".equals(mode) || "list".equals(mode) || arguments != null && arguments.length != 0)) {
                this.printHelp(options);
                return;
            }
            if (mode.equals("list")) {
                this.listBirthmarks(stigmata, format);
            } else if (mode.equals("extract")) {
                this.extractBirthmarks(stigmata, birthmarks, arguments, format);
            } else if (mode.equals("compare")) {
                String[] filters = null;
                if (commandLine.hasOption("filter")) {
                    filters = commandLine.getOptionValues("filter");
                }
                this.compareBirthmarks(stigmata, birthmarks, filters, arguments, format);
            } else if (mode.equals("gui")) {
                StigmataFrame frame = new StigmataFrame(stigmata, this.context);
                frame.setVisible(true);
            }
        }
    }

    private void extractBirthmarks(Stigmata stigmata, String[] birthmarks, String[] args, String format) {
        try {
            BirthmarkSet[] sets = stigmata.extract(birthmarks, args, this.context);
            ResultFormatSpi spi = this.manager.getService(format);
            BirthmarkExtractionResultFormat formatter = spi.getExtractionResultFormat();
            formatter.printResult(new PrintWriter(System.out), sets);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void compareBirthmarks(Stigmata stigmata, String[] birthmarks, String[] filters, String[] args, String format) {
        try {
            BirthmarkSet[] sets = stigmata.extract(birthmarks, args, this.context);
            ComparisonResultSet resultset = stigmata.compare(sets, this.context);
            if (filters != null) {
                resultset = stigmata.filter(resultset, filters);
            }
            ResultFormatSpi spi = this.manager.getService(format);
            BirthmarkComparisonResultFormat formatter = spi.getComparisonResultFormat();
            formatter.printResult(new PrintWriter(System.out), resultset);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void listBirthmarks(Stigmata stigmata, String format) {
        try {
            BirthmarkSpi[] spis = stigmata.createContext().findServices();
            ResultFormatSpi spi = this.manager.getService(format);
            BirthmarkServiceListFormat formatter = spi.getBirthmarkServiceListFormat();
            formatter.printResult(new PrintWriter(System.out), spis);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String[] getTargetBirthmarks(CommandLinePlus cl) {
        String[] birthmarks = cl.getOptionValues("birthmark");
        if (birthmarks == null || birthmarks.length == 0) {
            ArrayList<String> birthmarkList = new ArrayList<String>();
            BirthmarkSpi[] birthmarkSpiArray = this.context.getServices();
            int n = 0;
            int n2 = birthmarkSpiArray.length;
            while (n < n2) {
                BirthmarkSpi service = birthmarkSpiArray[n];
                if (!service.isExpert()) {
                    birthmarkList.add(service.getType());
                }
                ++n;
            }
            birthmarks = birthmarkList.toArray(new String[birthmarkList.size()]);
        }
        return birthmarks;
    }

    private void addClasspath(ClasspathContext context, CommandLinePlus commandLine) {
        String[] classpath = commandLine.getOptionValues("classpath");
        if (classpath != null) {
            String[] stringArray = classpath;
            int n = 0;
            int n2 = stringArray.length;
            while (n < n2) {
                String cp = stringArray[n];
                try {
                    File f = new File(cp);
                    if (f.exists()) {
                        context.addClasspath(f.toURI().toURL());
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
                ++n;
            }
        }
    }

    private boolean executeOption(CommandLinePlus commandLine, Options options) {
        boolean exitFlag = false;
        if (commandLine.hasOption("help")) {
            this.printHelp(options);
            exitFlag = true;
        }
        if (commandLine.hasOption("version")) {
            this.printVersion();
            exitFlag = true;
        }
        if (commandLine.hasOption("license")) {
            this.printLicense();
            exitFlag = true;
        }
        if (commandLine.hasOption("export-config")) {
            this.exportConfiguration(commandLine.getOptionValue("export-config"));
            exitFlag = true;
        }
        return exitFlag;
    }

    private Options buildOptions() {
        try {
            OptionsBuilderFactory factory = OptionsBuilderFactory.getInstance();
            URL location = this.getClass().getResource("/resources/options.xml");
            OptionsBuilder builder = factory.createBuilder(location);
            Options options = builder.buildOptions();
            return options;
        }
        catch (DOMException ex) {
            ex.printStackTrace();
        }
        catch (SAXException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    private void exportConfiguration(String file) {
        try {
            PrintWriter out;
            if (file == null) {
                out = new PrintWriter(System.out);
            } else {
                if (!file.endsWith(".xml")) {
                    file = String.valueOf(file) + ".xml";
                }
                out = new PrintWriter(new FileWriter(file));
            }
            new ConfigFileExporter(this.context).export(out);
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void printHelp(Options options) {
        Package p = this.getClass().getPackage();
        HelpFormatterPlus formatter = new HelpFormatterPlus();
        System.out.println(options.getClass().getName());
        formatter.printHelp(String.format("java -jar stigmata-%s.jar <OPTIONS> <TARGETS>%nTARGETS is allowed as jar files, war files, class files, and classpath directory.", p.getImplementationVersion()), options);
        System.out.println();
        System.out.println("Available birthmarks:");
        Object[] objectArray = this.context.getServices();
        int n = 0;
        int n2 = objectArray.length;
        while (n < n2) {
            BirthmarkSpi service = objectArray[n];
            if (!service.isExpert()) {
                System.out.printf("    %-5s (%s): %s%n", service.getType(), service.getDisplayType(), service.getDescription());
            }
            ++n;
        }
        System.out.println();
        System.out.println("Available filers:");
        objectArray = this.context.getFilterManager().getFilterSets();
        n = 0;
        n2 = objectArray.length;
        while (n < n2) {
            Object filterset = objectArray[n];
            System.out.printf("    %s (%s)%n", ((ComparisonPairFilterSet)filterset).getName(), ((ComparisonPairFilterSet)filterset).isMatchAll() ? "match all" : "match any");
            Iterator<ComparisonPairFilter> iterator = ((ComparisonPairFilterSet)filterset).iterator();
            while (iterator.hasNext()) {
                ComparisonPairFilter filter = iterator.next();
                System.out.printf("        %s%n", filter);
            }
            ++n;
        }
        System.out.println();
        System.out.println("Copyright (C) by Haruaki Tamada, Ph.D.");
        System.out.println("Please notify us some bugs and requests to <birthmark-analysis[ at ]se.aist-nara.ac.jp>");
    }

    private void printLicense() {
        try {
            String line;
            InputStream in = this.getClass().getResourceAsStream("/META-INF/license.txt");
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            while ((line = reader.readLine()) != null) {
                System.out.println(line);
            }
            reader.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void printVersion() {
        Package p = this.getClass().getPackage();
        System.out.println("stigmata version " + p.getImplementationVersion());
    }

    public static void main(String[] args) throws Exception {
        new Main(args);
    }
}

