/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.ui.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import jp.naist.se.stigmata.BirthmarkContext;
import jp.naist.se.stigmata.BirthmarkSet;
import jp.naist.se.stigmata.format.BirthmarkExtractionResultFormat;
import jp.naist.se.stigmata.format.FormatManager;
import jp.naist.se.stigmata.spi.ResultFormatSpi;
import jp.naist.se.stigmata.ui.swing.AsciiDataWritable;
import jp.naist.se.stigmata.ui.swing.BirthmarkTree;
import jp.naist.se.stigmata.ui.swing.StigmataFrame;
import jp.naist.se.stigmata.ui.swing.Utility;
import jp.naist.se.stigmata.ui.swing.actions.SaveAction;

public class BirthmarkExtractionResultPane
extends JPanel {
    private static final long serialVersionUID = 239084365756236543L;
    private List<BirthmarkSet> birthmarks;
    private StigmataFrame frame;

    public BirthmarkExtractionResultPane(StigmataFrame stigmataFrame, BirthmarkContext context, BirthmarkSet[] sets) {
        this.frame = stigmataFrame;
        this.birthmarks = Arrays.asList(sets);
        Box southPanel = Box.createHorizontalBox();
        JButton saveButton = Utility.createButton("savebirthmark", new SaveAction(this.frame, new AsciiDataWritable(){

            public void writeAsciiData(PrintWriter out, String format) {
                ResultFormatSpi service = FormatManager.getInstance().getService(format);
                if (service == null) {
                    service = FormatManager.getDefaultFormatService();
                }
                BirthmarkExtractionResultFormat list = service.getExtractionResultFormat();
                list.printResult(new PrintWriter(out), BirthmarkExtractionResultPane.this.birthmarks.toArray(new BirthmarkSet[BirthmarkExtractionResultPane.this.birthmarks.size()]));
            }
        }));
        JScrollPane scroll = new JScrollPane();
        scroll.setViewportView(new BirthmarkTree(this.birthmarks.toArray(new BirthmarkSet[this.birthmarks.size()])));
        this.setLayout(new BorderLayout());
        this.add((Component)scroll, "Center");
        this.add((Component)southPanel, "South");
        southPanel.add(Box.createHorizontalGlue());
        southPanel.add(saveButton);
        southPanel.add(Box.createHorizontalGlue());
    }
}

