/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.ui.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.TitledBorder;
import jp.naist.se.stigmata.BirthmarkContext;
import jp.naist.se.stigmata.reader.ClasspathContext;
import jp.naist.se.stigmata.ui.swing.BirthmarkDefinitionPane;
import jp.naist.se.stigmata.ui.swing.BirthmarkSelectablePane;
import jp.naist.se.stigmata.ui.swing.BirthmarkSelectionCheckSetPane;
import jp.naist.se.stigmata.ui.swing.BirthmarkServiceListener;
import jp.naist.se.stigmata.ui.swing.ClasspathSettingsPane;
import jp.naist.se.stigmata.ui.swing.DataChangeListener;
import jp.naist.se.stigmata.ui.swing.FilterManagementPane;
import jp.naist.se.stigmata.ui.swing.FilterSelectionPane;
import jp.naist.se.stigmata.ui.swing.Messages;
import jp.naist.se.stigmata.ui.swing.PopupButton;
import jp.naist.se.stigmata.ui.swing.PropertyEditPane;
import jp.naist.se.stigmata.ui.swing.StigmataFrame;
import jp.naist.se.stigmata.ui.swing.TargetSelectionPane;
import jp.naist.se.stigmata.ui.swing.Utility;
import jp.naist.se.stigmata.ui.swing.WellknownClassesSettingsPane;
import jp.naist.se.stigmata.utils.ConfigFileExporter;
import jp.naist.se.stigmata.utils.WellknownClassManager;

public class ControlPane
extends JPanel {
    private static final long serialVersionUID = 983547612346543645L;
    private StigmataFrame stigmata;
    private BirthmarkSelectablePane birthmarks;
    private TargetSelectionPane targetX;
    private TargetSelectionPane targetY;
    private ClasspathSettingsPane classpath;
    private WellknownClassesSettingsPane wellknownClassses;
    private BirthmarkDefinitionPane definition;
    private PropertyEditPane properties;
    private FilterManagementPane filters;
    private JTabbedPane controlTab;
    private JButton compareButton;
    private JButton extractButton;
    private JButton resetButton;
    private PopupButton comparePopup;
    private boolean expertmode = false;

    public ControlPane(StigmataFrame stigmata) {
        this.stigmata = stigmata;
    }

    void inititalize() {
        this.definition = new BirthmarkDefinitionPane(this.stigmata);
        this.birthmarks = new BirthmarkSelectionCheckSetPane(this.stigmata);
        this.properties = new PropertyEditPane(this.stigmata);
        JComponent control = this.createControlPane();
        this.wellknownClassses = new WellknownClassesSettingsPane(this.stigmata);
        this.classpath = new ClasspathSettingsPane(this.stigmata);
        this.filters = new FilterManagementPane(this.stigmata);
        this.initComponents();
        Utility.addNewTab("targets", this.controlTab, control);
        Utility.addNewTab("wellknown", this.controlTab, this.wellknownClassses);
        Utility.addNewTab("classpath", this.controlTab, this.classpath);
        this.reset();
    }

    public void addBirthmarkServiceListener(BirthmarkServiceListener listener) {
        this.definition.addBirthmarkServiceListener(listener);
    }

    public void removeBirthmarkServiceListener(BirthmarkServiceListener listener) {
        this.definition.removeBirthmarkServiceListener(listener);
    }

    public void reset() {
        int index2;
        this.expertmode = false;
        this.definition.reset();
        this.birthmarks.reset();
        this.stigmata.setExpertMode(false);
        this.targetX.removeAllElements();
        this.targetY.removeAllElements();
        this.classpath.reset();
        this.wellknownClassses.reset();
        this.filters.reset();
        this.updateEnable();
        int index1 = this.controlTab.indexOfTab(Messages.getString("definition.tab.label"));
        if (index1 >= 0) {
            this.controlTab.removeTabAt(index1);
        }
        if ((index2 = this.controlTab.indexOfTab(Messages.getString("property.tab.label"))) >= 0) {
            this.controlTab.removeTabAt(index2);
        }
    }

    public void exportSettings() {
        File file = this.stigmata.getSaveFile(Messages.getStringArray("export.extensions"), Messages.getString("export.description"));
        if (file != null) {
            BirthmarkContext context = this.generateContext();
            if (!file.getName().endsWith(".xml")) {
                file = new File(file.getParent(), String.valueOf(file.getName()) + ".xml");
            }
            ConfigFileExporter bce = new ConfigFileExporter(context);
            try {
                PrintWriter out = new PrintWriter(new FileWriter(file));
                bce.export(out);
                out.close();
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this.stigmata, Messages.getString("error.io", e.getMessage()), Messages.getString("error.dialog.title"), 0);
            }
        }
    }

    public void setExpertMode(boolean expertmode) {
        this.expertmode = expertmode;
        this.birthmarks.setExpertMode(expertmode);
        this.stigmata.setExpertMode(expertmode);
        if (expertmode) {
            Utility.addNewTab("definition", this.controlTab, this.definition);
            Utility.addNewTab("property", this.controlTab, this.properties);
            Utility.addNewTab("filter", this.controlTab, this.filters);
        } else {
            this.removeTabByName(Messages.getString("definition.tab.label"));
            this.removeTabByName(Messages.getString("property.tab.label"));
            this.removeTabByName(Messages.getString("filter.tab.label"));
        }
        this.updateEnable();
    }

    public boolean isExpertMode() {
        return this.expertmode;
    }

    private void removeTabByName(String tabname) {
        int index = this.controlTab.indexOfTab(tabname);
        if (index >= 0) {
            this.controlTab.removeTabAt(index);
        }
    }

    private JComponent createControlPane() {
        Box mainPane = new Box(0);
        JPanel center = new JPanel(new BorderLayout());
        this.targetX = new TargetSelectionPane(this.stigmata);
        this.targetY = new TargetSelectionPane(this.stigmata);
        this.birthmarks.setBorder(new TitledBorder(Messages.getString("birthmarkspane.border")));
        this.targetX.addTargetExtensions(Messages.getStringArray("targets.extensions"));
        this.targetX.setDescription(Messages.getString("targets.description"));
        this.targetX.setBorder(new TitledBorder(Messages.getString("targetx.border")));
        this.targetY.addTargetExtensions(Messages.getStringArray("targets.extensions"));
        this.targetY.setDescription(Messages.getString("targets.description"));
        this.targetY.setBorder(new TitledBorder(Messages.getString("targety.border")));
        center.add((Component)mainPane, "Center");
        center.add((Component)this.birthmarks, "South");
        mainPane.add(Box.createHorizontalGlue());
        mainPane.add(this.targetX);
        mainPane.add(Box.createHorizontalGlue());
        mainPane.add(this.targetY);
        mainPane.add(Box.createHorizontalGlue());
        DataChangeListener dcl = new DataChangeListener(){

            public void valueChanged(Object source) {
                ControlPane.this.updateEnable();
            }
        };
        this.targetX.addDataChangeListener(dcl);
        this.targetY.addDataChangeListener(dcl);
        this.birthmarks.addDataChangeListener(dcl);
        return center;
    }

    private void updateEnable() {
        String[] valueX = this.targetX.getValues();
        String[] valueY = this.targetY.getValues();
        String[] targets = this.birthmarks.getSelectedServices();
        this.extractButton.setEnabled((valueX != null && valueX.length > 0 || valueY != null && valueY.length > 0) && targets != null && targets.length > 0);
        this.comparePopup.setEnabled(valueX != null && valueX.length > 0 && valueY != null && valueY.length > 0 && targets != null && targets.length > 0);
    }

    private void extractButtonActionPerformed(ActionEvent e) {
        String file;
        int n;
        int n2;
        String[] stringArray;
        BirthmarkContext context = this.generateContext();
        String[] fileX = this.targetX.getValues();
        String[] fileY = this.targetY.getValues();
        HashSet<String> targets = new HashSet<String>();
        if (fileX != null && fileX.length > 0) {
            stringArray = fileX;
            n2 = 0;
            n = stringArray.length;
            while (n2 < n) {
                file = stringArray[n2];
                targets.add(file);
                ++n2;
            }
        }
        if (fileY != null && fileY.length > 0) {
            stringArray = fileY;
            n2 = 0;
            n = stringArray.length;
            while (n2 < n) {
                file = stringArray[n2];
                targets.add(file);
                ++n2;
            }
        }
        this.stigmata.extract(this.birthmarks.getSelectedServices(), targets.toArray(new String[targets.size()]), context);
    }

    private void compareRoundRobinWithFiltering() {
        BirthmarkContext context = this.generateContext();
        FilterSelectionPane pane = new FilterSelectionPane(context.getFilterManager());
        int returnValue = JOptionPane.showConfirmDialog(this.stigmata, pane, Messages.getString("filterselection.dialog.title"), 2, 3);
        if (returnValue == 0) {
            String[] filterSetList = pane.getSelectedFilters();
            this.stigmata.compareRoundRobin(this.birthmarks.getSelectedServices(), this.targetX.getValues(), this.targetY.getValues(), filterSetList, context);
        }
    }

    private void compareRoundRobin() {
        BirthmarkContext context = this.generateContext();
        this.stigmata.compareRoundRobin(this.birthmarks.getSelectedServices(), this.targetX.getValues(), this.targetY.getValues(), context);
    }

    private void compareSpecifiedPair() {
        BirthmarkContext context = this.generateContext();
        String[] fileX = this.targetX.getValues();
        String[] fileY = this.targetY.getValues();
        this.stigmata.compareSpecifiedPair(this.birthmarks.getSelectedServices(), fileX, fileY, context);
    }

    private void compareGuessedPair() {
        BirthmarkContext context = this.generateContext();
        String[] fileX = this.targetX.getValues();
        String[] fileY = this.targetY.getValues();
        this.stigmata.compareGuessedPair(this.birthmarks.getSelectedServices(), fileX, fileY, context);
    }

    private BirthmarkContext generateContext() {
        BirthmarkContext context = this.stigmata.getStigmata().createContext();
        ClasspathContext bytecode = context.getBytecodeContext();
        WellknownClassManager manager = context.getWellknownClassManager();
        this.classpath.updateClasspathContext(bytecode);
        this.wellknownClassses.setWellknownClasses(manager);
        this.definition.updateContext(context);
        this.properties.updateContext(context);
        this.filters.updateFilterManager(context.getFilterManager());
        return context;
    }

    private void initComponents() {
        this.controlTab = new JTabbedPane();
        this.resetButton = Utility.createButton("reset");
        this.extractButton = Utility.createButton("extract");
        this.compareButton = Utility.createButton("roundrobin");
        this.comparePopup = new PopupButton(this.compareButton);
        Box south = Box.createHorizontalBox();
        south.add(Box.createHorizontalGlue());
        south.add(this.resetButton);
        south.add(Box.createHorizontalGlue());
        south.add(this.extractButton);
        south.add(Box.createHorizontalGlue());
        south.add(this.comparePopup);
        south.add(Box.createHorizontalGlue());
        this.setLayout(new BorderLayout());
        this.add((Component)south, "South");
        this.add((Component)this.controlTab, "Center");
        this.extractButton.setEnabled(false);
        this.comparePopup.setEnabled(false);
        this.resetButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ControlPane.this.reset();
            }
        });
        this.extractButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ControlPane.this.extractButtonActionPerformed(e);
            }
        });
        ActionListener compareListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String command = e.getActionCommand();
                if (command.equals("roundrobin")) {
                    ControlPane.this.compareRoundRobin();
                } else if (command.equals("guessedpair")) {
                    ControlPane.this.compareGuessedPair();
                } else if (command.equals("specifiedpair")) {
                    ControlPane.this.compareSpecifiedPair();
                } else if (command.equals("roundrobin.filtering")) {
                    ControlPane.this.compareRoundRobinWithFiltering();
                }
            }
        };
        this.compareButton.addActionListener(compareListener);
        String[] items = Messages.getStringArray("comparison.methods");
        int i = 1;
        while (i < items.length) {
            JMenuItem item = Utility.createJMenuItem(items[i]);
            this.comparePopup.addMenuItem(item);
            item.addActionListener(compareListener);
            ++i;
        }
    }
}

