/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.ui.swing.mds;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;

public class MDSMethod {
    private Matrix target;
    private Matrix coordinate;
    private Matrix eigenValues;
    private Matrix eigenVectors;
    private int[] indexes;

    public MDSMethod(Matrix matrix) {
        this.target = matrix;
    }

    protected Matrix getCenteredInnerProductMatrix() {
        Matrix centering = MDSMethod.getCenteringMatrix(this.target.getColumnDimension());
        Matrix trans = centering.transpose();
        return centering.times(this.target).times(trans).times(-1.0);
    }

    public Matrix getEigenValues() {
        if (this.eigenValues == null) {
            this.getCoordinateMatrix();
        }
        return (Matrix)this.eigenValues.clone();
    }

    public Matrix getEigenVectors() {
        if (this.eigenVectors == null) {
            this.getCoordinateMatrix();
        }
        return (Matrix)this.eigenVectors.clone();
    }

    public double[] getCoordinate(int axis) {
        if (this.coordinate == null) {
            this.getCoordinateMatrix();
        }
        double[] v = new double[this.coordinate.getRowDimension()];
        int i = 0;
        while (i < v.length) {
            v[i] = this.coordinate.get(i, this.indexes[axis]);
            ++i;
        }
        return v;
    }

    public Matrix getCoordinateMatrix() {
        if (this.coordinate == null) {
            Matrix mat = this.getCenteredInnerProductMatrix();
            EigenvalueDecomposition eigen = mat.eig();
            Matrix eigenVectors = eigen.getV();
            Matrix eigenValues = eigen.getD();
            Matrix coordinate = (Matrix)eigenVectors.clone();
            int col = mat.getColumnDimension();
            int row = mat.getRowDimension();
            int i = 0;
            while (i < row) {
                int j = 0;
                while (j < col) {
                    double v = coordinate.get(i, j);
                    coordinate.set(i, j, v *= Math.sqrt(eigenValues.get(j, j)));
                    ++j;
                }
                ++i;
            }
            this.sortValues(eigenValues);
            this.coordinate = coordinate;
            this.eigenVectors = eigenVectors;
            this.eigenValues = eigenValues;
        }
        return this.coordinate;
    }

    protected static Matrix getCenteringMatrix(int n) {
        Matrix matrix = Matrix.identity((int)n, (int)n);
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < n) {
                matrix.set(i, j, matrix.get(i, j) - 1.0 / (double)n);
                ++j;
            }
            ++i;
        }
        return matrix;
    }

    private void sortValues(Matrix m) {
        double[] v = new double[m.getColumnDimension()];
        int[] index = new int[v.length];
        int i = 0;
        while (i < v.length) {
            v[i] = m.get(i, i);
            index[i] = i;
            ++i;
        }
        i = 0;
        while (i < v.length) {
            int j = i + 1;
            while (j < v.length) {
                if (Math.abs(v[i]) < Math.abs(v[j])) {
                    double tmpValue = v[j];
                    v[j] = v[i];
                    v[i] = tmpValue;
                    int tmpIndex = index[j];
                    index[j] = index[i];
                    index[i] = tmpIndex;
                }
                ++j;
            }
            ++i;
        }
        this.indexes = index;
    }

    public static void main(String[] args) {
        Matrix matrix = new Matrix((double[][])new double[][]{{0.0, 587.0, 1212.0, 701.0, 1936.0, 604.0, 748.0, 2139.0, 2182.0, 543.0}, {587.0, 0.0, 920.0, 940.0, 1745.0, 1188.0, 713.0, 1858.0, 1737.0, 597.0}, {1212.0, 920.0, 0.0, 879.0, 831.0, 1726.0, 1631.0, 949.0, 1021.0, 1494.0}, {701.0, 940.0, 879.0, 0.0, 1374.0, 968.0, 1420.0, 1645.0, 1891.0, 1220.0}, {1936.0, 1745.0, 831.0, 1374.0, 0.0, 2339.0, 2451.0, 347.0, 959.0, 2300.0}, {604.0, 1188.0, 1726.0, 968.0, 2339.0, 0.0, 1092.0, 2592.0, 2734.0, 923.0}, {748.0, 713.0, 1631.0, 1420.0, 2451.0, 1092.0, 0.0, 2571.0, 2408.0, 205.0}, {2139.0, 1858.0, 949.0, 1645.0, 347.0, 2594.0, 2571.0, 0.0, 678.0, 2442.0}, {2182.0, 1737.0, 1021.0, 1891.0, 959.0, 2734.0, 2408.0, 678.0, 0.0, 2329.0}, {543.0, 597.0, 1494.0, 1220.0, 2300.0, 923.0, 205.0, 2442.0, 2329.0, 0.0}});
        MDSMethod mds = new MDSMethod(matrix);
        System.out.println(mds.getCoordinateMatrix());
    }
}

