/*
 * Decompiled with CFR 0.152.
 */
package jp.cafebabe.commons.xmlcli;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class HelpFormatterPlus
extends HelpFormatter {
    protected StringBuffer renderOptions(StringBuffer sb, int width, Options options, int leftPad, int descPad) {
        StringBuffer optBuf;
        String lpad = this.createPadding(leftPad);
        String dpad = this.createPadding(descPad);
        int max = 0;
        ArrayList<StringBuffer> prefixList = new ArrayList<StringBuffer>();
        ArrayList optList = new ArrayList(options.getOptions());
        Collections.sort(optList, new StringBufferComparator());
        for (Option option : optList) {
            optBuf = new StringBuffer(8);
            if (option.getOpt().equals(" ")) {
                optBuf.append(lpad).append("   " + this.defaultLongOptPrefix).append(option.getLongOpt());
            } else {
                optBuf.append(lpad).append(this.defaultOptPrefix).append(option.getOpt());
                if (option.hasLongOpt()) {
                    optBuf.append(',').append(this.defaultLongOptPrefix).append(option.getLongOpt());
                }
            }
            if (option.hasArg()) {
                if (option.hasArgName()) {
                    optBuf.append(" <").append(option.getArgName()).append('>');
                } else {
                    optBuf.append(' ');
                }
            }
            prefixList.add(optBuf);
            int n = max = optBuf.length() > max ? optBuf.length() : max;
        }
        int x = 0;
        Iterator i = optList.iterator();
        while (i.hasNext()) {
            Option option;
            option = (Option)i.next();
            if ((optBuf = new StringBuffer(prefixList.get(x++).toString())).length() < max) {
                optBuf.append(this.createPadding(max - optBuf.length()));
            }
            optBuf.append(dpad);
            int nextLineTabStop = max + descPad;
            this.renderWrappedText(sb, width, nextLineTabStop, optBuf.append(option.getDescription()).toString());
            if (!i.hasNext()) continue;
            sb.append(this.defaultNewLine);
        }
        return sb;
    }

    private static class StringBufferComparator
    implements Comparator {
        private StringBufferComparator() {
        }

        public int compare(Object o1, Object o2) {
            String str1 = this.stripPrefix(o1.toString());
            String str2 = this.stripPrefix(o2.toString());
            return str1.compareTo(str2);
        }

        private String stripPrefix(String strOption) {
            int iStartIndex = strOption.lastIndexOf(45);
            if (iStartIndex == -1) {
                iStartIndex = 0;
            }
            return strOption.substring(iStartIndex);
        }
    }
}

