/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.birthmarks.is;

import java.io.IOException;
import java.io.InputStream;
import jp.naist.se.stigmata.AbstractBirthmarkExtractor;
import jp.naist.se.stigmata.Birthmark;
import jp.naist.se.stigmata.BirthmarkContext;
import jp.naist.se.stigmata.BirthmarkElementClassNotFoundException;
import jp.naist.se.stigmata.BirthmarkExtractionException;
import jp.naist.se.stigmata.birthmarks.PlainBirthmark;
import jp.naist.se.stigmata.birthmarks.is.InheritanceStructureBirthmarkExtractVisitor;
import jp.naist.se.stigmata.spi.BirthmarkSpi;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public class InheritanceStructureBirthmarkExtractor
extends AbstractBirthmarkExtractor {
    public InheritanceStructureBirthmarkExtractor(BirthmarkSpi spi) {
        super(spi);
    }

    public InheritanceStructureBirthmarkExtractor() {
    }

    public Birthmark extract(InputStream in, BirthmarkContext context) throws BirthmarkExtractionException {
        BirthmarkElementClassNotFoundException e = new BirthmarkElementClassNotFoundException();
        PlainBirthmark birthmark = new PlainBirthmark(this.getProvider().getType());
        try {
            try {
                ClassReader reader = new ClassReader(in);
                ClassWriter writer = new ClassWriter(false);
                InheritanceStructureBirthmarkExtractVisitor visitor = new InheritanceStructureBirthmarkExtractVisitor((ClassVisitor)writer, birthmark, context);
                reader.accept((ClassVisitor)visitor, false);
                if (!visitor.isSuccess()) {
                    Throwable[] throwableArray = visitor.getCauses();
                    int n = 0;
                    int n2 = throwableArray.length;
                    while (n < n2) {
                        Throwable t = throwableArray[n];
                        if (t instanceof ClassNotFoundException) {
                            e.addClassName(t.getMessage());
                        } else {
                            e.addCause(t);
                        }
                        ++n;
                    }
                }
            }
            catch (IOException ee) {
                e.addCause(ee);
            }
        }
        finally {
            if (e.isFailed()) {
                throw e;
            }
        }
        return birthmark;
    }
}

