/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.ui.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import jp.naist.se.stigmata.spi.BirthmarkSpi;

public class BirthmarkServiceListCellRenderer
extends JPanel
implements ListCellRenderer {
    private static final long serialVersionUID = 3254763527508235L;
    private static Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
    private final JLabel leftLabel = new JLabel();
    private final JLabel rightLabel = new JLabel();

    public BirthmarkServiceListCellRenderer(Dimension dim, int rightw) {
        super(new BorderLayout());
        this.leftLabel.setOpaque(true);
        this.rightLabel.setOpaque(true);
        this.setOpaque(true);
        this.leftLabel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 0));
        this.rightLabel.setPreferredSize(new Dimension(rightw, 0));
        this.rightLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        this.add((Component)this.leftLabel, "Center");
        this.add((Component)this.rightLabel, "East");
        this.setPreferredSize(dim);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
        if (value instanceof BirthmarkSpi) {
            BirthmarkSpi service = (BirthmarkSpi)value;
            this.leftLabel.setText(service.getDisplayType());
            this.rightLabel.setText("(" + service.getType() + ")");
        } else {
            this.leftLabel.setText(String.valueOf(value));
            this.rightLabel.setText("");
        }
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
            this.leftLabel.setBackground(list.getSelectionBackground());
            this.leftLabel.setForeground(list.getSelectionForeground());
            this.rightLabel.setBackground(list.getSelectionBackground());
            this.rightLabel.setForeground(Color.gray.brighter());
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
            this.leftLabel.setBackground(list.getBackground());
            this.leftLabel.setForeground(list.getForeground());
            this.rightLabel.setBackground(list.getBackground());
            this.rightLabel.setForeground(Color.gray);
        }
        Border border = null;
        if (hasFocus) {
            if (isSelected) {
                border = UIManager.getBorder("List.focusSelectedCellHighlightBorder");
            }
            if (border == null) {
                border = UIManager.getBorder("List.focusCellHighlightBorder");
            }
        } else {
            border = noFocusBorder;
        }
        this.setBorder(border);
        return this;
    }
}

