/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.ui.swing;

import java.awt.Component;
import java.io.File;
import java.text.MessageFormat;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import jp.naist.se.stigmata.ui.swing.ExtensionFilter;
import jp.naist.se.stigmata.ui.swing.Messages;

public class FileIOManager {
    private Component parent;
    private File currentDirectory;

    public FileIOManager(Component parent) {
        this.parent = parent;
        this.currentDirectory = new File(".");
    }

    public File getCurrentDirectory() {
        return this.currentDirectory;
    }

    public void setCurrentDirectory(File directory) {
        if (!directory.isDirectory()) {
            JOptionPane.showMessageDialog(this.parent, Messages.getString("notdirectory.dialog.message", directory.getName()), Messages.getString("notdirectory.dialog.title"), 0);
            return;
        }
        this.currentDirectory = directory;
    }

    public File findFile(boolean open, String[] exts, String desc) {
        JFileChooser chooser = new JFileChooser(this.getCurrentDirectory());
        int i = 0;
        while (i < exts.length) {
            chooser.addChoosableFileFilter(new ExtensionFilter(exts[i], MessageFormat.format(desc, exts[i])));
            ++i;
        }
        int returnValue = -1;
        returnValue = open ? chooser.showOpenDialog(SwingUtilities.getRootPane(this.parent)) : chooser.showSaveDialog(SwingUtilities.getRootPane(this.parent));
        if (returnValue == 0) {
            FileFilter filter;
            this.setCurrentDirectory(chooser.getCurrentDirectory());
            File file = chooser.getSelectedFile();
            if (!open && (filter = chooser.getFileFilter()) instanceof ExtensionFilter) {
                ExtensionFilter ef = (ExtensionFilter)filter;
                if (!filter.accept(file)) {
                    String[] extensions = ef.getExtensions();
                    file = this.setExtension(file, extensions[0]);
                }
            }
            return file;
        }
        return null;
    }

    private File setExtension(File file, String ext) {
        String name = file.getName();
        int index = name.lastIndexOf(46);
        String n = name;
        if (index > 0) {
            n = n.substring(0, index);
        }
        name = String.valueOf(n) + '.' + ext;
        return new File(file.getParentFile(), name);
    }
}

