/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.ui.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import jp.naist.se.stigmata.ui.swing.CurrentDirectoryHolder;
import jp.naist.se.stigmata.ui.swing.DataChangeListener;
import jp.naist.se.stigmata.ui.swing.ExtensionFilter;
import jp.naist.se.stigmata.ui.swing.Messages;
import jp.naist.se.stigmata.ui.swing.Utility;

public class TargetSelectionPane
extends JPanel {
    private static final long serialVersionUID = 3209435745432235432L;
    private CurrentDirectoryHolder currentDirectoryHolder;
    private FileFilter[] filters;
    private List<String> extensions = new ArrayList<String>();
    private String description;
    private DefaultListModel model = new DefaultListModel();
    private List<DataChangeListener> listeners = new ArrayList<DataChangeListener>();
    private boolean directorySelectable = false;
    private boolean multipleSelectable = true;
    private JList list;
    private JButton addButton;
    private JButton removeButton;

    public TargetSelectionPane(CurrentDirectoryHolder cdh) {
        this.currentDirectoryHolder = cdh;
        this.initComponents();
        this.list.setModel(this.model);
        TargetSelectionDropTarget dropTarget = new TargetSelectionDropTarget();
        this.list.setDropTarget(dropTarget);
    }

    public void addDataChangeListener(DataChangeListener listener) {
        this.listeners.add(listener);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void removeAllElements() {
        this.model.removeAllElements();
        this.fireEvent();
    }

    public void setFileFilter(FileFilter filter) {
        this.setFileFilters(new FileFilter[]{filter});
    }

    public void setFileFilters(FileFilter[] filters) {
        this.filters = filters;
    }

    public FileFilter[] getFileFilters() {
        if (this.filters == null) {
            String[] exts = this.getExtensions();
            this.filters = new FileFilter[exts.length];
            int i = 0;
            while (i < exts.length) {
                this.filters[i] = new ExtensionFilter(exts[i], MessageFormat.format(this.getSelectDescription(), exts[i]));
                ++i;
            }
        }
        return this.filters;
    }

    public void addTargetExtension(String ext) {
        if (this.filters != null) {
            this.filters = null;
        }
        this.extensions.add(ext);
    }

    public void addTargetExtensions(String[] exts) {
        if (this.filters != null) {
            this.filters = null;
        }
        String[] stringArray = exts;
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String ext = stringArray[n];
            this.extensions.add(ext);
            ++n;
        }
    }

    public synchronized String[] getExtensions() {
        return this.extensions.toArray(new String[this.extensions.size()]);
    }

    public void setSelectDescription(String description) {
        this.description = description;
    }

    public String getSelectDescription() {
        return this.description;
    }

    public String[] getValues() {
        String[] strings = new String[this.model.getSize()];
        int i = 0;
        while (i < strings.length) {
            strings[i] = (String)this.model.getElementAt(i);
            ++i;
        }
        return strings;
    }

    public String[] getSelectedValues() {
        int[] indeces = this.list.getSelectedIndices();
        String[] strings = new String[indeces.length];
        int i = 0;
        while (i < strings.length) {
            strings[i] = (String)this.model.getElementAt(indeces[i]);
            ++i;
        }
        return strings;
    }

    public void addValues(String[] values) {
        String[] stringArray = values;
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String value = stringArray[n];
            this.addValue(value);
            ++n;
        }
    }

    public void addValue(String value) {
        this.model.addElement(value);
        this.fireEvent();
    }

    public void setEnabled(boolean flag) {
        super.setEnabled(flag);
        this.addButton.setEnabled(flag);
        this.removeButton.setEnabled(flag);
        this.list.setEnabled(flag);
    }

    public void setDirectorySelectable(boolean flag) {
        this.directorySelectable = flag;
    }

    public boolean isDirectorySelectable() {
        return this.directorySelectable;
    }

    public void setMultipleSelectable(boolean flag) {
        this.multipleSelectable = flag;
    }

    public boolean isMultipleSelectable() {
        return this.multipleSelectable;
    }

    private void fireEvent() {
        int i = this.listeners.size() - 1;
        while (i >= 0) {
            DataChangeListener listener = this.listeners.get(i);
            listener.valueChanged(this.model);
            --i;
        }
    }

    private void initComponents() {
        JScrollPane scroll = new JScrollPane();
        Box south = Box.createHorizontalBox();
        this.list = new JList();
        this.addButton = Utility.createButton("addpackage");
        this.removeButton = Utility.createButton("removepackage");
        this.removeButton.setEnabled(false);
        this.setLayout(new BorderLayout());
        scroll.setViewportView(this.list);
        this.add((Component)scroll, "Center");
        south.add(Box.createHorizontalGlue());
        south.add(this.addButton);
        south.add(Box.createHorizontalGlue());
        south.add(this.removeButton);
        south.add(Box.createHorizontalGlue());
        this.list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                TargetSelectionPane.this.listValueChanged(evt);
            }
        });
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TargetSelectionPane.this.addButtonActionPerformed(evt);
            }
        });
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TargetSelectionPane.this.removeButtonActionPerformed(evt);
            }
        });
        this.add((Component)south, "South");
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        int[] indeces = this.list.getSelectedIndices();
        if (indeces != null && indeces.length >= 1) {
            int i = indeces.length - 1;
            while (i >= 0) {
                this.model.removeElementAt(indeces[i]);
                this.fireEvent();
                --i;
            }
        }
        this.removeButton.setEnabled(false);
    }

    private void listValueChanged(ListSelectionEvent evt) {
        int[] indeces = this.list.getSelectedIndices();
        this.removeButton.setEnabled(this.isEnabled() && indeces != null);
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        int returnCode;
        FileFilter[] filters;
        JFileChooser chooser = new JFileChooser(this.currentDirectoryHolder.getCurrentDirectory());
        FileFilter[] fileFilterArray = filters = this.getFileFilters();
        int n = 0;
        int n2 = fileFilterArray.length;
        while (n < n2) {
            FileFilter filter = fileFilterArray[n];
            chooser.addChoosableFileFilter(filter);
            ++n;
        }
        chooser.setMultiSelectionEnabled(this.isMultipleSelectable());
        if (this.isDirectorySelectable()) {
            chooser.setFileSelectionMode(2);
        }
        if ((returnCode = chooser.showOpenDialog(SwingUtilities.getRootPane(this))) == 0) {
            File[] files;
            this.currentDirectoryHolder.setCurrentDirectory(chooser.getCurrentDirectory());
            File[] fileArray = files = chooser.getSelectedFiles();
            int n3 = 0;
            int n4 = fileArray.length;
            while (n3 < n4) {
                File file = fileArray[n3];
                this.addValue(file.getPath());
                ++n3;
            }
        }
    }

    private class TargetSelectionDropTarget
    extends DropTarget {
        private static final long serialVersionUID = 3204457621345L;

        private TargetSelectionDropTarget() {
        }

        public void dragEnter(DropTargetDragEvent arg0) {
        }

        public void dragExit(DropTargetEvent arg0) {
        }

        public void dragOver(DropTargetDragEvent arg0) {
        }

        public void dropActionChanged(DropTargetDragEvent arg0) {
        }

        public void drop(DropTargetDropEvent dtde) {
            dtde.acceptDrop(0x40000000);
            Transferable trans = dtde.getTransferable();
            try {
                if (trans.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    List list = (List)trans.getTransferData(DataFlavor.javaFileListFlavor);
                    TargetSelectionPane.this.filters = TargetSelectionPane.this.getFileFilters();
                    ArrayList<String> errorList = new ArrayList<String>();
                    int i = 0;
                    while (i < list.size()) {
                        File file = (File)list.get(i);
                        FileFilter[] fileFilterArray = TargetSelectionPane.this.filters;
                        int n = 0;
                        int n2 = fileFilterArray.length;
                        while (n < n2) {
                            FileFilter filter = fileFilterArray[n];
                            if (filter.accept(file)) {
                                TargetSelectionPane.this.addValue(file.getPath());
                            } else {
                                errorList.add(file.getName());
                            }
                            ++n;
                        }
                        ++i;
                    }
                    if (errorList.size() > 0) {
                        StringBuilder builder = new StringBuilder("<html><body>");
                        builder.append(Messages.getString("unsupportedfiletype.dialog.message"));
                        builder.append("<ul>");
                        int i2 = 0;
                        while (i2 < errorList.size()) {
                            builder.append("<li>").append((String)errorList.get(i2)).append("</li>");
                            ++i2;
                        }
                        builder.append("</ul></body></html>");
                        JOptionPane.showMessageDialog(TargetSelectionPane.this, new String(builder), Messages.getString("unsupportedfiletype.dialog.title"), 0);
                    }
                }
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

