/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.ui.swing.mds;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import jp.naist.se.stigmata.ui.swing.mds.GeometoryType;
import jp.naist.se.stigmata.ui.swing.mds.MarkDrawer;
import jp.naist.se.stigmata.ui.swing.mds.mark.DrawerFactory;

class PointComponent
extends JLabel {
    private static final long serialVersionUID = 6945871049990818511L;
    public static final Color DEFAULT_OVER_COLOR = Color.BLUE;
    private boolean entered = false;
    private Color overColor = DEFAULT_OVER_COLOR;
    private String label;
    private MarkDrawer drawer;
    private JLabel showLabel = null;
    private List<ActionListener> listeners = new ArrayList<ActionListener>();

    public PointComponent(String label, double x, double y) {
        this(label);
        this.setToolTipText(String.format("%s [%g, %g]", label, x, y));
        this.drawer = DrawerFactory.getInstance().create(GeometoryType.UPPER_TRIANGLE);
    }

    public PointComponent(String label, double x, double y, MarkDrawer drawer) {
        this(label);
        this.drawer = drawer;
        this.setToolTipText(String.format("%s [%g, %g]", label, x, y));
    }

    public PointComponent(String label) {
        this.label = label;
        this.setSize(10, 10);
        this.setMinimumSize(this.getSize());
        this.setMaximumSize(this.getSize());
        this.setPreferredSize(this.getSize());
        this.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent e) {
                PointComponent.this.entered = true;
                if (PointComponent.this.showLabel != null) {
                    PointComponent.this.showLabel.setVisible(true);
                    PointComponent.this.showLabel.repaint();
                }
                PointComponent.this.repaint();
            }

            public void mouseExited(MouseEvent e) {
                PointComponent.this.entered = false;
                if (PointComponent.this.showLabel != null) {
                    PointComponent.this.showLabel.setVisible(false);
                    PointComponent.this.showLabel.repaint();
                }
                PointComponent.this.repaint();
            }

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() >= 2) {
                    ActionEvent ae = new ActionEvent(PointComponent.this, 0, null);
                    for (ActionListener listener : PointComponent.this.listeners) {
                        listener.actionPerformed(ae);
                    }
                }
            }
        });
        this.setToolTipText(this.label);
    }

    public void addActionListener(ActionListener listener) {
        this.listeners.add(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.listeners.remove(listener);
    }

    public void setShowLabel(JLabel label) {
        this.showLabel = label;
    }

    public JLabel getShowLabel() {
        return this.showLabel;
    }

    public String getLabel() {
        return this.label;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D gg = (Graphics2D)g;
        Stroke stroke = gg.getStroke();
        Dimension d = this.getSize();
        if (this.entered) {
            g.setColor(this.getOverColor());
            this.drawer.drawOver(gg, d.width, d.height);
        } else {
            g.setColor(this.getForeground());
            this.drawer.draw(gg, d.width, d.height);
        }
        gg.setStroke(stroke);
    }

    public Color getOverColor() {
        return this.overColor;
    }

    public void setOverColor(Color overColor) {
        this.overColor = overColor;
    }
}

