/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.ui.swing.tab;

import java.awt.FocusTraversalPolicy;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import jp.naist.se.stigmata.ui.swing.tab.EditableGlassPane;
import jp.naist.se.stigmata.ui.swing.tab.EditableTabbedPaneFocusTraversalPolicy;

public class EditableTabbedPane
extends JTabbedPane {
    private static final long serialVersionUID = -66174062280771547L;
    private final EditableGlassPane panel;
    private final JTextField editor;
    private final JFrame frame;
    private final FocusTraversalPolicy policy;
    private FocusTraversalPolicy ftp;

    public EditableTabbedPane(JFrame frame) {
        this.frame = frame;
        this.panel = new EditableGlassPane(this);
        this.editor = new JTextField();
        this.policy = new EditableTabbedPaneFocusTraversalPolicy(this.editor);
        this.editor.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
        this.editor.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                ((JTextField)e.getSource()).selectAll();
            }
        });
        this.editor.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    EditableTabbedPane.this.renameTab();
                } else if (e.getKeyCode() == 27) {
                    EditableTabbedPane.this.cancelEditing();
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent me) {
                if (me.getClickCount() == 2) {
                    EditableTabbedPane.this.startEditing();
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    EditableTabbedPane.this.startEditing();
                }
            }
        });
        frame.setGlassPane(this.panel);
        this.panel.add(this.editor);
        this.panel.setVisible(false);
    }

    void renameTab() {
        this.frame.setFocusTraversalPolicy(this.ftp);
        if (this.editor.getText().trim().length() > 0) {
            this.setTitleAt(this.getSelectedIndex(), this.editor.getText());
        }
        this.panel.setVisible(false);
    }

    private void startEditing() {
        this.initEditor();
        this.ftp = this.frame.getFocusTraversalPolicy();
        this.panel.setVisible(true);
        this.editor.requestFocusInWindow();
        this.frame.setFocusTraversalPolicy(this.policy);
    }

    private void cancelEditing() {
        this.frame.setFocusTraversalPolicy(this.ftp);
        this.panel.setVisible(false);
    }

    private void initEditor() {
        JMenuBar bar = this.frame.getJMenuBar();
        Rectangle rect = this.getUI().getTabBounds(this, this.getSelectedIndex());
        rect.setRect(rect.x + 2, rect.y + 2, rect.width - 2, rect.height - 2);
        if (bar != null) {
            rect.y += bar.getSize().height;
        }
        this.panel.setRectangle(rect);
        this.editor.setBounds(rect);
        this.editor.setText(this.getTitleAt(this.getSelectedIndex()));
    }
}

