package jp.naist.se.stigmata;

/*
 * $Id: ComparisonPairFilter.java 130 2007-06-13 10:08:01Z tama3 $
 */

import jp.naist.se.stigmata.filter.Criterion;
import jp.naist.se.stigmata.spi.ComparisonPairFilterSpi;

/**
 * Filtering results by some criteria.
 * For example,
 * <ul>
 *   <li>extract comparison pairs which similarity over 0.8, and</li>
 *   <li>extract comparison pairs which similarity over 0.8 and element count over 10.</li>
 * </ul>
 *
 * @author Haruaki TAMADA
 * @version $Revision: 130 $ $Date: 2007-06-13 19:08:01 +0900 (Wed, 13 Jun 2007) $
 */
public interface ComparisonPairFilter{
    public boolean isFiltered(ComparisonPair pair);

    public Criterion[] getAcceptableCriteria();

    public boolean isAcceptable(Criterion criterion);

    public void setCriterion(Criterion criterion);

    public Criterion getCriterion();

    public ComparisonPairFilterSpi getService();
}
